/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpEraseSelected;
import com.ge.med.cse.cvf.action.XpShowArrowAction;
import com.ge.med.cse.cvf.crossref.XpSliceCollectionRoi;
import com.ge.med.cse.cvf.model.XpROIPropagator;
import com.ge.med.cse.cvf.model.XpROIStatProvider;
import com.ge.med.cse.cvf.model.XpRangeModel;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;

public class XpROIStatisticsPanel
extends XPcaAutoControlPanel
implements PropertyChangeListener,
XpRoiEventListener {
    JLabel statLabel = new JLabel("");
    JPanel pan = new JPanel();
    JSeparator separator1 = new JSeparator(0);
    JButton applyButton = new JButton(CvUtils.getResourceBundle().getString("PROPAGATE_ROI_APPLY_BUTTON"));
    JButton eraseSelected = new JButton();
    ButtonGroup group = new ButtonGroup();
    JRadioButton allImage = new JRadioButton();
    JRadioButton imageForward = new JRadioButton();
    JRadioButton range = new JRadioButton();
    JPanel holder = new JPanel();
    JSpinner startRange = new JSpinner();
    JSpinner endRange = new JSpinner();
    JSeparator separator2 = new JSeparator(0);
    JLabel propROILabel = new JLabel(CvUtils.getResourceBundle().getString("PROPAGATE_ROI_LABEL"));
    JCheckBox userAnnotArrowCheck = new JCheckBox();
    XpRangeModel model = new XpRangeModel();
    XpEraseSelected selectEraseAction = new XpEraseSelected();
    XpROIStatProvider statProvider = null;
    XpShowArrowAction arrowAction = new XpShowArrowAction();
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    RoiActor actorForStatDisplay = null;
    UAMouseListener uaListener = new UAMouseListener();
    JLabel allImageInSeriesLabel = new JLabel(CvUtils.getResourceBundle().getString("ROI_PROP_ALL_IMAGE"));
    JLabel curretnImageForwardLabel = new JLabel(CvUtils.getResourceBundle().getString("ROI_PROP_IMAGE_FORWARD"));
    JLabel rangeLabel = new JLabel(CvUtils.getResourceBundle().getString("ROI_PROP_RANGE"));
    JLabel toLabel = new JLabel(CvUtils.getResourceBundle().getString("ROI_PROP_TO_LABEL"));
    private static int oldportidx = -1;

    public XpROIStatisticsPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateROIStatisticsPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating ROIStatisticsPanel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating ROIStatisticsPanel", tln);
    }

    private void initUI() {
        this.setIcon(CvUtils.getIcon("XPROI_STATS_PANEL_ICON"));
        this.setTitle(CvUtils.getResourceBundle().getString("STAT_PANEL_TITLE"));
        this.setLayout(new BorderLayout());
        this.eraseSelected.setAction(this.selectEraseAction);
        this.eraseSelected.setText("");
        this.startRange.setToolTipText("start");
        GridBagLayout layout = new GridBagLayout();
        this.statLabel.setName(XpROIStatisticsPanel.class.getName() + "statLabel");
        this.pan.setName(XpROIStatisticsPanel.class.getName() + "pan");
        this.separator1.setName(XpROIStatisticsPanel.class.getName() + "separator1");
        this.eraseSelected.setName(XpROIStatisticsPanel.class.getName() + "eraseSelected");
        this.allImage.setName(XpROIStatisticsPanel.class.getName() + "allImage");
        this.range.setName(XpROIStatisticsPanel.class.getName() + "range");
        this.holder.setName(XpROIStatisticsPanel.class.getName() + "holder");
        this.separator2.setName(XpROIStatisticsPanel.class.getName() + "separator2");
        this.propROILabel.setName(XpROIStatisticsPanel.class.getName() + "propROILabel");
        this.userAnnotArrowCheck.setName(XpROIStatisticsPanel.class.getName() + "userAnnotArrowCheck");
        this.allImageInSeriesLabel.setName(XpROIStatisticsPanel.class.getName() + "allImageInSeriesLabel");
        this.curretnImageForwardLabel.setName(XpROIStatisticsPanel.class.getName() + "curretnImageForwardLabel");
        this.rangeLabel.setName(XpROIStatisticsPanel.class.getName() + "rangeLabel");
        this.toLabel.setName(XpROIStatisticsPanel.class.getName() + "toLabel");
        this.holder.setLayout(layout);
        this.startRange.setName("startRange");
        this.endRange.setName("endRange");
        this.startRange.setEnabled(false);
        this.endRange.setEnabled(false);
        this.allImage.setSelected(true);
        this.applyButton.setFocusable(false);
        this.eraseSelected.setFocusable(false);
        this.allImage.setFocusable(false);
        this.imageForward.setFocusable(false);
        this.range.setFocusable(false);
        this.imageForward.setName("IMG_FORW");
        this.applyButton.setName("APPLY_BUT");
        this.userAnnotArrowCheck.setPreferredSize(new Dimension(this.userAnnotArrowCheck.getSize().width, 20));
        this.statLabel.setPreferredSize(new Dimension(this.statLabel.getSize().width, 20));
        this.holder.add((Component)new JLabel(""), new GridBagConstraints(6, 0, 1, 2, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.userAnnotArrowCheck, new GridBagConstraints(1, 0, 8, 1, 0.0, 0.0, 17, 2, new Insets(0, -20, 0, 0), 0, 0));
        this.holder.add((Component)this.statLabel, new GridBagConstraints(1, 0, 8, 1, 0.0, 0.0, 17, 2, new Insets(0, -20, 0, 0), 0, 0));
        this.holder.add((Component)this.separator1, new GridBagConstraints(0, 1, 8, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.holder.add((Component)this.propROILabel, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, -20, 0, 0), 0, 0));
        this.holder.add((Component)this.allImage, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.holder.add((Component)this.allImageInSeriesLabel, new GridBagConstraints(1, 3, 5, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.imageForward, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.holder.add((Component)this.curretnImageForwardLabel, new GridBagConstraints(1, 4, 5, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.range, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.holder.add((Component)this.rangeLabel, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.startRange, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.holder.add((Component)this.toLabel, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.holder.add((Component)this.endRange, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.applyButton, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.holder.add((Component)this.separator2, new GridBagConstraints(0, 7, 8, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.holder.add((Component)this.eraseSelected, new GridBagConstraints(1, 8, 6, 1, 0.0, 0.0, 17, 0, new Insets(10, -20, 0, 0), 0, 0));
        this.startRange.setPreferredSize(new Dimension(80, 30));
        this.endRange.setPreferredSize(new Dimension(80, 30));
        this.holder.setAutoscrolls(false);
        this.group.add(this.allImage);
        this.group.add(this.imageForward);
        this.group.add(this.range);
        this.userAnnotArrowCheck.setVisible(false);
        this.userAnnotArrowCheck.setFocusable(false);
        this.userAnnotArrowCheck.setSelected(true);
        this.userAnnotArrowCheck.setText(CvUtils.getResourceBundle().getString("XP_SHOW_ARROW_NAME"));
        this.userAnnotArrowCheck.setName("userAnnotSHOW_HIDE_arrow");
        this.userAnnotArrowCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] param = new String[]{XpROIStatisticsPanel.this.userAnnotArrowCheck.isSelected() ? "on" : "off"};
                XpROIStatisticsPanel.this.arrowAction.setParams(param);
                XpROIStatisticsPanel.this.arrowAction.actionPerformed(e);
            }
        });
        this.add((Component)this.holder, "North");
        this.range.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpROIStatisticsPanel.this.startRange.setEnabled(true);
                XpROIStatisticsPanel.this.endRange.setEnabled(true);
            }
        });
        this.allImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpROIStatisticsPanel.this.startRange.setEnabled(false);
                XpROIStatisticsPanel.this.endRange.setEnabled(false);
            }
        });
        this.imageForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpROIStatisticsPanel.this.startRange.setEnabled(false);
                XpROIStatisticsPanel.this.endRange.setEnabled(false);
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpROIPropagator model = new XpROIPropagator(XpROIStatisticsPanel.this.screen_);
                if (XpROIStatisticsPanel.this.allImage.isSelected()) {
                    model.propagateAll();
                } else if (XpROIStatisticsPanel.this.imageForward.isSelected()) {
                    model.propagateCurrentImageForward();
                } else if (XpROIStatisticsPanel.this.range.isSelected()) {
                    model.rangePropagation(Integer.parseInt(XpROIStatisticsPanel.this.startRange.getValue().toString()), Integer.parseInt(XpROIStatisticsPanel.this.endRange.getValue().toString()));
                }
                XpROIStatisticsPanel.this.finalEnable(null);
            }
        });
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.selectEraseAction.setCapable(screen);
        this.statProvider = new XpROIStatProvider(screen);
        screen.addPropertyChangeListener(this);
        this.arrowAction.setCapable(screen);
        FramePositioningCapable fpc = (FramePositioningCapable)this.screen_.getCapable(FramePositioningCapable.class.getName());
        this.startRange.setModel(this.model.getMinRangeSpinnerModel(fpc));
        this.endRange.setModel(this.model.getMaxRangeSpinnerModel(fpc));
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (this.userAnnotArrowCheck == null || this.statLabel == null || this.statLabel.getText() == null) {
            return;
        }
        if (this.userAnnotArrowCheck.isVisible() || !this.statLabel.getText().equals("")) {
            this.enableControls(true);
        } else {
            this.enableControls(false);
            this.hideUAandClearSTAT();
        }
    }

    private void enableControls(boolean status) {
        this.curretnImageForwardLabel.setEnabled(status);
        this.rangeLabel.setEnabled(status);
        this.allImageInSeriesLabel.setEnabled(status);
        this.statLabel.setEnabled(status);
        this.propROILabel.setEnabled(status);
        this.eraseSelected.setEnabled(status);
        this.allImage.setEnabled(status);
        this.applyButton.setEnabled(status);
        this.imageForward.setEnabled(status);
        this.range.setEnabled(status);
        this.toLabel.setEnabled(status);
        if (this.range.isSelected()) {
            this.startRange.setEnabled(status);
            this.endRange.setEnabled(status);
        }
    }

    private void enableUAArrow() {
        this.propROILabel.setText(CvUtils.getResourceBundle().getString("PROP_USER_ANNOT"));
        this.userAnnotArrowCheck.setVisible(true);
        this.statLabel.setVisible(false);
    }

    private void enableROIStat(String text) {
        this.userAnnotArrowCheck.setVisible(false);
        this.statLabel.setText(text);
        this.statLabel.setVisible(true);
    }

    private void hideUAandClearSTAT() {
        this.userAnnotArrowCheck.setVisible(false);
        this.statLabel.setText("");
        this.statLabel.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof CvImageGrid || evt.getNewValue() instanceof XpSliceCollectionRoi) {
            return;
        }
        if (evt.getPropertyName().equals("reference_vp_selection") && this.getSelectedROICount() <= 0 && this.getSelectedUACount() <= 0) {
            this.enableControls(false);
            this.hideUAandClearSTAT();
        }
        if (evt.getPropertyName().equalsIgnoreCase("CONTENT_CHANGED") || evt.getPropertyName().equalsIgnoreCase("")) {
            FramePositioningCapable fpc = (FramePositioningCapable)this.screen_.getCapable(FramePositioningCapable.class.getName());
            this.startRange.setModel(this.model.getMinRangeSpinnerModel(fpc));
            this.endRange.setModel(this.model.getMaxRangeSpinnerModel(fpc));
        } else if (evt.getPropertyName().equals("ROI_ADDED")) {
            RoiActor roi = (RoiActor)evt.getNewValue();
            roi.addRoiEventListener(this);
            RoiActor oldra = this.screen_.getRoi();
            if (oldra != null && roi.equals(oldra)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XpROIStatisticsPanel.this.statLabel.setText(XpROIStatisticsPanel.this.statProvider.getROIStat(XpROIStatisticsPanel.this.screen_.getRoi()));
                        XpROIStatisticsPanel.this.enableControls(true);
                        XpROIStatisticsPanel.this.enableROIStat(XpROIStatisticsPanel.this.statProvider.getROIStat(XpROIStatisticsPanel.this.screen_.getRoi()));
                        XpROIStatisticsPanel.this.propROILabel.setText(CvUtils.getResourceBundle().getString("XP_ROI_STAT_TITILE"));
                        XpROIStatisticsPanel.this.repaint();
                    }
                });
            }
        } else if (evt.getPropertyName().equals("ROI_REMOVED")) {
            RoiActor roi = (RoiActor)evt.getNewValue();
            roi.removeRoiEventListener(this);
            this.finalEnable(roi);
        } else if (evt.getPropertyName().equals("USERANNO_ADDED")) {
            if (evt.getNewValue() instanceof XpUserAnnotationModel) {
                XpUserAnnotationModel model = (XpUserAnnotationModel)evt.getNewValue();
                model.addMouseListener(this.uaListener);
                this.userAnnotArrowCheck.setSelected(model.isShowTarget());
            }
            this.enableROIStat("");
        } else if (evt.getPropertyName().equals("USERANNO_REMOVED")) {
            if (evt.getNewValue() instanceof XpUserAnnotationModel) {
                XpUserAnnotationModel model = (XpUserAnnotationModel)evt.getNewValue();
                model.removeMouseListener(this.uaListener);
            }
            this.enableControls(false);
            this.enableROIStat("");
        } else if (evt.getPropertyName().equalsIgnoreCase("graphics_cleared")) {
            this.enableROIStat("");
            this.enableControls(false);
        } else if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
            this.finalEnable(null);
        } else if (evt.getPropertyName().equals("Show_Arrow")) {
            boolean status = Boolean.parseBoolean(evt.getNewValue().toString());
            this.userAnnotArrowCheck.setSelected(status);
        }
    }

    @Override
    public void roiPressed(XpRoiEvent re) {
        this.finalEnable(re.getRoi());
    }

    @Override
    public void roiReleased(XpRoiEvent re) {
        this.finalEnable(re.getRoi());
    }

    @Override
    public void imageChanged(XpRoiEvent re) {
    }

    @Override
    public void roiDragged(XpRoiEvent re) {
        this.finalEnable(re.getRoi());
    }

    private int getSelectedROICount() {
        ROICapable roiCap = (ROICapable)this.screen_.getCapable(ROICapable.class.getName());
        int count = 0;
        if (roiCap == null) {
            return -1;
        }
        List actorList = roiCap.getRois();
        if (actorList == null) {
            return -1;
        }
        for (int i = 0; i < roiCap.getRois().size(); ++i) {
            RoiActor act = (RoiActor)actorList.get(i);
            if (!act.isSelected()) continue;
            ++count;
        }
        return count;
    }

    private int getSelectedUACount() {
        UserAnnoCapable uaCap = (UserAnnoCapable)this.screen_.getCapable(UserAnnoCapable.class.getName());
        if (uaCap == null) {
            return -1;
        }
        int count = 0;
        List actorList = uaCap.getUserAnnos();
        if (actorList == null) {
            return -1;
        }
        for (int i = 0; i < uaCap.getUserAnnos().size(); ++i) {
            XpUserAnnotationModel act = (XpUserAnnotationModel)actorList.get(i);
            if (!act.isSelected()) continue;
            ++count;
        }
        return count;
    }

    private void checkStatus(MouseEvent evt) {
        if (evt.getSource() instanceof XpUserAnnotationVc) {
            XpUserAnnotationVc uavc = (XpUserAnnotationVc)evt.getSource();
            if (uavc.getUserAnnotationModel().isShowTarget()) {
                this.userAnnotArrowCheck.setSelected(true);
            } else {
                this.userAnnotArrowCheck.setSelected(false);
            }
            return;
        }
        UserAnnoCapable usCap = (UserAnnoCapable)this.screen_.getCapable(UserAnnoCapable.class.getName());
        if (usCap != null && usCap.getUserAnnos().size() != 0) {
            List list = usCap.getUserAnnos();
            for (int i = 0; i < list.size(); ++i) {
                XpUserAnnotationModel model = (XpUserAnnotationModel)list.get(i);
                if (!model.isSelected()) continue;
                if (model.isShowTarget()) {
                    this.userAnnotArrowCheck.setSelected(true);
                    continue;
                }
                this.userAnnotArrowCheck.setSelected(false);
            }
        }
    }

    private void finalEnable(RoiActor actor) {
        int roiCount = this.getSelectedROICount();
        int uaCount = this.getSelectedUACount();
        if (actor != null) {
            this.propROILabel.setText(CvUtils.getResourceBundle().getString("XP_ROI_STAT_TITILE"));
            this.enableROIStat(this.statProvider.getROIStat(actor));
            this.enableControls(true);
        }
        if (roiCount + uaCount > 1) {
            this.userAnnotArrowCheck.setVisible(false);
            this.statLabel.setText("");
            this.statLabel.setVisible(true);
            this.propROILabel.setText(CvUtils.getResourceBundle().getString("PROP_OBJECT"));
            this.statLabel.setText(CvUtils.getResourceBundle().getString("STATPANEL_MULTIPLE_OBJ_SELECTED"));
            this.enableControls(true);
        } else if (uaCount > 0) {
            this.enableUAArrow();
            this.enableControls(true);
        } else if (roiCount > 0) {
            this.enableControls(true);
        } else if (roiCount <= 0 || uaCount <= 0) {
            this.enableControls(false);
            this.hideUAandClearSTAT();
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("PROPAGATE_ROI_LABEL");
    }

    private class UAMouseListener
    extends MouseAdapter {
        private UAMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XpROIStatisticsPanel.this.finalEnable(null);
            XpROIStatisticsPanel.this.checkStatus(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            XpROIStatisticsPanel.this.finalEnable(null);
            XpROIStatisticsPanel.this.checkStatus(e);
        }
    }
}

