/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.controls.CvConfigurableMouseController;
import com.ge.med.cse.cvf.controls.CvMouseControlManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class XpReferenceImageMouseController
extends CvConfigurableMouseController {
    private JComponent target;
    private CvMouseControlManager mcManager = CvMouseControlManager.getInstance();
    private XPscreen screen = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public List<Action> actonList = new ArrayList<Action>();
    private AncestorListener alistner = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JComponent ancestor = event.getComponent();
            XpReferenceImageMouseController.this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, ancestor);
            for (int i = 0; i < XpReferenceImageMouseController.this.actonList.size(); ++i) {
                Action act = XpReferenceImageMouseController.this.actonList.get(i);
                if (!(act instanceof PlasmaControl) || XpReferenceImageMouseController.this.screen == null) continue;
                ((PlasmaControl)((Object)act)).setCapable(XpReferenceImageMouseController.this.screen);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    };
    PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode = XpReferenceImageMouseController.this.mcManager.getMouseMode();
            if (XpReferenceImageMouseController.this.getLeftMouseButtonMode() != newMode) {
                XpReferenceImageMouseController.this.setLeftMouseButtonMode(newMode);
            }
        }
    };

    public XpReferenceImageMouseController() {
        try {
            String mouseActionCountString = CvPropertiesManager.getProperty("RefMouseMenu.Controller.count");
            if (mouseActionCountString != null) {
                int count = Integer.parseInt(mouseActionCountString);
                XpMouseController contoller = null;
                for (int i = 0; i < count; ++i) {
                    String compName = CvPropertiesManager.getProperty("RefMouseMenu.Controller." + String.valueOf(i));
                    while (compName == null || compName == "") {
                        ++count;
                        compName = CvPropertiesManager.getProperty("RefMouseMenu.Controller." + String.valueOf(++i));
                    }
                    Class<?> compClsass = Class.forName(compName);
                    contoller = (XpMouseController)compClsass.newInstance();
                    String modeString = CvPropertiesManager.getProperty("RefMouseMenu.Controller." + String.valueOf(i) + ".mode");
                    int mode = Integer.parseInt(modeString.trim());
                    String overwriteString = CvPropertiesManager.getProperty("RefMouseMenu.Controller." + String.valueOf(i) + ".overwrite");
                    boolean isOverwrite = Boolean.valueOf(overwriteString);
                    if (isOverwrite) {
                        String name = CvPropertiesManager.getProperty("RefMouseMenu.Controller." + String.valueOf(i) + ".name");
                        this.putModeProperty(mode, "name_property", name);
                        String shortDesc = CvUtils.getResourceBundle().getString("RefMouseMenu.Controller." + name + ".shortdesc");
                        this.putModeProperty(mode, "short_description_property", shortDesc);
                        ImageIcon icon = (ImageIcon)CvUtils.getIcon("RefMouseMenu.Controller." + name + ".icon");
                        this.putModeProperty(mode, "icon_property", icon);
                        Icon selectedIcon = CvUtils.getIcon("RefMouseMenu.Controller." + name + ".selectedicon");
                        this.putModeProperty(mode, "selected_icon_property", selectedIcon);
                        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2), name);
                        this.putModeProperty(mode, "cursor_property", cursor);
                    } else if (this.getModeProperty(mode, "name_property") == null && XpReferenceImageMouseController.getMouseModeProperty(mode, "name_property") != null) {
                        this.putModeProperty(mode, "name_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "name_property"));
                        this.putModeProperty(mode, "short_description_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "short_description_property"));
                        this.putModeProperty(mode, "icon_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "icon_property"));
                        this.putModeProperty(mode, "selected_icon_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "selected_icon_property"));
                        this.putModeProperty(mode, "cursor_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "cursor_property"));
                    } else if (this.getModeProperty(mode, "name_property") == null) {
                        this.putModeProperty(mode, "name_property", XpReferenceImageMouseController.getMouseModeProperty(mode, "name_property"));
                    }
                    this.installController(contoller, mode);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e.getLocalizedMessage());
        }
        if (this.mcManager.getMouseMode() != -1) {
            this.setLeftMouseButtonMode(this.mcManager.getMouseMode());
        } else {
            int defaultSelectionMode = Integer.parseInt(CvPropertiesManager.getProperty("MouseMenu.Controller.defaultMode"));
            this.setLeftMouseButtonMode(defaultSelectionMode);
            this.mcManager.setMouseMode(defaultSelectionMode);
        }
        int middleBtnMode = Integer.parseInt(CvPropertiesManager.getProperty("MouseMiddleButtonMode"));
        this.setMiddleButtonMode(middleBtnMode);
        try {
            String mouseActionCountStirng = CvPropertiesManager.getProperty("MouseMenu.group.count");
            if (mouseActionCountStirng != null) {
                int groupCount = Integer.parseInt(mouseActionCountStirng);
                Action act = null;
                for (int i = 0; i < groupCount; ++i) {
                    ArrayList<Action> list = new ArrayList<Action>();
                    int count = Integer.parseInt(CvPropertiesManager.getProperty("MouseMenu." + String.valueOf(i) + ".count"));
                    for (int j = 0; j < count; ++j) {
                        String compName = CvPropertiesManager.getProperty("MouseMenu." + String.valueOf(i) + "." + String.valueOf(j));
                        Class<?> compClsass = Class.forName(compName);
                        act = (Action)compClsass.newInstance();
                        list.add(act);
                    }
                    this.addActionGroup(list);
                    this.actonList.addAll(list);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unable to install Mouse Actions. " + e.getLocalizedMessage());
        }
        if (Boolean.valueOf(CvPropertiesManager.getProperty("EnableMouseModeSetting", "true")).booleanValue()) {
            this.mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
    }

    @Override
    public void setTarget(JComponent vc) {
        this.target = vc;
        super.setTarget(vc);
        this.mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
        if (this.target != null) {
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
            if (this.mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(this.mcManager.getMouseMode());
            }
        }
        this.mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
        if (this.target != null) {
            this.target.removeAncestorListener(this.alistner);
        }
        this.target = vc;
        super.setTarget(vc);
        if (this.target != null) {
            vc.addAncestorListener(this.alistner);
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
            if (this.mcManager.getMouseMode() != -1) {
                this.setLeftMouseButtonMode(this.mcManager.getMouseMode());
            }
        }
    }

    @Override
    public void setLeftMouseButtonMode(int mode) {
        if (this.impl_ != null) {
            this.impl_.setTarget(null);
            super.setLeftMouseButtonMode(mode);
            this.impl_.setTarget(this.target);
            this.mcManager.setMouseMode(mode);
        }
    }
}

