/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.MultiDatasetLoader;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class XpFusionImageDataLoader
implements MultiDatasetLoader,
Observer,
Runnable,
PropertyChangeListener {
    volatile boolean isInterrupted = false;
    private JComponent[] ports = null;
    private DatasetModel[] models = null;
    private TaskMonitor taskMitor = null;
    private volatile int frameIndex = 0;

    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void load(JComponent[] ports, DatasetModel[] models, Properties prop, TaskMonitor monitor) {
        this.ports = ports;
        this.models = models;
        this.taskMitor = monitor;
        ports[1].addPropertyChangeListener("FrameIndex", this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (!(this.ports[0] instanceof XpCompositePort)) return;
        if (this.models.length != 2) throw new RuntimeException("Can not support more than two data set");
        Object obj1 = this.models[0].getDataset().getData();
        Object obj2 = this.models[1].getDataset().getData();
        if (!(obj1 instanceof DMObject) || !(obj2 instanceof DMObject)) throw new RuntimeException("Invalid data from model");
        try {
            DMObject dmo1 = (DMObject)obj1;
            DMObject dmo2 = (DMObject)obj2;
            String modObj0 = dmo1.getValue(8, 96).toString();
            String modObj1 = dmo2.getValue(8, 96).toString();
            DMObject dmoCT = null;
            DMObject dmoPT = null;
            if (modObj0.equalsIgnoreCase("CT") && modObj1.equalsIgnoreCase("PT")) {
                dmoCT = dmo1;
                dmoPT = dmo2;
            } else if (modObj0.equalsIgnoreCase("PT") && modObj1.equalsIgnoreCase("CT")) {
                dmoPT = dmo1;
                dmoCT = dmo2;
            }
            if (dmoCT != null && dmoPT != null && DatasetLoaderUtils.isFusionValid(dmoCT, dmoPT)) {
                DMObject[][] ctpet = DatasetLoaderUtils.filterMatchingSlieces(dmoCT, dmoPT);
                if (ctpet == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.ports[0]), CvUtils.getResourceBundle().getObject("ERROR_MATCHING_SLICE_NOT_FOUND"), CvUtils.getResourceBundle().getString("MEDIA_VIEWER_TITLE"), 0);
                    return;
                }
                DMTag[] tagsCT = DatasetLoaderUtils.getNeededTags(dmoCT);
                DMTag[] tagsPT = DatasetLoaderUtils.getNeededTags(dmoPT);
                DMObject[] ctDMO = ctpet[0];
                DMObject[] ptDMO = ctpet[1];
                final XpCompositePort compPortCT = (XpCompositePort)this.ports[0];
                final XpCompositePort compPortPT = (XpCompositePort)this.ports[1];
                final XpCompositePort compPortFusion = (XpCompositePort)this.ports[2];
                compPortCT.setImages(new XjImage[ctDMO.length]);
                compPortPT.setImages(new XjImage[ctDMO.length]);
                compPortFusion.setImages(new XjImage[ctDMO.length]);
                int size = ctDMO.length;
                int totalnumberOfImagesShow = 0;
                this.taskMitor.taskBegin("DATA_LOADING_TASK_2D_FUSION_IMAGE", size);
                int numberOfImages = ctDMO.length;
                final Boolean[] isPaintComplated = new Boolean[numberOfImages];
                this.taskMitor.taskProgress("DATA_LOADING_TASK_2D_FUSION_IMAGE", totalnumberOfImagesShow);
                while (totalnumberOfImagesShow != numberOfImages) {
                    int temp;
                    if (this.isInterrupted) {
                        return;
                    }
                    if (this.frameIndex + 1 > numberOfImages) {
                        this.frameIndex = 0;
                    }
                    if (isPaintComplated[temp = this.frameIndex] == null) {
                        if (this.isInterrupted) {
                            return;
                        }
                        final XpMedicalImage[] imgsCT = XpMedicalDmImage.wrapDMImages(ctDMO[temp].getImages(tagsCT));
                        final XpMedicalImage[] imgsPT = XpMedicalDmImage.wrapDMImages(ptDMO[temp].getImages(tagsPT));
                        final int toSet = temp;
                        if (this.isInterrupted) {
                            return;
                        }
                        final int toNonotify = totalnumberOfImagesShow;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    compPortCT.replaceImage(imgsCT[0], toSet);
                                    compPortPT.replaceImage(imgsPT[0], toSet);
                                    compPortFusion.replaceImage(imgsPT[0], toSet);
                                    XpImageLayer layer = new XpImageLayer(imgsCT[0]);
                                    layer.resetWindowing();
                                    compPortFusion.refreshContents();
                                    compPortFusion.getScene(toSet).addImageLayer(layer);
                                    compPortFusion.refreshContents();
                                    if (toNonotify == 0) {
                                        compPortFusion.refresh();
                                    }
                                    isPaintComplated[temp] = true;
                                    XpFusionImageDataLoader.this.taskMitor.taskProgress("DATA_LOADING_TASK_2D_FUSION_IMAGE", toNonotify);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++totalnumberOfImagesShow;
                    }
                    ++this.frameIndex;
                }
                this.taskMitor.taskDone("DATA_LOADING_TASK_2D_FUSION_IMAGE");
                return;
            }
            this.taskMitor.taskFailed("DATA_LOADING_TASK_2D_FUSION_IMAGE", "INVALID_FUSION_IMAGE", null);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            this.ports[1].removePropertyChangeListener("FrameIndex", this);
            this.ports = null;
            this.models = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newIndex = ((CvSeriesDisplayer)evt.getSource()).getFrameIndex();
        this.frameIndex = newIndex - 1;
    }
}

