/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.terra.tap.dm.DMObject;
import java.text.NumberFormat;

public class APFormatter
implements Formatter {
    private String result = null;

    public Object format(DMObject obj) {
        this.result = "";
        if (obj != null) {
            String ULHC = (String)obj.getValue(32, 50);
            String URBRHC = (String)obj.getValue(32, 55);
            String pixelSpacing = (String)obj.getValue(40, 48);
            Object imH = obj.getValue(40, 16);
            Object imW = obj.getValue(40, 17);
            if (ULHC == null || URBRHC == null || pixelSpacing == null || imH == null || imW == null) {
                this.result = " ";
                return this.result;
            }
            try {
                float imageHeight = Float.parseFloat(imH.toString());
                float imageWidth = Float.parseFloat(imW.toString());
                String[] pixelSp = pixelSpacing.split("\\\\");
                float pixelY = Float.parseFloat(pixelSp[0]);
                float pixelX = Float.parseFloat(pixelSp[1]);
                float norm_row = pixelX * imageWidth;
                float norm_col = pixelY * imageHeight;
                String[] dirCos = URBRHC.split("\\\\");
                float rowP = Float.parseFloat(dirCos[1]);
                float colP = Float.parseFloat(dirCos[4]);
                String[] ulhc_values = ULHC.split("\\\\");
                float tlhc_A = Float.parseFloat(ulhc_values[1]) * -1.0f;
                float trhc_A = tlhc_A - rowP * norm_row;
                float brhc_A = trhc_A - colP * norm_col;
                float ctr_A = (brhc_A + tlhc_A) / 2.0f;
                float EPSILON = 0.001f;
                this.result = (double)ctr_A >= 0.0 || Math.abs(ctr_A) < 0.001f ? "A " : "P ";
                NumberFormat nmFormat = NumberFormat.getInstance();
                nmFormat.setMinimumFractionDigits(1);
                this.result = this.result + nmFormat.format(Math.abs(ctr_A));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.result;
    }
}

