/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.formatter;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMObject;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class TiltFormatter
implements Formatter {
    private String result = null;

    public Object format(DMObject objToformat) {
        String mod = DicomUtils.getModality(objToformat);
        if (mod.equals("CT")) {
            String setype = DicomUtils.getImageType(objToformat, false);
            if (setype == null || setype.equalsIgnoreCase("UNKNOWN")) {
                return this.result;
            }
            if (setype.equals("CTINT")) {
                this.result = " ";
            } else {
                NumberFormat nmFormat = NumberFormat.getInstance();
                nmFormat.setMaximumFractionDigits(1);
                nmFormat.setMinimumFractionDigits(1);
                String imgtype = (String)objToformat.getValue(8, 8);
                String gantilt = (String)objToformat.getValue(24, 4384);
                if (imgtype != null) {
                    StringTokenizer tok = new StringTokenizer(imgtype, "\\");
                    int index = 0;
                    boolean digitaltilt = false;
                    while (tok.hasMoreElements()) {
                        String st = (String)tok.nextElement();
                        if (index != 3 || !st.equals("DIGITALTILT") || gantilt == null) continue;
                        this.result = "" + nmFormat.format(new Float(gantilt).floatValue()) + "(D)";
                        digitaltilt = true;
                        break;
                    }
                    if (!digitaltilt && gantilt != null) {
                        this.result = "" + nmFormat.format(new Float(gantilt).floatValue());
                    }
                }
            }
        }
        return this.result;
    }
}

