/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.cse.cvf.j3d.utils.DicomDiff;
import com.ge.med.cse.cvf.j3d.utils.DicomDiffTableModel;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.marker.XpPointMarker;
import com.ge.med.terra.jami.platform.dm.XpDMSessionProvider;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.util.dicom.dicomInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class CompareViewer
extends JPanel
implements PropertyChangeListener {
    protected JPanel datasetPanel = new JPanel();
    protected JTabbedPane firstTabbedPane = new JTabbedPane();
    protected XpImageViewport firstViewport = new XpImageViewport();
    protected dicomInfo firstTagView = new dicomInfo();
    protected JTabbedPane secondTabbedPane = new JTabbedPane();
    protected XpImageViewport secondViewport = new XpImageViewport();
    protected dicomInfo secondTagView = new dicomInfo();
    protected JPanel diffPanel = new JPanel();
    protected JTabbedPane diffTabbedPane = new JTabbedPane();
    protected XpImageViewport diffViewport = new XpImageViewport();
    protected JScrollPane diffTagView = new JScrollPane();
    protected JTable diffTagTable = new JTable();
    protected DicomDiffTableModel diffTableModel = new DicomDiffTableModel();
    protected JPanel reportPanel = new JPanel();
    protected JCheckBox nnCheckBox = new JCheckBox("Nearest Neighbor");
    protected JLabel firstPixelValue = new JLabel("First value = 0");
    protected JLabel secondPixelValue = new JLabel("Second value = 0");
    protected JLabel diffPixelValue = new JLabel("Diff value = 0");
    protected JScrollBar scrollBar = new JScrollBar(1);
    protected XpPointMarker firstPointMarker;
    protected XpPointMarker secondPointMarker;
    protected XpPointMarker diffPointMarker;
    protected XjImage[] firstDataset = null;
    protected XjImage[] secondDataset = null;
    protected int numFrames = 0;

    public CompareViewer() {
        this(null, null);
    }

    public CompareViewer(String[] args1, String[] args2) {
        this.initUI();
        this.setFirstDataset(args1);
        this.setSecondDataset(args2);
    }

    protected void initUI() {
        this.setLayout(new GridLayout(2, 1));
        this.datasetPanel.setLayout(new BorderLayout());
        this.firstViewport.setPreferredSize(new Dimension(512, 512));
        this.firstViewport.setSharedRenderAttributes(true);
        this.firstViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.firstPointMarker = new XpPointMarker(200.0, 200.0);
        this.firstPointMarker.addPropertyChangeListener(this);
        this.firstViewport.getMedicalImageVc().getImageVc().add(this.firstPointMarker);
        this.firstTabbedPane.add("Gold Images", this.firstViewport);
        this.firstTabbedPane.add("Gold Dicom Tags", this.firstTagView);
        this.datasetPanel.add((Component)this.firstTabbedPane, "West");
        this.secondViewport.setPreferredSize(new Dimension(512, 512));
        this.secondViewport.setSharedRenderAttributes(true);
        this.secondViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.secondPointMarker = new XpPointMarker(200.0, 200.0);
        this.secondPointMarker.addPropertyChangeListener(this);
        this.secondViewport.getMedicalImageVc().getImageVc().add(this.secondPointMarker);
        this.secondTabbedPane.add("Test Images", this.secondViewport);
        this.secondTabbedPane.add("Test Dicom Tags", this.secondTagView);
        this.datasetPanel.add((Component)this.secondTabbedPane, "Center");
        this.scrollBar.setMinimum(0);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                CompareViewer.this.setFrame(((JScrollBar)e.getSource()).getValue());
            }
        });
        this.datasetPanel.add((Component)this.scrollBar, "East");
        this.add(this.datasetPanel);
        this.diffPanel.setLayout(new BorderLayout());
        this.diffViewport.setPreferredSize(new Dimension(512, 512));
        this.diffViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.diffPointMarker = new XpPointMarker(200.0, 200.0);
        this.diffPointMarker.addPropertyChangeListener(this);
        this.diffViewport.getMedicalImageVc().getImageVc().add(this.diffPointMarker);
        this.diffTagTable.setModel(this.diffTableModel);
        this.diffTagTable.getColumnModel().getColumn(2).setPreferredWidth(5);
        this.diffTagTable.getColumnModel().getColumn(4).setPreferredWidth(5);
        this.diffTagView.setHorizontalScrollBarPolicy(30);
        this.diffTagView.setVerticalScrollBarPolicy(20);
        this.diffTagView.getViewport().add(this.diffTagTable);
        this.diffTabbedPane.add("Diff Images", this.diffViewport);
        this.diffTabbedPane.add("Diff Dicom Tags", this.diffTagView);
        this.diffPanel.add((Component)this.diffTabbedPane, "West");
        this.reportPanel.setLayout(new GridLayout(0, 1));
        this.nnCheckBox.setSelected(true);
        this.nnCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareViewer.this.setNearestNeighbor(CompareViewer.this.nnCheckBox.isSelected());
            }
        });
        this.reportPanel.add(this.nnCheckBox);
        this.reportPanel.add(this.firstPixelValue);
        this.reportPanel.add(this.secondPixelValue);
        this.reportPanel.add(this.diffPixelValue);
        this.diffPanel.add((Component)this.reportPanel, "Center");
        this.add(this.diffPanel);
        this.firstViewport.addPropertyChangeListener(this);
        this.secondViewport.addPropertyChangeListener(this);
        this.diffViewport.addPropertyChangeListener(this);
    }

    public void setFirstDataset(String[] args) {
        this.firstDataset = null;
        this.loadDataset(this.firstViewport, args);
    }

    public void setFirstDataset(XjImage[] imgs) {
        this.firstDataset = imgs;
        this.loadDataset(this.firstViewport, imgs);
    }

    public void setSecondDataset(String[] args) {
        this.secondDataset = null;
        this.loadDataset(this.secondViewport, args);
    }

    public void setSecondDataset(XjImage[] imgs) {
        this.secondDataset = imgs;
        this.loadDataset(this.secondViewport, imgs);
    }

    protected void loadDataset(XpImageViewport vp, String[] args) {
        XpMedicalImage[] imgs = null;
        if (args != null) {
            XpDMSessionProvider dmsp = new XpDMSessionProvider(args);
            dmsp.printESInfo();
            dmsp.setExamSeries(0, 2);
            dmsp.printESInfo();
            imgs = dmsp.getImages();
        } else {
            imgs = new XpMedicalImage[]{};
        }
        this.loadDataset(vp, imgs);
    }

    protected void loadDataset(XpImageViewport vp, XpMedicalImage[] imgs) {
        this.sortImages(imgs);
        vp.setImages(imgs);
        this.updateScrollbar();
        this.loadDiffImages();
        this.repaint();
    }

    protected void loadDataset(XpImageViewport vp, XjImage[] imgs) {
        this.sortImages(imgs);
        vp.setImages(imgs);
        this.updateScrollbar();
        this.loadDiffImages();
        this.repaint();
    }

    protected void updateScrollbar() {
        this.scrollBar.setMinimum(0);
        this.numFrames = Math.min(this.firstViewport.getNumFrames(), this.secondViewport.getNumFrames());
        this.scrollBar.setMaximum(this.numFrames - 1);
    }

    protected void loadDiffImages() {
        this.diffViewport.setImages(new XpMedicalImage[0]);
        for (int i = 0; i < this.numFrames; ++i) {
            XpImage img1 = this.firstViewport.getImageAt(i);
            XpImage img2 = this.secondViewport.getImageAt(i);
            int type = ((BufferedImage)img1.getPixelData()).getType();
            BufferedImage diffBufferedImage = new BufferedImage(img1.getPixelData().getWidth(), img1.getPixelData().getHeight(), type);
            XpBufferedImage diffImage = new XpBufferedImage(diffBufferedImage);
            XpImageUtils.PixelDiff diffStats = CompareViewer.diff(img1, img2, diffImage);
            this.diffViewport.addImage(diffImage);
            this.diffViewport.setWindowing(diffImage.getDefaultWindowWidth(), diffImage.getDefaultWindowLevel());
        }
        this.diffViewport.setFrame(this.firstViewport.getFrameIndex());
    }

    public void setFrame(int frame) {
        this.firstViewport.setFrame(frame);
        XpImage image1 = this.firstViewport.getFrame();
        String filePath1 = null;
        if (image1 instanceof XpMedicalDmImage) {
            filePath1 = ((XpMedicalDmImage)image1).getDMImage().getFilePath();
        } else if (image1 instanceof XjMedicalImage) {
            filePath1 = this.firstDataset[frame].getFilePath();
        }
        if (filePath1 != null) {
            this.firstTagView.setFile(filePath1);
        }
        this.secondViewport.setFrame(frame);
        XpImage image2 = this.secondViewport.getFrame();
        String filePath2 = null;
        if (image2 instanceof XpMedicalDmImage) {
            filePath2 = ((XpMedicalDmImage)image2).getDMImage().getFilePath();
        } else if (image2 instanceof XjMedicalImage) {
            filePath2 = this.secondDataset[frame].getFilePath();
        }
        if (filePath2 != null) {
            this.secondTagView.setFile(filePath2);
        }
        this.diffViewport.setFrame(frame);
        if (filePath1 != null && filePath2 != null) {
            try {
                this.diffTableModel.setData(DicomDiff.diffTags(filePath1, filePath2));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.scrollBar.setValue(frame);
        this.repaint();
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected void setNearestNeighbor(boolean nnEnabled) {
        if (nnEnabled) {
            this.firstViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.secondViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.diffViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.repaint();
        } else {
            this.firstViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.secondViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.diffViewport.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.repaint();
        }
    }

    protected void sortImages(XpMedicalImage[] images) {
        Arrays.sort(images, new Comparator(){

            public int compare(Object o1, Object o2) {
                XpMedicalImage img1 = (XpMedicalImage)o1;
                XpMedicalImage img2 = (XpMedicalImage)o2;
                XpDicomElement dicomElem = new XpDicomElement(32, 19);
                img1.getValue(dicomElem);
                int imgNum1 = dicomElem.getIntValue();
                img2.getValue(dicomElem);
                int imgNum2 = dicomElem.getIntValue();
                if (imgNum1 < imgNum2) {
                    return -1;
                }
                if (imgNum1 > imgNum2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected void sortImages(XjImage[] images) {
        Arrays.sort(images, new Comparator(){

            public int compare(Object o1, Object o2) {
                XjImage img1 = (XjImage)o1;
                XjImage img2 = (XjImage)o2;
                XpDicomElement dicomElem = new XpDicomElement(32, 19);
                dicomElem.value = img1.getValue(dicomElem.group, dicomElem.element);
                int imgNum1 = dicomElem.getIntValue();
                dicomElem.value = img2.getValue(dicomElem.group, dicomElem.element);
                int imgNum2 = dicomElem.getIntValue();
                if (imgNum1 < imgNum2) {
                    return -1;
                }
                if (imgNum1 > imgNum2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("winMin") && evt.getSource() != this.diffViewport) {
            double winMin = ((WindowLevelCapable)evt.getSource()).getWinMin();
            this.firstViewport.setWinMin(winMin);
            this.secondViewport.setWinMin(winMin);
        } else if (evt.getPropertyName().equals("winMax") && evt.getSource() != this.diffViewport) {
            double winMax = ((WindowLevelCapable)evt.getSource()).getWinMax();
            this.firstViewport.setWinMax(winMax);
            this.secondViewport.setWinMax(winMax);
        } else if (evt.getPropertyName().equals("pan")) {
            double panX = ((PanZoomCapable)evt.getSource()).getPanX();
            double panY = ((PanZoomCapable)evt.getSource()).getPanY();
            if (this.firstViewport.getPanX() != panX && this.firstViewport.getPanY() != panY) {
                this.firstViewport.setPan(panX, panY);
            }
            if (this.secondViewport.getPanX() != panX && this.secondViewport.getPanY() != panY) {
                this.secondViewport.setPan(panX, panY);
            }
            if (this.diffViewport.getPanX() != panX && this.diffViewport.getPanY() != panY) {
                this.diffViewport.setPan(panX, panY);
            }
        } else if (evt.getPropertyName().equals("zoom")) {
            double zoom = ((PanZoomCapable)evt.getSource()).getZoom();
            if (this.firstViewport.getZoom() != zoom) {
                this.firstViewport.setZoom(zoom);
            }
            if (this.secondViewport.getZoom() != zoom) {
                this.secondViewport.setZoom(zoom);
            }
            if (this.diffViewport.getZoom() != zoom) {
                this.diffViewport.setZoom(zoom);
            }
        }
        if (evt.getPropertyName().equals("VALUE_PROP")) {
            this.firstPixelValue.setText("First value = " + this.adjustValue(this.firstPointMarker.getValue(), this.firstViewport));
            this.secondPixelValue.setText("Second value = " + this.adjustValue(this.secondPointMarker.getValue(), this.secondViewport));
            this.diffPixelValue.setText("Diff value = " + this.adjustValue(this.diffPointMarker.getValue(), this.diffViewport));
            this.reportPanel.repaint();
        }
    }

    protected double adjustValue(double value, XpImageViewport vp) {
        return value * vp.getImageAt(vp.getFrameIndex()).getRescaleSlope() + vp.getImageAt(vp.getFrameIndex()).getRescaleIntercept();
    }

    public static XpImageUtils.PixelDiff diff(XpImage img1, XpImage img2, XpBufferedImage resImg) {
        BufferedImage buffImg1 = (BufferedImage)img1.getPixelData();
        BufferedImage buffImg2 = (BufferedImage)img2.getPixelData();
        BufferedImage res = (BufferedImage)resImg.getPixelData();
        int type1 = buffImg1.getType();
        int type2 = buffImg2.getType();
        DataBuffer db1 = buffImg1.getRaster().getDataBuffer();
        DataBuffer db2 = buffImg2.getRaster().getDataBuffer();
        DataBuffer dbr = res.getRaster().getDataBuffer();
        XpImageUtils.PixelDiff ps = new XpImageUtils.PixelDiff(1);
        resImg.setRescaleIntercept(img1.getRescaleIntercept());
        resImg.setRescaleSlope(img1.getRescaleSlope());
        double intercept1 = img1.getRescaleIntercept();
        double slope1 = img1.getRescaleSlope();
        double intercept2 = img2.getRescaleIntercept();
        double slope2 = img2.getRescaleSlope();
        if (type1 == 11 && type2 == 11) {
            short[] buff1 = null;
            short[] buff2 = null;
            short[] out = ((DataBufferUShort)dbr).getData();
            buff1 = ((DataBufferUShort)db1).getData();
            buff2 = ((DataBufferUShort)db2).getData();
            for (int i = 0; i < buff2.length; ++i) {
                short p1 = buff1[i];
                short p2 = buff2[i];
                double dp = Math.abs((double)p2 * slope2 + intercept2 - ((double)p1 * slope1 + intercept1));
                double sdp = dp * dp;
                double adp = Math.abs(dp);
                ps.diff[0] = (long)((double)ps.diff[0] + adp);
                ps.rms[0] = ps.rms[0] + sdp;
                out[i] = (short)((dp - intercept1) / slope1);
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff2.length);
        }
        return ps;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Compare Viewer");
        String[] args1 = null;
        String[] args2 = null;
        if (args.length == 1) {
            args1 = new String[]{"file", args[0]};
        } else if (args.length == 2) {
            args1 = new String[]{"file", args[0]};
            args2 = new String[]{"file", args[1]};
        }
        CompareViewer viewer = new CompareViewer(args1, args2);
        frame.setLocation(30, 0);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(viewer);
        frame.pack();
        frame.setVisible(true);
    }
}

