/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BatchParallelTaskManager {
    int nThreads = Integer.parseInt(CvPropertiesManager.getProperty("vav.autobatch.threadpool.numthreads", "2"));
    PausableThreadPoolExecutor pausableExec = new PausableThreadPoolExecutor(this.nThreads);
    PausableThreadPoolExecutor sinThreadExec = new PausableThreadPoolExecutor(1){

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            BatchParallelTaskManager.this.pausableExec.pause();
            super.beforeExecute(t, r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (this.getActiveCount() <= 1) {
                BatchParallelTaskManager.this.pausableExec.resume();
            }
            super.afterExecute(r, t);
        }
    };

    public void addBatchTask(Runnable task) {
        this.pausableExec.submit(task);
    }

    public void addBatchTasks(Runnable[] tasks) {
        for (int i = 0; i < tasks.length; ++i) {
            this.addBatchTask(tasks[i]);
        }
    }

    public void addManualTask(Runnable task) {
        this.sinThreadExec.submit(task, "ManualTask");
    }

    public void pause() {
        this.pausableExec.pause();
        this.sinThreadExec.pause();
    }

    public void resume() {
        this.pausableExec.resume();
        this.sinThreadExec.resume();
    }

    public void shutdown() {
        this.pausableExec.shutdown();
        this.sinThreadExec.shutdown();
    }

    private static class PausableThreadPoolExecutor
    extends ThreadPoolExecutor {
        private boolean isPaused;
        private ReentrantLock pauseLock = new ReentrantLock();
        private Condition unpaused = this.pauseLock.newCondition();

        public PausableThreadPoolExecutor(int nThreads) {
            super(nThreads, nThreads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.pauseLock.lock();
            try {
                while (this.isPaused) {
                    this.unpaused.await();
                }
            }
            catch (InterruptedException ie) {
                t.interrupt();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public void pause() {
            this.pauseLock.lock();
            try {
                this.isPaused = true;
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public void resume() {
            this.pauseLock.lock();
            try {
                this.isPaused = false;
                this.unpaused.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
        }
    }
}

