/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.log;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class GESysLogFormatter
extends Formatter {
    private final String newline_regex = "[\n]";
    private final String tid_regex = "TID=[^ ]+";
    private final String sev_regex = "SEV[0-9]+";

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer result = new StringBuffer();
        result.append(record.getLevel().getName() + " ");
        Date d = new Date(record.getMillis());
        result.append(d.toString() + " ");
        String message = this.formatMessage(record);
        message = message.replaceAll("TID=[^ ]+", "");
        message = message.replaceAll("SEV[0-9]+", "");
        result.append(message.replaceAll("[\n]", "\\n"));
        result.append('\n');
        return result.toString();
    }

    public static String toLoggableString(Object[] array) {
        if (array == null) {
            return "<null>";
        }
        if (array.length == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer("{");
        int len = array.length;
        if (len > 3) {
            len = 3;
        }
        for (int i = 0; i < len; ++i) {
            Object arg = array[i];
            if (arg instanceof Object[]) {
                buf.append(GESysLogFormatter.toLoggableString((Object[])array[i]));
            } else {
                buf.append(array[i].toString());
            }
            buf.append(", ");
        }
        if (len < array.length) {
            buf.append("...");
        }
        buf.append('}');
        return buf.toString();
    }
}

