/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.log;

import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.log.UserMsgUI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class UserMessageHandler
extends Handler {
    private HashSet<UserMsgUI> registeredcb = new HashSet();
    private UserMsgUI activeCallBack;

    public UserMessageHandler() {
        try {
            String strFilter = LogManager.getLogManager().getProperty(this.getClass().getName() + ".filter");
            if (strFilter != null) {
                this.setFilter((Filter)Class.forName(strFilter).newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void registerCallBack(UserMsgUI cb) {
        this.registeredcb.add(cb);
    }

    void setActiveCallBack(UserMsgUI cb) {
        this.activeCallBack = cb;
    }

    public void removeCallBack(UserMsgUI cb) {
        this.registeredcb.remove(cb);
        if (this.activeCallBack == cb) {
            this.activeCallBack = null;
        }
    }

    @Override
    public void close() throws SecurityException {
        Iterator<UserMsgUI> iter = this.registeredcb.iterator();
        while (iter.hasNext()) {
            try {
                iter.next().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void flush() {
        this.activeCallBack.flush();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.activeCallBack != null && this.isLoggable(record)) {
            this.activeCallBack.publish(record);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.getFilter() != null) {
            return this.getFilter().isLoggable(record);
        }
        return record.getLevel().intValue() == UserMessageLevel.USER_MSG.intValue();
    }
}

