/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.print;

import com.ge.med.cse.cvf.print.DndPrint;
import com.ge.med.cse.cvf.print.ForcePrint;
import com.ge.med.cse.cvf.print.IOSPrintService;
import com.ge.med.cse.cvf.print.IOSPrintUtil;
import com.ge.med.cse.cvf.print.LargePrint;
import com.ge.med.cse.cvf.print.MIDPrint;
import com.ge.med.cse.cvf.print.PrintProgress;
import com.ge.med.cse.cvf.print.PrintRowColFormat;
import com.ge.med.cse.cvf.print.SeriesPrint;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.terra.jfk.JFilmer;
import com.ge.med.terra.jfk.JImageSource;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class IOSPrinterJob
extends PrinterJob
implements DocPrintJob {
    IOSPrintService service = null;
    int numCopies = 1;
    String jobName = "default";
    Pageable document = null;
    Printable painter = null;
    PageFormat format = null;
    PrintRequestAttributeSet attributes = null;
    int rows = 0;
    int cols = 0;
    boolean seriesPrintRequest = false;
    boolean forcePrintRequest = false;
    boolean dnd = false;
    boolean mid = false;
    boolean isalive = false;
    boolean large = false;
    Dimension portSize = null;
    static boolean seriesPrintInProgress = false;
    static Dimension imageSize = new Dimension(512, 512);
    static Dimension imageSizeMID = new Dimension(1024, 1024);
    static Dimension largeImageSize = new Dimension(1024, 1024);
    Vector printjobAttirbuteListVect = new Vector();
    Vector printjobListVect = new Vector();
    Logger logger = Logger.getLogger(this.getClass().getName());

    public IOSPrinterJob(IOSPrintService servc) {
        this.service = servc;
    }

    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        this.printjobAttirbuteListVect.add(listener);
    }

    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        this.printjobListVect.add(listener);
    }

    @Override
    public PrintJobAttributeSet getAttributes() {
        HashPrintJobAttributeSet attrset = new HashPrintJobAttributeSet();
        if (this.attributes == null) {
            return attrset;
        }
        if (this.attributes.containsKey(PrintRowColFormat.class)) {
            attrset.add(this.attributes.get(PrintRowColFormat.class));
        }
        if (this.attributes.containsKey(SeriesPrint.class)) {
            attrset.add(this.attributes.get(SeriesPrint.class));
        }
        if (this.attributes.containsKey(ForcePrint.class)) {
            attrset.add(this.attributes.get(ForcePrint.class));
        }
        if (this.attributes.containsKey(DndPrint.class)) {
            attrset.add(this.attributes.get(DndPrint.class));
        }
        if (this.attributes.containsKey(PrintProgress.class)) {
            attrset.add(this.attributes.get(PrintProgress.class));
        }
        if (this.attributes.containsKey(MIDPrint.class)) {
            attrset.add(this.attributes.get(MIDPrint.class));
        }
        if (this.attributes.containsKey(LargePrint.class)) {
            attrset.add(this.attributes.get(LargePrint.class));
        }
        return attrset;
    }

    @Override
    public void print(final Doc doc, PrintRequestAttributeSet attr) throws PrintException {
        this.attributes = attr;
        if (seriesPrintInProgress) {
            return;
        }
        Thread thr = new Thread(){

            @Override
            public void run() {
                try {
                    if (IOSPrinterJob.this.attributes != null) {
                        IOSPrinterJob.this.setAttributeValues(IOSPrinterJob.this.attributes);
                    }
                    if (doc.getDocFlavor() == DocFlavor.SERVICE_FORMATTED.PAGEABLE || doc.getDocFlavor().getMimeType().equals(IOSPrintService.IOS_PAGEABLE.getMimeType())) {
                        IOSPrinterJob.this.setPageable((Pageable)doc.getPrintData());
                    } else if (doc.getDocFlavor() == DocFlavor.SERVICE_FORMATTED.PRINTABLE || doc.getDocFlavor().getMimeType().equals(IOSPrintService.IOS_PRINTABLE.getMimeType())) {
                        IOSPrinterJob.this.setPrintable((Printable)doc.getPrintData());
                    } else if (doc.getPrintData() instanceof Printable) {
                        IOSPrinterJob.this.setPrintable((Printable)doc.getPrintData());
                    } else if (doc.getPrintData() instanceof Pageable) {
                        IOSPrinterJob.this.setPrintable((Printable)doc.getPrintData());
                    } else {
                        return;
                    }
                    IOSPrinterJob.this.print();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thr.setDaemon(true);
        thr.setName("PrintThread");
        thr.start();
    }

    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        PrintJobAttributeListener listener1;
        int i;
        for (i = 0; i < this.printjobAttirbuteListVect.size() && listener != (listener1 = (PrintJobAttributeListener)this.printjobAttirbuteListVect.get(i)); ++i) {
        }
        this.printjobAttirbuteListVect.remove(i);
    }

    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        PrintJobListener listener1;
        int i;
        for (i = 0; i < this.printjobListVect.size() && listener != (listener1 = (PrintJobListener)this.printjobListVect.get(i)); ++i) {
        }
        this.printjobListVect.remove(i);
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    @Override
    public void cancel() {
        this.service.cancel();
    }

    @Override
    public PageFormat defaultPage(PageFormat page) {
        return page;
    }

    @Override
    public int getCopies() {
        return this.numCopies;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        return page;
    }

    @Override
    public void print() throws PrinterException {
        if (seriesPrintInProgress) {
            return;
        }
        boolean bl = seriesPrintInProgress = this.document != null && this.document.getNumberOfPages() > 1;
        if (this.painter != null) {
            JImageSource imgsrc = new JImageSource(){

                public BufferedImage getBufferedImage(int index, int width, int height, int type) {
                    BufferedImage bi = new BufferedImage(width, height, type);
                    Paper pp = new Paper();
                    pp.setSize(width, height);
                    pp.setImageableArea(0.0, 0.0, width, height);
                    PageFormat pf = new PageFormat();
                    pf.setPaper(pp);
                    try {
                        IOSPrinterJob.this.painter.print(bi.getGraphics(), pf, index);
                    }
                    catch (PrinterException ex) {
                        return null;
                    }
                    return bi;
                }

                public String getESI(int index) {
                    if (IOSPrinterJob.this.painter instanceof DicomPrintablePort) {
                        return ((DicomPrintablePort)IOSPrinterJob.this.painter).getESIString();
                    }
                    return null;
                }

                public Dimension getImageDimension(int index) {
                    return IOSPrinterJob.this.mid ? imageSizeMID : (IOSPrinterJob.this.large ? largeImageSize : imageSize);
                }

                public int getNumberOfImages() {
                    return 1;
                }

                public InputStream getSSaveImage(int index, int width, int height) {
                    String imageName = this.imagePath(index);
                    BufferedImage bufferedImg = this.getBufferedImage(index, width, height, 5);
                    if (bufferedImg == null) {
                        return null;
                    }
                    if (imageName != null) {
                        return IOSPrintUtil.getSsaveStream(imageName, bufferedImg);
                    }
                    return IOSPrintUtil.getSS(bufferedImg);
                }

                public String imagePath(int index) {
                    if (IOSPrinterJob.this.painter instanceof DicomPrintablePort) {
                        return ((DicomPrintablePort)IOSPrinterJob.this.painter).getOriginalImagePath();
                    }
                    return null;
                }
            };
            this.filmPort(imgsrc);
        } else if (this.document != null) {
            JImageSource imgSrc1 = new JImageSource(){

                public BufferedImage getBufferedImage(int id, int width, int height, int type) {
                    BufferedImage bi = new BufferedImage(width, height, type);
                    Paper pp = new Paper();
                    pp.setSize(width, height);
                    pp.setImageableArea(0.0, 0.0, width, height);
                    PageFormat pf = new PageFormat();
                    pf.setPaper(pp);
                    try {
                        IOSPrinterJob.this.document.getPrintable(id).print(bi.getGraphics(), pf, 0);
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                    return bi;
                }

                public int getNumberOfImages() {
                    return IOSPrinterJob.this.document.getNumberOfPages();
                }

                public String getESI(int id) {
                    Printable pt = IOSPrinterJob.this.document.getPrintable(id);
                    if (pt instanceof DicomPrintable) {
                        return ((DicomPrintable)pt).getESIString();
                    }
                    return null;
                }

                public Dimension getImageDimension(int id) {
                    return IOSPrinterJob.this.mid ? imageSizeMID : (IOSPrinterJob.this.large ? largeImageSize : imageSize);
                }

                public String imagePath(int id) {
                    Printable pt = IOSPrinterJob.this.document.getPrintable(id);
                    if (pt instanceof DicomPrintable) {
                        return ((DicomPrintable)pt).getOriginalImagePath();
                    }
                    return null;
                }

                public InputStream getSSaveImage(int index, int width, int height) {
                    String imageName = this.imagePath(index);
                    BufferedImage bufferedImg = this.getBufferedImage(index, width, height, 5);
                    if (bufferedImg == null) {
                        return null;
                    }
                    if (imageName != null) {
                        return IOSPrintUtil.getSsaveStream(imageName, bufferedImg);
                    }
                    return IOSPrintUtil.getSS(bufferedImg);
                }
            };
            this.filmPort(imgSrc1);
        } else {
            return;
        }
    }

    private void filmPort(JImageSource imgSrc) {
        String fcname = ((PrinterName)this.service.getAttribute(PrinterName.class)).getValue();
        JFilmer film = new JFilmer(imgSrc, fcname);
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IOSPrinterJob.this.fireEvent(e);
            }
        };
        film.addPropertyChangeListener(pl);
        try {
            if (this.rows > 0 && this.cols > 0) {
                film.setFormat(this.rows, this.cols);
            }
            if (this.seriesPrintRequest) {
                film.setSeriesPrintRequest(true);
            }
            if (this.forcePrintRequest) {
                film.setForcePrint(true);
            }
            if (imgSrc.getNumberOfImages() > 1) {
                film.filmSeriesOnebyOne(0, imgSrc.getNumberOfImages());
            } else if (this.dnd) {
                film.filmImageDrop(0);
            } else {
                film.filmImage(0);
            }
            this.seriesPrintRequest = false;
            this.forcePrintRequest = false;
            this.dnd = false;
            this.mid = false;
            this.large = false;
        }
        catch (Exception ex) {
            this.seriesPrintRequest = false;
            seriesPrintInProgress = false;
            this.forcePrintRequest = false;
            this.dnd = false;
            this.mid = false;
            this.large = false;
            this.logger.log(Level.INFO, ex.getLocalizedMessage());
            for (int i = 0; i < this.printjobListVect.size(); ++i) {
                PrintJobListener listener = (PrintJobListener)this.printjobListVect.get(i);
                if (ex.getLocalizedMessage().equals("FILM_FORMAT_ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 201));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("FILM_COMPOSER_FULL_ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 202));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("FILM_RESERVATION_ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 203));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("SAVE_FC_STATE_ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 204));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("RESTORE_FC_STATE ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 205));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("FORCE_PRINT_ERROR")) {
                    listener.printJobFailed(new PrintJobEvent(this, 206));
                    continue;
                }
                if (ex.getLocalizedMessage().equals("FILM_USER_CANCEL")) {
                    listener.printJobFailed(new PrintJobEvent(this, 207));
                    continue;
                }
                listener.printJobFailed(new PrintJobEvent(this, 103));
            }
        }
    }

    private void fireEvent(PropertyChangeEvent e) {
        JFilmer filmer = (JFilmer)e.getSource();
        int numOfImages = filmer.getImageSource().getNumberOfImages();
        if (e.getPropertyName().equals("Progress")) {
            PrintProgress pg = new PrintProgress((Integer)e.getNewValue());
            for (int i = 0; i < this.printjobAttirbuteListVect.size(); ++i) {
                PrintJobAttributeListener al = (PrintJobAttributeListener)this.printjobAttirbuteListVect.get(i);
                HashPrintJobAttributeSet set = new HashPrintJobAttributeSet();
                set.add(pg);
                al.attributeUpdate(new PrintJobAttributeEvent(this, set));
            }
            if (pg.getValue() == numOfImages) {
                seriesPrintInProgress = false;
            }
        }
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        return false;
    }

    @Override
    public void setCopies(int copies) {
        this.numCopies = copies;
    }

    @Override
    public void setJobName(String jobName) {
    }

    @Override
    public void setPageable(Pageable document) throws NullPointerException {
        this.document = document;
    }

    @Override
    public void setPrintable(Printable painter) {
        this.painter = painter;
    }

    @Override
    public void setPrintable(Printable painter, PageFormat format) {
        this.painter = painter;
        this.format = format;
    }

    @Override
    public PageFormat validatePage(PageFormat page) {
        return page;
    }

    private void setAttributeValues(PrintRequestAttributeSet attributes) {
        DndPrint dndRequest;
        SeriesPrint seriesRequest;
        PrintRowColFormat row = (PrintRowColFormat)attributes.get(PrintRowColFormat.class);
        if (row != null) {
            Integer[] rowcol = row.getValue();
            this.rows = rowcol[0];
            this.cols = rowcol[1];
        }
        this.seriesPrintRequest = (seriesRequest = (SeriesPrint)attributes.get(SeriesPrint.class)) != null;
        ForcePrint forcePrint = (ForcePrint)attributes.get(ForcePrint.class);
        if (forcePrint != null) {
            this.forcePrintRequest = true;
        }
        this.dnd = (dndRequest = (DndPrint)attributes.get(DndPrint.class)) != null;
        MIDPrint midRequest = (MIDPrint)attributes.get(MIDPrint.class);
        this.mid = midRequest != null;
        LargePrint largePrint = (LargePrint)attributes.get(LargePrint.class);
        if (largePrint != null) {
            this.large = true;
            this.portSize = new Dimension(largePrint.getWidth(), largePrint.getHeight());
            this.portSize.setSize(largePrint.getWidth(), largePrint.getHeight());
        } else {
            this.large = false;
        }
    }
}

