/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.saveimage.XpFillSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMSession;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XpFillSecondaryCaptureSaveParameters
extends XpFillSaveParameters {
    private static final Logger logger = Logger.getLogger(XpFillSecondaryCaptureSaveParameters.class.getName());
    private ArrayList<Component> vcs = new ArrayList();

    public XpFillSecondaryCaptureSaveParameters(XpViewport viewport) {
        super(viewport);
    }

    @Override
    public boolean fillSaveParameters(XpSaveParameters params) {
        if (!super.fillSaveParameters(params)) {
            return true;
        }
        T3DViewport t3dViewport = null;
        if (this.viewport instanceof T3DViewport) {
            t3dViewport = (T3DViewport)this.viewport;
        }
        if (t3dViewport == null || t3dViewport.getFrame() == null) {
            logger.log(Level.WARNING, "T3DViewport or its frame is null");
            return false;
        }
        DMSession osession = CvUtils.getDMSystem().getLocalDB();
        XjVolumeInfo volume = t3dViewport.getVolume();
        if (osession == null || volume == null) {
            logger.log(Level.WARNING, "DMSession or XjVolumeInfo is null");
            return false;
        }
        if (params.image == null) {
            params.image = t3dViewport.getFrame();
        }
        if (params.coloredImage == null) {
            params.coloredImage = new BufferedImage(params.image.getSlice().width, params.image.getSlice().width, 1);
            this.removeGraphics(t3dViewport);
            t3dViewport.paint(params.coloredImage.getGraphics());
            this.addGraphics(t3dViewport);
        }
        if (params.seriesUID == null) {
            String serUID;
            params.seriesUID = serUID = XpSaveUtil.getSeriesUID((String)volume.getValue(32, 13), params.seriesNum, osession);
        }
        if (params.defaultWindowWidthLevel == null) {
            double min = t3dViewport.getWinMin();
            double max = t3dViewport.getWinMax();
            double[] wwwl = new double[]{max - min, (max + min) / 2.0};
            params.defaultWindowWidthLevel = wwwl;
        }
        params.seriesDescription = "Screen Save";
        return true;
    }

    private void removeGraphics(T3DViewport vp) {
        T3DComponent tc = vp.getT3DComponent();
        Component[] comp = tc.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof CubeTrackball) && !(comp[i] instanceof Cursor3DVc)) continue;
            this.vcs.add(comp[i]);
            tc.remove(comp[i]);
        }
    }

    private void addGraphics(T3DViewport vp) {
        T3DComponent tc = vp.getT3DComponent();
        int size = this.vcs.size();
        for (int i = 0; i < size; ++i) {
            Component comp1 = this.vcs.get(i);
            tc.add(comp1);
        }
        this.vcs.clear();
    }
}

