/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.screenbuilder.helper;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.screenbuilder.helper.Helper;
import com.ge.med.idc.Capable;
import com.ge.med.idc.XjDynamicVolume;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class OnPortControlHelper
implements Helper {
    public static final String[] POSITIONS = new String[]{"West", "East", "North", "South"};
    private static final String COMMA = ",";
    private static final String FADEAWAY_OVERLAY = "FadeAwayOverLay";
    private static final String PORT_CONTROLS = ".portControls";
    private static final String DATASET = ".defaultDataset";
    private static final Logger logger = Logger.getLogger(OnPortControlHelper.class.getName());
    private HashMap<String, XPopPanel> currentPortControls = new HashMap();
    private FadeAwayOverLay fadeAwayOverLay = null;
    private JComponent viewport = null;
    private Properties prop = null;
    private String currentDatasetName = null;
    private PropertyChangeListener volumeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OnPortControlHelper.this.addPopControls();
        }
    };
    PropertyChangeListener dataChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if (evt.getNewValue() instanceof String) {
                    OnPortControlHelper.this.currentDatasetName = (String)evt.getNewValue();
                    OnPortControlHelper.this.reConfig();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to start the image load configuration. " + e.getLocalizedMessage());
            }
        }
    };

    @Override
    public void config(JComponent port, String portName, Properties prop) throws Exception {
        if (port == null || portName == null || portName == "" || prop == null) {
            logger.log(Level.WARNING, "Either viewport or its name or property is null");
            throw new Exception("Either viewport or its name or property is null");
        }
        this.viewport = port;
        this.prop = prop;
        if (port.getClientProperty(FADEAWAY_OVERLAY) != null) {
            this.fadeAwayOverLay = (FadeAwayOverLay)port.getClientProperty(FADEAWAY_OVERLAY);
            this.removeControls(this.fadeAwayOverLay);
        } else {
            this.fadeAwayOverLay = new FadeAwayOverLay();
            this.fadeAwayOverLay.addBase(port);
            port.putClientProperty(FADEAWAY_OVERLAY, this.fadeAwayOverLay);
        }
        this.currentDatasetName = port.getName() + DATASET;
        this.startConfig();
        port.removePropertyChangeListener("VOLUME_PROPERTY", this.volumeChangeListener);
        port.addPropertyChangeListener("VOLUME_PROPERTY", this.volumeChangeListener);
        port.removePropertyChangeListener("datasetChange", this.dataChangeListener);
        port.addPropertyChangeListener("datasetChange", this.dataChangeListener);
    }

    private void removeControls(FadeAwayOverLay f) {
        Component[] portCntr;
        if (f != null && (portCntr = f.getOnPortComponents()) != null) {
            for (Component comp : portCntr) {
                if (!(comp instanceof XPopPanel)) continue;
                f.removeOnPortCtl((XPopPanel)comp);
            }
        }
    }

    private void startConfig() {
        this.currentPortControls.clear();
        this.removeControls(this.fadeAwayOverLay);
        if (this.viewport instanceof ViewTypeCapable && this.viewport instanceof T3DViewport && ((T3DViewport)this.viewport).getVolume() instanceof XjDynamicVolume && ((ViewTypeCapable)((Object)this.viewport)).getViewType().equals("2D")) {
            return;
        }
        String defaultcontrol = this.prop.getProperty("PortControls");
        this.createPortControls(defaultcontrol);
        String datasetcontrol = this.prop.getProperty(this.currentDatasetName + PORT_CONTROLS);
        this.createPortControls(datasetcontrol);
    }

    private void createPortControls(String controlprop) {
        String[] controls = null;
        if (controlprop != null && (controls = controlprop.split(COMMA)) != null && controls.length > 0 && this.viewport instanceof Capable) {
            for (int i = 0; i < controls.length; ++i) {
                if (this.fadeAwayOverLay == null) continue;
                this.createPopControl(this.fadeAwayOverLay, this.viewport, controls[i]);
            }
        }
    }

    private void createPopControl(FadeAwayOverLay f, JComponent target, String control) {
        String[] comp = control.split("@");
        if (comp.length != 2) {
            throw new IllegalArgumentException("Cannot parse onport control " + control);
        }
        XPopPanel op = null;
        try {
            Class<?> c = Class.forName(comp[0], false, cl);
            op = (XPopPanel)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Class " + comp[0] + " not found" + e.getLocalizedMessage());
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "Class " + comp[0] + " not able to instantiate" + e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Class " + comp[0] + " access is illegal" + e.getLocalizedMessage());
        }
        try {
            if (op != null) {
                op.setName(target.getName() + "" + op.getClass().getSimpleName());
                String position = null;
                for (int i = 0; i < POSITIONS.length; ++i) {
                    if (!comp[1].equalsIgnoreCase(POSITIONS[i])) continue;
                    position = POSITIONS[i];
                    break;
                }
                if (position != null) {
                    this.currentPortControls.put(position, op);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Problem in setting name for the port control. " + ex.getLocalizedMessage());
        }
    }

    private void reConfig() {
        try {
            this.startConfig();
            this.addPopControls();
            this.viewport.updateUI();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to start the image load re-configuration. " + e.getLocalizedMessage());
        }
    }

    private void addPopControls() {
        Component[] addedControls = this.fadeAwayOverLay.getOnPortComponents();
        for (String position : this.currentPortControls.keySet()) {
            XPopPanel control = this.currentPortControls.get(position);
            boolean exist = false;
            for (int i = 0; i < addedControls.length; ++i) {
                if (!addedControls[i].equals(control)) continue;
                exist = true;
                break;
            }
            if (exist || !control.isSupported((Capable)((Object)this.viewport))) continue;
            this.fadeAwayOverLay.addOnPortCtl(control, position);
            control.setPort(this.viewport);
        }
    }
}

