/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.sr;

import com.ge.med.cse.cvf.sr.SRConfigXMLParser;
import com.ge.med.cse.cvf.sr.SRFrame;
import com.ge.med.cse.cvf.sr.SRUtils;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import srjdom.SRDOMDoc;

public class SR2HTMLReportGenerator {
    private DMObject srObject;
    private DMObject srExam;
    private Document srjdomDoc = null;
    private InputStream xslStrm = null;
    private String modalityXSLTFile = null;
    private String i18nFile = null;
    private String srOutputDirPath;
    private String srOutputImgWaveFormDirPath;
    private String outputHTMLFilePath = null;
    private static final Logger logger = Logger.getLogger(SR2HTMLReportGenerator.class.getName());

    public SR2HTMLReportGenerator(DMObject srDmObj) {
        this.srObject = srDmObj;
        this.init();
    }

    public void generateReport() {
        String modality = this.srObject.getValue(8, 96).toString();
        if (!modality.equalsIgnoreCase("SR")) {
            return;
        }
        File htmlReport = new File(this.outputHTMLFilePath);
        String srFilePath = this.srObject.getComposites()[0].getFilePath();
        if (srFilePath != null) {
            try {
                File dicomFile = new File(srFilePath);
                if (!dicomFile.exists()) {
                    return;
                }
                SRDOMDoc srDomDoc = new SRDOMDoc();
                srDomDoc.readDCM(dicomFile);
                this.srjdomDoc = SRDOMDoc.getDOM();
                this.configDefaultTags(this.srjdomDoc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.getImagesFromSRDicomFile();
        Transformer localTransformer = null;
        try {
            if (this.modalityXSLTFile == null) {
                this.xslStrm = this.getClass().getResourceAsStream("CSE_Default.XSL");
            }
            localTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(this.xslStrm));
            localTransformer.setOutputProperty("indent", "yes");
            localTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            localTransformer.setOutputProperty("encoding", "UTF-8");
            StreamResult localStreamResult = new StreamResult(this.outputHTMLFilePath);
            localTransformer.transform(new DOMSource(this.srjdomDoc), localStreamResult);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return;
        }
        if (this.hasContent(htmlReport)) {
            this.openURL(this.outputHTMLFilePath);
        }
    }

    private void init() {
        this.srOutputDirPath = SRUtils.SRTEMPDIR;
        this.srOutputImgWaveFormDirPath = this.srOutputDirPath + "SRIMAGES" + File.separator;
        new File(this.srOutputImgWaveFormDirPath).mkdirs();
        this.srExam = this.srObject.getRelated("study")[0];
        String sopClassUid = this.srObject.getValue(8, 22).toString();
        String modality = this.srObject.getValue(8, 96).toString();
        if (sopClassUid != null && sopClassUid != "" && modality != null && modality != "" && modality.equalsIgnoreCase("SR")) {
            String defaultConfigFile = "SRConfig.xml";
            SRConfigXMLParser parser = new SRConfigXMLParser();
            parser.parseConfigFile(defaultConfigFile);
            parser.parseConfigFile(System.getProperty("SR_CONFIG_FILE"));
            SRConfigXMLParser.SrSOPClassUidElement sopelement = parser.getSOPClsUidCofigForModality(modality, sopClassUid);
            if (sopelement != null) {
                try {
                    this.modalityXSLTFile = sopelement.getXslFile();
                    this.xslStrm = new FileInputStream(this.modalityXSLTFile);
                }
                catch (Exception e) {
                    this.xslStrm = this.getClass().getResourceAsStream(this.modalityXSLTFile);
                }
                String locale = Locale.getDefault().getLanguage().toLowerCase() + "_" + Locale.getDefault().getCountry().toUpperCase();
                this.i18nFile = sopelement.geti18nFileForLocale(locale);
                sopelement.copyCssFile();
            } else {
                this.xslStrm = this.getClass().getResourceAsStream("CSE_Default.XSL");
            }
        } else {
            return;
        }
        SRUtils.copyGELogo();
        this.outputHTMLFilePath = this.srOutputDirPath + "SR_" + this.srObject.getValue(8, 24).toString() + ".html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasContent(File rprt) {
        FileInputStream fis = null;
        boolean value = false;
        try {
            fis = new FileInputStream(rprt);
            value = fis.available() > 0;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while reading the file", e.getLocalizedMessage());
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception while closing the file", e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    private void configDefaultTags(Element paramElement) {
        File i18nFileObj;
        paramElement.setAttribute("lang", Locale.getDefault().getLanguage());
        Date localDate = new Date();
        SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramElement.setAttribute("dateTime", localSimpleDateFormat.format(localDate));
        paramElement.setAttribute("SRImage", this.srOutputImgWaveFormDirPath);
        if (this.i18nFile != null && this.i18nFile != "" && (i18nFileObj = new File(this.i18nFile)).exists()) {
            paramElement.setAttribute("langDoc", i18nFileObj.toURI().toString());
        }
    }

    private void getImagesFromSRDicomFile() {
        DMObject[] rImgs;
        ArrayList<String> refImgSOPInstUIDList = new ArrayList<String>();
        XPathFactory localXPathFactory = XPathFactory.newInstance();
        XPath localXPath = localXPathFactory.newXPath();
        try {
            NodeList localNodeList = (NodeList)localXPath.evaluate("/DICOM/ContentSequence//ReferencedSOPInstanceUID", this.srjdomDoc, XPathConstants.NODESET);
            if (localNodeList != null) {
                for (int i = 0; i < localNodeList.getLength(); ++i) {
                    Node localObject2;
                    Node localObject1 = localNodeList.item(i);
                    if (localObject1 == null || (localObject2 = localObject1.getFirstChild()) == null) continue;
                    refImgSOPInstUIDList.add(localObject2.getNodeValue());
                }
            }
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return;
        }
        if (refImgSOPInstUIDList.isEmpty()) {
            return;
        }
        StringBuffer refUidBuffer = new StringBuffer();
        int size = refImgSOPInstUIDList.size();
        for (int i = 0; i < size; ++i) {
            refUidBuffer.append((String)refImgSOPInstUIDList.get(i));
            if (i >= size - 1) continue;
            refUidBuffer.append(" || ");
        }
        DMQuery dmQuery = new DMQuery("(0x8, 0x18) = " + refUidBuffer.toString());
        for (DMObject ri : rImgs = this.srExam.getRelated("image", dmQuery)) {
            DMImage[] dmImage = ri.getImages(null);
            if (!new File(this.srOutputImgWaveFormDirPath).exists()) {
                new File(this.srOutputImgWaveFormDirPath).mkdirs();
            }
            XpImageViewport viewport = new XpImageViewport("com.ge.med.terra.jami.render.XpPZWRenderer");
            viewport.setImages(XpMedicalDmImage.wrapDMImages(dmImage));
            viewport.setAnnotationVisible(false);
            String fileName = this.srOutputImgWaveFormDirPath + dmImage[0].getValue(8, 24) + ".jpg";
            new XpComponentSave().saveJPEG(viewport, 512, 512, fileName);
            viewport.dispose();
            SRUtils.setImgeOrWaveformFlag(true);
        }
    }

    private void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Windows") && System.getProperty("DO_NOT_SHOW_SR_BROWSER") == null) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                SRFrame srFrm = new SRFrame();
                srFrm.showSR(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SRFrame srFrm = new SRFrame();
            srFrm.showSR(url);
        }
    }

    public String getReportFilePath() {
        return this.outputHTMLFilePath;
    }

    public static void clearSRTempFiles(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                SR2HTMLReportGenerator.clearSRTempFiles(file);
            }
        }
        dir.delete();
    }

    public static void main(String[] args) {
        DMSession ses = new DMSession(args);
        DMObject[] srObjects = ses.getRelated("image");
        System.setProperty("REPOSITORY_PATH", args[1]);
        System.setProperty("SR_CONFIG_FILE", "C:/mv/Config/SRConfig.xml");
        new SR2HTMLReportGenerator(srObjects[0]).generateReport();
    }
}

