/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.sr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class SRUtils {
    private static ArrayList<String> itemList = new ArrayList();
    private static ArrayList<String> colAddedForItemsTillNow = new ArrayList();
    private static boolean hasImgOrWaveform = false;
    private static final String GELOGO_IMG = "GE_Healthcare_Logo.png";
    public static String REPOSITORY_PATH = System.getProperty("REPOSITORY_PATH") + File.separator;
    public static String SRTEMPDIR = System.getProperty("SR_TMP_DIR", System.getProperty("java.io.tmpdir")) + File.separator;
    private static final String PATNAMEPATTERN = "[*[\\^][\\,]*]";
    private static final String PATNAMESEPARATOR = " ";
    private static final String DATE_SEP = "-";
    private static final String DATETIME_SEP = "T";
    private static final String DOT = ".";
    private static final String EMPTY = "";
    private static final String SLASH = " / ";

    public static boolean hasImgeOrWaveForm() {
        return hasImgOrWaveform;
    }

    public static void setImgeOrWaveformFlag(boolean hasImgeOrWaveForm) {
        hasImgOrWaveform = hasImgeOrWaveForm;
    }

    public static void addItem(String itemName) {
        itemList.add(itemName);
    }

    public static boolean isItemAlreadyAdded(String itemName) {
        if (!itemList.isEmpty()) {
            return itemList.contains(itemName);
        }
        return false;
    }

    public static void addedColumnsForItem(String itemName) {
        colAddedForItemsTillNow.add(itemName);
    }

    public static boolean isColumnsAddedForItem(String itemName) {
        if (!colAddedForItemsTillNow.isEmpty()) {
            return colAddedForItemsTillNow.contains(itemName);
        }
        return false;
    }

    public static void clearItemLists() {
        itemList.clear();
        colAddedForItemsTillNow.clear();
        hasImgOrWaveform = false;
    }

    public static String getURI(String absFilePath) {
        if (absFilePath == null || absFilePath == EMPTY) {
            return EMPTY;
        }
        File imgFile = new File(absFilePath);
        if (imgFile.exists()) {
            return imgFile.toURI().toString();
        }
        return EMPTY;
    }

    public static void copyGELogo() {
        InputStream in = SRUtils.class.getResourceAsStream(GELOGO_IMG);
        if (in == null) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(SRTEMPDIR + GELOGO_IMG);
            SRUtils.copyFiles(in, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFiles(String src, String dst) {
        boolean success = false;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            success = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
                out.close();
            }
            catch (IOException iOException) {}
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFiles(InputStream src, OutputStream dst) {
        boolean success = false;
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = src.read(buf)) > 0) {
                dst.write(buf, 0, len);
            }
            success = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                src.close();
                dst.close();
            }
            catch (IOException iOException) {}
        }
        return success;
    }

    public static String getPatientName(String patName) {
        if (patName == null || patName.length() == 0) {
            return EMPTY;
        }
        return patName.replaceAll(PATNAMEPATTERN, PATNAMESEPARATOR);
    }

    public static String getDateTimeValue(String dateTime, int dateOrTime) {
        if (dateTime == null || dateTime.length() == 0) {
            return EMPTY;
        }
        String[] dateTimeTokens = dateTime.split(DATETIME_SEP);
        if (dateTimeTokens.length != 2) {
            return dateTime;
        }
        if (dateOrTime == 0) {
            return SRUtils.getDateValue(dateTimeTokens[0]) + SLASH + SRUtils.getTimeValue(dateTimeTokens[1]);
        }
        return SRUtils.getDateValue(dateTimeTokens[0]);
    }

    public static String getTimeValue(String time) {
        if (time == null || time.length() == 0) {
            return EMPTY;
        }
        return time.split("\\.")[0];
    }

    public static String getDateValue(String date) {
        if (date == null || date.length() == 0) {
            return EMPTY;
        }
        String[] dateTokens = date.split(DATE_SEP);
        if (dateTokens.length != 3) {
            return date;
        }
        return dateTokens[2] + DOT + dateTokens[1] + DOT + dateTokens[0];
    }

    public static void main(String[] args) {
        String dateTime = "2012-06-11T17:14:07.000";
        String date = "2012-05-10";
        String time = "17:14:07.000";
        String[] tt = time.split("\\.");
        System.out.println(tt);
        System.out.println(SRUtils.getDateTimeValue(dateTime, 0));
        System.out.println(SRUtils.getDateTimeValue(dateTime, 1));
        System.out.println(SRUtils.getDateValue(date));
    }
}

