/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.textpage;

import com.ge.med.cse.cvf.textpage.TextPage;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class TextPageManager
implements PropertyChangeListener {
    public static final String TEXT_PAGE_PROPERTY = "TEXT_PAGE_PROPERTY";
    private static TextPageManager instance;
    public String pageType = null;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JDialog examDialog = null;
    private JDialog seriesDialog = null;
    private JDialog roiDialog = null;
    private Capable cap_ = null;
    private boolean examPageEnabled = true;
    private boolean seriesPageEnabled = true;
    private boolean roiPageEnabled = true;

    public static TextPageManager getInstance() {
        return instance == null ? (instance = new TextPageManager()) : instance;
    }

    public void setCapable(Capable cap) {
        this.cap_ = cap;
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.pcs.addPropertyChangeListener(TEXT_PAGE_PROPERTY, list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.pcs.removePropertyChangeListener(TEXT_PAGE_PROPERTY, list);
    }

    public void setTextPageEnabled(TextPageType type, boolean enabled) {
        switch (type) {
            case SERIES: {
                this.seriesPageEnabled = enabled;
                break;
            }
            case EXAM: {
                this.examPageEnabled = enabled;
                break;
            }
            case ROI: {
                this.roiPageEnabled = enabled;
            }
        }
    }

    public boolean isTextPageEnabled(TextPageType type) {
        switch (type) {
            case SERIES: {
                return this.seriesPageEnabled;
            }
            case EXAM: {
                return this.examPageEnabled;
            }
            case ROI: {
                return this.roiPageEnabled;
            }
        }
        return false;
    }

    public boolean isTextPageShowing(TextPageType type) {
        switch (type) {
            case SERIES: {
                return this.seriesDialog != null && this.seriesDialog.isDisplayable();
            }
            case EXAM: {
                return this.examDialog != null && this.examDialog.isDisplayable();
            }
            case ROI: {
                return this.roiDialog != null && this.roiDialog.isDisplayable();
            }
        }
        throw new IllegalArgumentException("Unsupported page type");
    }

    public void launchTextPage(TextPageType type) throws Exception {
        switch (type) {
            case SERIES: {
                TextPage spage = new TextPage(this.cap_, type);
                this.seriesDialog = this.showPage(this.seriesDialog, spage, CvUtils.getResourceBundle().getString("XP_TEXTPAGE_SERIES_NAME"));
                break;
            }
            case EXAM: {
                TextPage epage = new TextPage(this.cap_, type);
                this.examDialog = this.showPage(this.examDialog, epage, CvUtils.getResourceBundle().getString("XP_TEXTPAGE_EXAM_NAME"));
                break;
            }
            case ROI: {
                TextPage rpage = new TextPage(this.cap_, type);
                this.roiDialog = this.showPage(this.roiDialog, rpage, CvUtils.getResourceBundle().getString("XP_TEXTPAGE_ROI_NAME"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Type of text page" + (Object)((Object)type));
            }
        }
    }

    private JDialog showPage(JDialog dialog, TextPage page, String title) {
        page.addPropertyChangeListener("close_text_page", this);
        if (dialog == null || !dialog.isDisplayable()) {
            JFrame parent = (JFrame)CvUtils.getManagedParent((Component)((Object)this.cap_));
            dialog = new JDialog((Frame)parent, false);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JDialog d = (JDialog)e.getWindow();
                    d.getContentPane().removeAll();
                    d.dispose();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextPageManager.this.pcs.firePropertyChange(TextPageManager.TEXT_PAGE_PROPERTY, false, true);
                        }
                    });
                }
            });
        } else {
            dialog.getContentPane().removeAll();
        }
        dialog.setTitle(title);
        dialog.setName(title);
        dialog.getContentPane().add(page);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo((Component)((Object)this.cap_));
        dialog.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextPageManager.this.pcs.firePropertyChange(TextPageManager.TEXT_PAGE_PROPERTY, false, true);
            }
        });
        return dialog;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TextPage) {
            TextPage tp = (TextPage)evt.getSource();
            tp.removePropertyChangeListener("close_text_page", this);
            Window parent = SwingUtilities.windowForComponent((TextPage)evt.getSource());
            if (parent instanceof JDialog) {
                JDialog dialog = (JDialog)parent;
                dialog.getContentPane().removeAll();
                dialog.dispose();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextPageManager.this.pcs.firePropertyChange(TextPageManager.TEXT_PAGE_PROPERTY, false, true);
            }
        });
    }

    public void dispose() {
        PropertyChangeListener[] lsnrs = this.pcs.getPropertyChangeListeners();
        int size = lsnrs.length;
        for (int i = 0; i < size; ++i) {
            this.pcs.removePropertyChangeListener(lsnrs[i]);
        }
        if (this.examDialog != null) {
            this.examDialog.getContentPane().removeAll();
            this.examDialog.dispose();
            this.examDialog = null;
        }
        if (this.seriesDialog != null) {
            this.seriesDialog.getContentPane().removeAll();
            this.seriesDialog.dispose();
            this.seriesDialog = null;
        }
        if (this.roiDialog != null) {
            this.roiDialog.getContentPane().removeAll();
            this.roiDialog.dispose();
            this.roiDialog = null;
        }
        this.cap_ = null;
        instance = null;
    }

    public static enum TextPageType {
        EXAM,
        SERIES,
        ROI;

    }
}

