/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DSAImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;

public class AvgSubDSAImageOp
extends DSAImageOp {
    private int frameIndex = -1;
    public static final int DSA_MASK_PORTION_FRACTIONAL_BITS = 8;
    private static int frameOffset = Integer.parseInt(CvPropertiesManager.getProperty("cvf.dsa.frameoffset", "240"));
    private static double dsaLandmark = Double.parseDouble(CvPropertiesManager.getProperty("cvf.dsa.landmark", "0.625"));

    public AvgSubDSAImageOp(CvDSAImageUtils.MaskItem mask) {
        this(mask, -1);
    }

    public AvgSubDSAImageOp(CvDSAImageUtils.MaskItem mask, int frameIndex) {
        super(mask);
        this.frameIndex = frameIndex;
    }

    @Override
    public void execute(RenderedImage input, RenderedImage output) {
        CvDSAImageUtils.MaskItem mask = this.getMaskItem();
        BufferedImage res = (BufferedImage)input;
        if (this.frameIndex >= 0 && mask instanceof CvDSAImageUtils.AvgSubMaskItem && ((CvDSAImageUtils.AvgSubMaskItem)mask).getContrastFrameAveraging() > 1) {
            CvDSAImageUtils.AvgSubMaskItem avgmask = (CvDSAImageUtils.AvgSubMaskItem)mask;
            int cframes = avgmask.getContrastFrameAveraging();
            BufferedImage[] imgs = new BufferedImage[cframes];
            imgs[0] = (BufferedImage)input;
            int ctr = 1;
            for (int i = this.frameIndex + 1; i < this.frameIndex + cframes; ++i) {
                imgs[ctr++] = avgmask.getContrastFrame(i + 1);
            }
            res = CvDSAImageUtils.average(imgs, null);
        }
        if (res != null) {
            short[] idata = ((DataBufferUShort)res.getData().getDataBuffer()).getData();
            short[] odata = ((DataBufferUShort)((BufferedImage)output).getRaster().getDataBuffer()).getData();
            short[] mdata = ((DataBufferUShort)mask.getMask().getData().getDataBuffer()).getData();
            this.weightedMaskSubtraction(idata, mdata, odata);
        }
    }

    @Override
    public String getImageOpName() {
        return "DSA_AVG_SUB";
    }

    public static final void setContrastFrameOffset(int offset) {
        if (offset < 0 || offset > Short.MAX_VALUE) {
            return;
        }
        frameOffset = offset;
    }

    public static final int getContrastFrameOffset() {
        return frameOffset;
    }

    public static final void setMaskFrameLandmark(double landmark) {
        if (landmark < 0.0 || landmark > 1.0) {
            return;
        }
        dsaLandmark = landmark;
    }

    public static final double getMaskFrameLandmark() {
        return dsaLandmark;
    }

    private void weightedMaskSubtraction(short[] idata, short[] mdata, short[] odata) {
        int maskPortionMultiplier = (int)(256.0 * dsaLandmark);
        int result = 0;
        int frameDataLcl = 0;
        int maskDataLcl = 0;
        for (int i = 0; i < idata.length; ++i) {
            frameDataLcl = idata[i] & 0xFFFF;
            maskDataLcl = mdata[i] & 0xFFFF;
            maskDataLcl *= maskPortionMultiplier;
            result = (frameDataLcl += frameOffset) - (maskDataLcl >>= 8);
            if (result > Short.MAX_VALUE) {
                result = Short.MAX_VALUE;
            } else if (result < 0) {
                result = 0;
            }
            odata[i] = (short)result;
        }
    }

    private void logMaskSubtraction(short[] idata, short[] mdata, short[] odata) {
        double newmax;
        double logMaks = 0.0;
        double logFrame = 0.0;
        int size = idata.length;
        double[] logdiffresult = new double[size];
        double maxdiff = Double.MIN_VALUE;
        double mindiff = Double.MIN_VALUE;
        double oldrange = 0.0;
        for (int i = 0; i < size; ++i) {
            logMaks = Math.log(mdata[i]);
            logFrame = Math.log(idata[i]);
            logdiffresult[i] = logFrame - 0.625 * logMaks;
            if (logdiffresult[i] > maxdiff) {
                maxdiff = logdiffresult[i];
            }
            if (!(logdiffresult[i] < mindiff)) continue;
            mindiff = logdiffresult[i];
        }
        oldrange = maxdiff - mindiff;
        double newrange = newmax = Math.log(2047.0);
        double scale = 0.0;
        for (int i = 0; i < size; ++i) {
            scale = (logdiffresult[i] - mindiff) / oldrange;
            logdiffresult[i] = newrange * scale;
            odata[i] = (short)Math.exp(logdiffresult[i]);
        }
    }
}

