/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.AvgSubDSAImageOp;
import com.ge.med.cse.cvf.util.DSAImageOp;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpPipeline;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSeqItem;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CvDSAImageUtils {
    public static final String MASK_OP_AVG_SUB = "AVG_SUB";
    public static final String MASK_REMOVED = "MaskRemoved";
    public static final DMTag mask_sub_seq = new DMTag(40, 24832);
    public static final DMTag mask_op_tag = new DMTag(40, 24833);
    public static final DMTag applicable_frame_range_tag = new DMTag(40, 24834);
    public static final DMTag mask_frame_nums_tag = new DMTag(40, 24848);
    public static final DMTag contrast_frame_avg_tag = new DMTag(40, 24850);
    public static final DMTag mask_sub_pixel_shift_tag = new DMTag(40, 24852);
    public static final DMTag recomm_view_mode_tag = new DMTag(40, 4240);
    public static final DMTag multi_frame_tag = new DMTag(40, 8);
    public static final DMTag image_inst_uid_tag = new DMTag(8, 24);
    public static final XpDicomElement image_inst_uid_elem = new XpDicomElement(8, 24);
    public static final String MASK_APPLIED = "mask_applied_property";
    public static final String MANUAL_MASK_INDEX = "manual_mask_index";

    public static void applymask(XpViewport port) {
        DMComposite dmc;
        XpImage img;
        if (port == null) {
            return;
        }
        FrameOwner fcap = (FrameOwner)((Object)port.getCapable(FrameOwner.class.getName()));
        if (fcap != null && (img = fcap.getFrame()) instanceof XpMedicalDmImage && CvDSAImageUtils.isDSASupported(dmc = ((XpMedicalDmImage)img).getDMImage().getComposite()) && MASK_OP_AVG_SUB.equals(CvDSAImageUtils.getMaskOperationType(dmc))) {
            MaskSeqImpl maskseq = new MaskSeqImpl();
            maskseq.load(dmc);
            String uid = (String)dmc.getValue(image_inst_uid_tag);
            CvDSAImageUtils.applyMask(port, maskseq.getMaskItems(), uid);
        }
        port.refreshContents();
        port.repaint();
    }

    public static void applyFrameAsMask(XpViewport port, int frameIndex) {
        if (port == null) {
            return;
        }
        FrameCapable fcap = (FrameCapable)((Object)port.getCapable(FrameCapable.class.getName()));
        FramePositioningCapable fpcap = (FramePositioningCapable)port.getCapable(FramePositioningCapable.class.getName());
        SelectionCapable scap = (SelectionCapable)port.getCapable(SelectionCapable.class.getName());
        if (fpcap != null && fcap != null) {
            int maskIndex = frameIndex;
            if (maskIndex < 1 || maskIndex >= fcap.getNumFrames()) {
                maskIndex = scap != null && scap.getComponentSelection() >= 0 ? fpcap.getFrameIndex() + scap.getComponentSelection() + 1 : fpcap.getFrameIndex() + 1;
            }
            AvgSubMaskItem mask = new AvgSubMaskItem(fcap, new int[]{maskIndex}, null, 0, 0.0, 0.0);
            String uid = null;
            XpImage img = fcap.getFrame(maskIndex - 1);
            if (img instanceof XpDicomObject) {
                ((XpDicomObject)((Object)img)).getValue(image_inst_uid_elem);
                uid = image_inst_uid_elem.getStringValue();
            }
            CvDSAImageUtils.applyMask(port, new MaskItem[]{mask}, uid);
        }
    }

    public static void applyMask(XpViewport port, MaskItem[] masks, String refUID) {
        if (port == null || masks == null || masks.length == 0) {
            return;
        }
        for (int j = 0; j < masks.length; ++j) {
            XpImageRenderAttributes ira;
            AvgSubDSAImageOp dsaop;
            XpImageScene sc;
            int idx;
            int i;
            int nframes;
            int nscenes;
            XpViewport cport;
            MaskItem mitem = masks[j];
            int[] cframes = mitem.getApplicableContrastFrames();
            if (port instanceof XpCompositePort) {
                cport = (XpCompositePort)port;
                nscenes = ((XpCompositePort)cport).getNumScenes();
                nframes = cframes == null ? nscenes : cframes.length;
                for (i = 0; i < nframes; ++i) {
                    int n = idx = cframes != null ? cframes[i] - 1 : i;
                    if (idx < 0 || idx >= nscenes) continue;
                    sc = ((XpCompositePort)cport).getScene(idx);
                    if (refUID != null && !CvDSAImageUtils.sameUID(sc.getFrame(), refUID)) continue;
                    dsaop = new AvgSubDSAImageOp(mitem, idx);
                    ira = sc.getImageRenderAttributes();
                    ira.addImageOperation(dsaop);
                    sc.setImageRenderAttributes(ira);
                }
                port.putClientProperty(MASK_APPLIED, true);
                port.firePropertyChange(MASK_REMOVED, true, false);
                continue;
            }
            if (!(port instanceof XpImageViewport)) continue;
            cport = (XpImageViewport)port;
            nscenes = ((XpImageViewport)cport).getNumScenes();
            nframes = cframes == null ? nscenes : cframes.length;
            for (i = 0; i < nframes; ++i) {
                int n = idx = cframes != null ? cframes[i] - 1 & 0xFF : i;
                if (idx < 0 || idx >= nscenes || (sc = ((XpImageViewport)cport).getScene(idx)) == null || refUID != null && !CvDSAImageUtils.sameUID(sc.getFrame(), refUID)) continue;
                dsaop = new AvgSubDSAImageOp(mitem);
                ira = sc.getImageRenderAttributes();
                ira.addImageOperation(dsaop);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, true);
            port.firePropertyChange(MASK_REMOVED, true, false);
        }
        port.refreshContents();
        port.repaint();
    }

    private static boolean sameUID(XpImage img, String uid) {
        if (uid != null && img instanceof XpDicomObject) {
            ((XpDicomObject)((Object)img)).getValue(image_inst_uid_elem);
            if (uid.equals(CvDSAImageUtils.image_inst_uid_elem.value)) {
                return true;
            }
        }
        return false;
    }

    public static void unapplyMask(XpViewport port) {
        if (port instanceof XpCompositePort) {
            XpCompositePort cport = (XpCompositePort)port;
            int nscenes = cport.getNumScenes();
            for (int i = 0; i < nscenes; ++i) {
                XpImageScene sc = cport.getScene(i);
                XpImageRenderAttributes ira = sc.getImageRenderAttributes();
                List imops = ira.getImageOperations();
                ArrayList newimops = new ArrayList();
                for (Object o : imops) {
                    if (o instanceof DSAImageOp) continue;
                    newimops.add(o);
                }
                ira.setImageOperationList(newimops);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, false);
            port.firePropertyChange(MASK_REMOVED, false, true);
        } else if (port instanceof XpImageViewport) {
            XpImageViewport cport = (XpImageViewport)port;
            int nscenes = cport.getNumScenes();
            for (int i = 0; i < nscenes; ++i) {
                XpImageScene sc = cport.getScene(i);
                if (sc == null) continue;
                XpImageRenderAttributes ira = sc.getImageRenderAttributes();
                List imops = ira.getImageOperations();
                ArrayList newimops = new ArrayList();
                for (Object o : imops) {
                    if (o instanceof DSAImageOp) continue;
                    newimops.add(o);
                }
                ira.setImageOperationList(newimops);
                sc.setImageRenderAttributes(ira);
            }
            port.putClientProperty(MASK_APPLIED, false);
            port.firePropertyChange(MASK_REMOVED, false, true);
        }
        port.refreshContents();
        port.repaint();
    }

    public static boolean isRecommendedViewingModeSUB(DMTagValueInterface image) {
        String o = (String)image.getValue(recomm_view_mode_tag);
        return o != null && "SUB".equalsIgnoreCase(o);
    }

    public static boolean isDSASupported(DMTagValueInterface image) {
        DMSeqItem item;
        String maskop;
        DMSequence maskseq;
        int nitems;
        int bpp = DicomUtils.getBitsPerPix(image);
        if (bpp != 16) {
            return false;
        }
        if (CvDSAImageUtils.getNumFrames(image) <= 1) {
            return false;
        }
        Object o = image.getValue(mask_sub_seq);
        return o instanceof DMSequence && (nitems = (maskseq = (DMSequence)o).getNumberOfItems()) > 0 && MASK_OP_AVG_SUB.equals(maskop = (String)(item = maskseq.getItem(0)).getValue(mask_op_tag));
    }

    public static String getMaskOperationType(DMTagValueInterface image) {
        DMSequence maskseq;
        int nitems;
        Object o = image.getValue(mask_sub_seq);
        if (o instanceof DMSequence && (nitems = (maskseq = (DMSequence)o).getNumberOfItems()) > 0) {
            DMSeqItem item = maskseq.getItem(0);
            String maskop = (String)item.getValue(mask_op_tag);
            return maskop;
        }
        return "NONE";
    }

    public static int getNumFrames(DMTagValueInterface object) {
        Object o = object.getValue(multi_frame_tag);
        int numFrames = 1;
        if (o instanceof Integer) {
            numFrames = (Integer)o;
        } else if (o instanceof String) {
            numFrames = Integer.parseInt((String)o);
        }
        return numFrames;
    }

    public static int[] getIntArrayValue(Object value) {
        int[] intArray = null;
        if (value instanceof String) {
            String v = (String)value;
            StringTokenizer tokenizer = new StringTokenizer(v, "\\");
            intArray = new int[tokenizer.countTokens()];
            for (int i = 0; i < intArray.length; ++i) {
                intArray[i] = Integer.parseInt(tokenizer.nextToken());
            }
        } else if (value instanceof Integer[]) {
            Integer[] vals = (Integer[])value;
            intArray = new int[vals.length];
            for (int i = 0; i < intArray.length; ++i) {
                intArray[i] = vals[i];
            }
        } else if (value instanceof Integer) {
            intArray = new int[]{(Integer)value};
        }
        return intArray;
    }

    public static double[] getDoubleArrayValue(Object value) {
        double[] doubleArray;
        block5: {
            block7: {
                block6: {
                    block4: {
                        int i;
                        Number[] dv;
                        doubleArray = null;
                        if (value instanceof Double[]) {
                            dv = (Double[])value;
                            doubleArray = new double[dv.length];
                            for (i = 0; i < dv.length; ++i) {
                                doubleArray[i] = (Double)dv[i];
                            }
                        }
                        if (!(value instanceof Float[])) break block4;
                        dv = (Float[])value;
                        doubleArray = new double[dv.length];
                        for (i = 0; i < dv.length; ++i) {
                            doubleArray[i] = ((Float)dv[i]).doubleValue();
                        }
                        break block5;
                    }
                    if (!(value instanceof Double)) break block6;
                    doubleArray = new double[]{(Double)value};
                    break block5;
                }
                if (!(value instanceof Float)) break block7;
                doubleArray = new double[]{((Float)value).doubleValue()};
                break block5;
            }
            if (!(value instanceof String)) break block5;
            String v = (String)value;
            StringTokenizer tokenizer = new StringTokenizer(v, "\\");
            doubleArray = new double[tokenizer.countTokens()];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = Double.parseDouble(tokenizer.nextToken());
            }
        }
        return doubleArray;
    }

    public static BufferedImage average(BufferedImage[] imgs, BufferedImage out) {
        if (imgs == null || imgs.length == 0) {
            return null;
        }
        if (imgs[0].getType() == 11) {
            if (out == null) {
                out = new BufferedImage(imgs[0].getWidth(), imgs[0].getHeight(), imgs[0].getType());
            }
            if (out.getWidth() == imgs[0].getWidth() && out.getHeight() == imgs[0].getHeight() && out.getType() == imgs[0].getType()) {
                short[] odata = ((DataBufferUShort)out.getRaster().getDataBuffer()).getData();
                int n = imgs.length;
                for (int i = 0; i < n; ++i) {
                    short[] idata = ((DataBufferUShort)imgs[i].getData().getDataBuffer()).getData();
                    for (int j = 0; j < odata.length; ++j) {
                        int n2 = j;
                        odata[n2] = (short)(odata[n2] + idata[j]);
                    }
                }
                double div = 1.0 / (double)n;
                for (int i = 0; i < odata.length; ++i) {
                    odata[i] = (short)((double)odata[i] * div);
                }
            }
        }
        return out;
    }

    public static class AvgSubMaskItem
    implements MaskItem {
        private DMComposite dmcomp = null;
        private int seqItemIndex = 0;
        private FrameCapable port = null;
        private BufferedImage mask = null;
        private int[] maskFrames = null;
        private int[] applicableContFrames = null;
        private int contFrameAvg = 1;
        private double maskPixelShiftX = 0.0;
        private double maskPixelShiftY = 0.0;
        private JnAffineTransform at = new JnAffineTransform();
        private JnAffineTransform invT = new JnAffineTransform();
        private XpGeomUtils geomUtils = new XpGeomUtils();
        private double[] tx = new double[6];
        private double[] itx = new double[6];

        public AvgSubMaskItem(DMComposite dcomp, int itemIndex) {
            this.dmcomp = dcomp;
            this.seqItemIndex = itemIndex;
            this.init(dcomp);
        }

        public AvgSubMaskItem(FrameCapable port, int[] maskFrameNum, int[] applicableContFrameNum, int contFrameAvgNum, double maskPixShiftRow, double maskPixShiftCol) {
            this.port = port;
            this.maskFrames = maskFrameNum;
            this.applicableContFrames = applicableContFrameNum;
            this.contFrameAvg = contFrameAvgNum;
            this.maskPixelShiftX = maskPixShiftCol;
            this.maskPixelShiftY = maskPixShiftRow;
            if (port != null && this.maskFrames.length > 0) {
                BufferedImage[] imgs = new BufferedImage[this.maskFrames.length];
                for (int i = 0; i < this.maskFrames.length; ++i) {
                    int idx = this.maskFrames[i] - 1;
                    if (idx < 0 || idx >= port.getNumFrames()) continue;
                    imgs[i] = (BufferedImage)port.getFrame(idx).getPixelData();
                }
                this.generateMask(imgs);
            }
        }

        public double[] getMaskSubPixelShift() {
            return new double[]{this.maskPixelShiftX, this.maskPixelShiftY};
        }

        @Override
        public int[] getApplicableContrastFrames() {
            return this.applicableContFrames;
        }

        public int getContrastFrameAveraging() {
            return this.contFrameAvg;
        }

        public int[] getMaskFrames() {
            return this.maskFrames;
        }

        @Override
        public BufferedImage getMask() {
            return this.mask;
        }

        public BufferedImage getContrastFrame(int index) {
            int nframes;
            if (this.port != null && index > 0 && index <= this.port.getNumFrames()) {
                return (BufferedImage)this.port.getFrame(index - 1).getPixelData();
            }
            if (this.dmcomp != null && (nframes = CvDSAImageUtils.getNumFrames(this.dmcomp)) > 0 && index > 0 && index <= nframes) {
                DMImage[] frames = this.dmcomp.getImages(null);
                return frames[index - 1].getPixelData();
            }
            return null;
        }

        public void load(DMComposite dmc) {
            this.dmcomp = dmc;
            this.init(dmc);
        }

        private void init(DMComposite dmc) {
            DMSeqItem item;
            String maskop;
            DMSequence maskseq;
            int nitems;
            if (dmc == null) {
                return;
            }
            Object o = dmc.getValue(mask_sub_seq);
            if (o instanceof DMSequence && (nitems = (maskseq = (DMSequence)o).getNumberOfItems()) > this.seqItemIndex && CvDSAImageUtils.MASK_OP_AVG_SUB.equals(maskop = (String)(item = maskseq.getItem(this.seqItemIndex)).getValue(mask_op_tag))) {
                this.maskFrames = CvDSAImageUtils.getIntArrayValue(item.getValue(mask_frame_nums_tag));
                Object v = item.getValue(contrast_frame_avg_tag);
                if (v instanceof Short) {
                    this.contFrameAvg = (Short)v & 0xFF;
                } else if (v instanceof String) {
                    this.contFrameAvg = Short.parseShort((String)v) & 0xFF;
                }
                int[] cfs = CvDSAImageUtils.getIntArrayValue(item.getValue(applicable_frame_range_tag));
                if (cfs != null) {
                    int i;
                    Hashtable<Integer, Integer> cfslist = new Hashtable<Integer, Integer>();
                    for (i = 0; i < cfs.length; i += 2) {
                        for (int j = cfs[i]; j <= cfs[i + 1]; ++j) {
                            if (cfslist.contains(j)) continue;
                            cfslist.put(j, j);
                        }
                    }
                    this.applicableContFrames = new int[cfslist.size()];
                    i = 0;
                    Iterator it = cfslist.keySet().iterator();
                    while (it.hasNext()) {
                        this.applicableContFrames[i] = (Integer)it.next();
                        ++i;
                    }
                    Arrays.sort(this.applicableContFrames);
                } else {
                    int nframes = CvDSAImageUtils.getNumFrames(dmc);
                    int lastframe = nframes - this.contFrameAvg + 1;
                    this.applicableContFrames = new int[lastframe];
                    for (int i = 0; i < lastframe; ++i) {
                        this.applicableContFrames[i] = i + 1;
                    }
                }
                double[] dvals = CvDSAImageUtils.getDoubleArrayValue(item.getValue(mask_sub_pixel_shift_tag));
                if (dvals != null && dvals.length == 2) {
                    this.maskPixelShiftX = dvals[1];
                    this.maskPixelShiftY = dvals[0];
                }
            }
            if (this.maskFrames != null && this.maskFrames.length > 0) {
                DMImage[] frames = this.dmcomp.getImages(null);
                BufferedImage[] imgs = new BufferedImage[this.maskFrames.length];
                for (int i = 0; i < this.maskFrames.length; ++i) {
                    imgs[i] = frames[this.maskFrames[i] - 1].getPixelData();
                }
                this.generateMask(imgs);
            }
        }

        private void generateMask(BufferedImage[] imgs) {
            if (imgs != null && imgs.length > 0) {
                BufferedImage tmp = new BufferedImage(imgs[0].getWidth(), imgs[0].getHeight(), imgs[0].getType());
                CvDSAImageUtils.average(imgs, tmp);
                this.mask = new BufferedImage(tmp.getWidth(), tmp.getHeight(), tmp.getType());
                short[] maskdata = ((DataBufferUShort)this.mask.getRaster().getDataBuffer()).getData();
                short[] idata = ((DataBufferUShort)tmp.getData().getDataBuffer()).getData();
                if (this.maskPixelShiftX != 0.0 || this.maskPixelShiftY != 0.0) {
                    this.at.setToIdentity();
                    this.at.translate(-this.maskPixelShiftX, this.maskPixelShiftY);
                    this.at.getMatrix(this.tx);
                    this.geomUtils.calcInverse(this.at, this.invT);
                    this.invT.getMatrix(this.itx);
                    XpPipeline.doBilinearShortToShortUpright(this.tx, this.itx, idata, 0, this.mask.getWidth(), this.mask.getHeight(), 0, 16, maskdata, this.mask.getWidth(), this.mask.getHeight(), (short)0);
                } else {
                    for (int i = 0; i < maskdata.length; ++i) {
                        maskdata[i] = idata[i];
                    }
                }
            }
        }
    }

    public static class MaskSeqImpl
    implements MaskSeq {
        private MaskItem[] masks = null;

        @Override
        public void load(DMComposite dmc) {
            Object o = dmc.getValue(mask_sub_seq);
            if (o instanceof DMSequence) {
                DMSequence maskseq = (DMSequence)o;
                int nitems = maskseq.getNumberOfItems();
                ArrayList<AvgSubMaskItem> mlist = new ArrayList<AvgSubMaskItem>();
                for (int i = 0; i < nitems; ++i) {
                    DMSeqItem item = maskseq.getItem(i);
                    String maskop = (String)item.getValue(mask_op_tag);
                    if (!CvDSAImageUtils.MASK_OP_AVG_SUB.equals(maskop)) continue;
                    AvgSubMaskItem mitem = new AvgSubMaskItem(dmc, i);
                    mlist.add(mitem);
                }
                if (mlist.size() > 0) {
                    this.masks = mlist.toArray(new MaskItem[mlist.size()]);
                }
            }
        }

        @Override
        public int getNumMaskItems() {
            if (this.masks != null) {
                return this.masks.length;
            }
            return 0;
        }

        @Override
        public MaskItem getMaskItem(int index) {
            if (this.masks != null && index >= 0 && index < this.masks.length) {
                return this.masks[index];
            }
            return null;
        }

        @Override
        public MaskItem[] getMaskItems() {
            return this.masks;
        }
    }

    public static interface MaskItem {
        public BufferedImage getMask();

        public int[] getApplicableContrastFrames();
    }

    public static interface MaskSeq {
        public void load(DMComposite var1);

        public int getNumMaskItems();

        public MaskItem getMaskItem(int var1);

        public MaskItem[] getMaskItems();
    }
}

