/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class CvPropertiesManager {
    private static Properties prop = null;
    private static Logger logger = Logger.getLogger("com.ge.med.cse.cvf");
    private static Preferences userPrefs;

    private static void init() {
        try {
            prop = new Properties();
            CvPropertiesManager.loadDefaults();
            prop.putAll((Map<?, ?>)System.getProperties());
            if (CvPropertiesManager.getProperty("cvf.properties") != null) {
                String[] propertyFiles = CvPropertiesManager.getProperty("cvf.properties").split("#");
                for (int i = 0; i < propertyFiles.length; ++i) {
                    CvPropertiesManager.loadPropertyValues(propertyFiles[i]);
                }
            }
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Error during init", exp);
        }
    }

    private CvPropertiesManager() {
    }

    static void loadDefaults() {
        InputStream inStream = CvPropertiesManager.class.getResourceAsStream("cvf.properties");
        InputStream iconStream = CvPropertiesManager.class.getResourceAsStream("Icons.properties");
        CvPropertiesManager.loadPropertyValues(inStream);
        CvPropertiesManager.loadPropertyValues(iconStream);
        try {
            inStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception while loading the properties", e.getLocalizedMessage());
            e.printStackTrace();
        }
        finally {
            try {
                iconStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadPropertyValues(String propertyFile) {
        try {
            FileInputStream fis = new FileInputStream(propertyFile);
            CvPropertiesManager.loadPropertyValues(fis);
            fis.close();
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Error during external property load, exception stack trace ", exp);
        }
    }

    public static void loadPropertyValues(InputStream is) {
        try {
            prop.load(is);
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Error during external property load, exception stack trace ", exp);
        }
    }

    public static void loadProperties(Properties propToLoad) {
        prop.putAll((Map<?, ?>)propToLoad);
    }

    public static Properties getProperties() {
        return prop;
    }

    public static String getProperty(String propName) {
        return CvPropertiesManager.getProperty(propName, null);
    }

    public static String getProperty(String propName, String defaultValue) {
        return prop.getProperty(propName, defaultValue);
    }

    public static boolean getBoolean(String strkey, boolean defValue) {
        String val = CvPropertiesManager.getProperty(strkey, Boolean.toString(defValue));
        return val != null && (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes"));
    }

    public static void setProperty(String propName, String value) {
        prop.setProperty(propName, value);
        logger.finer("Setting Key=" + propName + "  Value=" + value);
    }

    public static Preferences getUserPreferences() {
        return userPrefs != null ? userPrefs : (userPrefs = Preferences.userRoot());
    }

    static {
        CvPropertiesManager.init();
    }
}

