/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.PaintListener;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CvSingleCineMotor {
    private int origfps = 10;
    private int actualfps = -1;
    private boolean noskip = true;
    private boolean cineOn = false;
    private boolean pauseCine = false;
    private Timer cineThread = null;
    private Timer cineRateUpdateThread = null;
    private int rateUpdateFreq = 2;
    private long startTime = 0L;
    private long endTime = 0L;
    private XPscreen screen = null;
    private XpViewport viewer = null;
    private int frame;
    private int[] offsetMap;
    private int[] nextOffsetMap;
    private final int avgPaintTimePerFrame;
    private int paintTimePerFrame = this.avgPaintTimePerFrame = Integer.parseInt(CvPropertiesManager.getProperty("cvf.cine.avgPaintTimePerFrame", "20").trim());
    private final long refreshTime = Integer.parseInt(CvPropertiesManager.getProperty("cvf.cine.fpsRefreshTime", "10").trim()) * 1000;
    private static final Logger logger = Logger.getLogger(CvSingleCineMotor.class.getName());
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_cine");
    private Thread pauseThread = null;
    private long expectedpaintCount = 0L;
    private long paintCount = 0L;
    private int paintFor = -1;
    private PaintListener plsnr = new PaintListener(){

        @Override
        public void paintComplete(JComponent source) {
            if (CvSingleCineMotor.this.cineOn) {
                CineCapable port = (CineCapable)((Object)CvSingleCineMotor.this.viewer);
                if (CvSingleCineMotor.this.paintFor != port.getOffset()) {
                    CvSingleCineMotor.this.paintCount++;
                    CvSingleCineMotor.this.paintFor = port.getOffset();
                    if (!CvSingleCineMotor.this.pauseCine && CvSingleCineMotor.this.noskip) {
                        CvSingleCineMotor.this.cineThread.restart();
                    }
                } else if (CvSingleCineMotor.this.offsetMap[CvSingleCineMotor.this.frame] != port.getOffset()) {
                    int index = CvSingleCineMotor.this.frame - 1 < 0 ? 0 : CvSingleCineMotor.this.frame - 1;
                    CvSingleCineMotor.this.frame = CvSingleCineMotor.this.nextOffsetMap[index];
                    CvSingleCineMotor.this.expectedpaintCount--;
                    if (!CvSingleCineMotor.this.pauseCine && CvSingleCineMotor.this.noskip) {
                        CvSingleCineMotor.this.cineThread.restart();
                    }
                }
            }
        }
    };
    private PropertyChangeListener portListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("CineRate".equals(evt.getPropertyName()) && evt.getSource() instanceof CineCapable) {
                int rate = ((CineCapable)evt.getSource()).getCineRate();
                CvSingleCineMotor.this.setCineRate(1000 / rate);
            }
        }
    };

    public CvSingleCineMotor() {
        String val = CvPropertiesManager.getProperty("cvf.cine.noskip", "false");
        this.noskip = "true".equalsIgnoreCase(val);
    }

    public synchronized void attachViewer(XpViewport vp) throws UnsupportedOperationException {
        if (this.viewer != null) {
            this.viewer.removePaintListener(this.plsnr);
        }
        if (!(vp instanceof CineCapable)) {
            throw new UnsupportedOperationException("Cine not supported on this Viewport");
        }
        this.viewer = vp;
        this.screen = (XPscreen)SwingUtilities.getAncestorOfClass(XPscreen.class, vp);
    }

    public synchronized void detachViewer() {
        if (this.viewer != null) {
            this.viewer.removePaintListener(this.plsnr);
        }
        this.viewer = null;
        this.screen = null;
    }

    public void setCineRate(int fps) {
        if (this.origfps == fps) {
            return;
        }
        this.origfps = fps;
        int n = this.origfps > 30 ? 10 : (this.paintTimePerFrame = this.origfps > 15 ? 15 : 20);
        if (this.cineThread != null) {
            int delay = (int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps);
            if (delay < 0) {
                delay = 0;
            }
            if (this.noskip) {
                this.cineThread.setInitialDelay(delay);
            } else {
                this.cineThread.setDelay(delay);
            }
        }
        this.paintCount = 0L;
        this.expectedpaintCount = 0L;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public int getActualFps() {
        if (this.cineOn) {
            long eTime = System.currentTimeMillis();
            double timediff = eTime - this.startTime;
            if (timediff != 0.0) {
                this.actualfps = (int)Math.round((double)(this.paintCount * 1000L) / timediff);
                if (timediff > (double)this.refreshTime) {
                    long epc = this.expectedpaintCount > this.paintCount ? this.expectedpaintCount - this.paintCount : 0L;
                    this.reset();
                    this.expectedpaintCount = epc;
                    this.startTime = System.currentTimeMillis();
                }
            }
            return this.actualfps;
        }
        return this.actualfps;
    }

    public int getFramesSkipped() {
        return (int)(this.expectedpaintCount - this.paintCount);
    }

    public boolean isCineOn() {
        return this.cineOn;
    }

    public void start() {
        logger.log(Level.INFO, "{0} begin", tln);
        if (this.viewer == null) {
            return;
        }
        this.reset();
        CineCapable port = (CineCapable)((Object)this.viewer);
        if (this.cineThread == null) {
            int delay;
            int totalframes = port.getEndOffset() - port.getStartOffset();
            int result = 1;
            int cineInterval = port.getCineSkip();
            int curFrame = cineInterval < 0 ? port.getEndOffset() : port.getStartOffset();
            int size = 0;
            if (totalframes > 0 && totalframes >= Math.abs(cineInterval)) {
                result = totalframes / Math.abs(cineInterval);
                if (port.getCineMode() == 0) {
                    size = result + 1;
                } else {
                    int n = size = result > 1 ? result * 2 : result + 1;
                }
            }
            if (size <= 0) {
                return;
            }
            if (this.noskip) {
                this.viewer.addPaintListener(this.plsnr);
            }
            this.offsetMap = new int[size];
            this.nextOffsetMap = new int[size];
            for (int j = 0; j < size; ++j) {
                this.nextOffsetMap[j] = j + 1;
                this.offsetMap[j] = j <= result ? curFrame + j * cineInterval : curFrame + --result * cineInterval;
            }
            this.nextOffsetMap[size - 1] = 0;
            this.frame = 0;
            port.setOffset(this.offsetMap[this.frame]);
            this.cineOn = true;
            int n = delay = this.noskip ? 0 : (int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps);
            if (delay < 0) {
                delay = 0;
            }
            this.cineThread = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CvSingleCineMotor.this.frame = CvSingleCineMotor.this.nextOffsetMap[CvSingleCineMotor.this.frame];
                    CvSingleCineMotor.this.expectedpaintCount++;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((CineCapable)((Object)CvSingleCineMotor.this.viewer)).setOffset(CvSingleCineMotor.this.offsetMap[CvSingleCineMotor.this.frame]);
                            CvSingleCineMotor.this.viewer.repaint();
                        }
                    });
                }
            });
            this.cineThread.setCoalesce(!this.noskip);
            this.cineThread.setRepeats(!this.noskip);
            this.cineThread.start();
            if (this.noskip) {
                this.restartCineRateUpdate();
                this.cineThread.setInitialDelay((int)((1000.0 - (double)(this.origfps * this.paintTimePerFrame)) / (double)this.origfps));
            } else {
                this.cineThread.setDelay(delay);
            }
            if (this.screen != null) {
                this.screen.addPropertyChangeListener(this.portListener);
            } else {
                this.viewer.addPropertyChangeListener(this.portListener);
            }
            this.startTime = System.currentTimeMillis();
        } else {
            if (this.noskip) {
                this.restartCineRateUpdate();
            }
            this.cineThread.restart();
        }
    }

    public void stop() {
        if (this.viewer == null) {
            return;
        }
        if (this.screen != null) {
            this.screen.removePropertyChangeListener(this.portListener);
        } else {
            this.viewer.removePropertyChangeListener(this.portListener);
        }
        this.cineOn = false;
        this.pauseCine = false;
        if (this.cineThread != null) {
            this.cineThread.stop();
            this.viewer.repaint();
        }
        this.cineThread = null;
        this.viewer.removePaintListener(this.plsnr);
        this.frame = 0;
        this.offsetMap = null;
        this.nextOffsetMap = null;
        if (this.pauseThread != null) {
            this.pauseThread.interrupt();
        }
        this.pauseThread = null;
        if (this.cineRateUpdateThread != null) {
            this.cineRateUpdateThread.stop();
            this.cineRateUpdateThread = null;
        }
        this.endTime = System.currentTimeMillis();
        double timediff = this.endTime - this.startTime;
        if (timediff != 0.0) {
            this.actualfps = (int)Math.round((double)(this.paintCount * 1000L) / timediff);
        }
        int width = 0;
        int height = 0;
        int numFrames = 0;
        if (this.viewer instanceof FrameOwner) {
            width = ((FrameOwner)((Object)this.viewer)).getFrame().getSlice().width;
            height = ((FrameOwner)((Object)this.viewer)).getFrame().getSlice().height;
        }
        if (this.viewer instanceof CineCapable) {
            numFrames = Math.abs((((CineCapable)((Object)this.viewer)).getEndOffset() - ((CineCapable)((Object)this.viewer)).getStartOffset() + 1) / ((CineCapable)((Object)this.viewer)).getCineSkip());
        }
        logger.log(Level.INFO, "{0} end , NUMIMAGES=" + numFrames + " IMAGESIZE=" + width + "x" + height + " SETFRAMERATE=" + this.origfps + " ACTUALFRAMERATE=" + this.getActualFps() + " FRAMESSKIPPED=" + this.getFramesSkipped(), tln);
    }

    public void pause() {
        if (this.viewer == null) {
            return;
        }
        this.pauseCine = true;
        this.startPauseThread();
    }

    public void resume() {
        if (this.viewer == null) {
            return;
        }
        this.pauseCine = false;
        if (this.pauseThread != null) {
            this.pauseThread.interrupt();
        }
        this.pauseThread = null;
        if (this.cineOn) {
            this.start();
        }
    }

    private void reset() {
        this.paintCount = 0L;
        this.expectedpaintCount = 0L;
        this.paintFor = -1;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    public boolean isPaused() {
        return this.pauseCine;
    }

    private void startPauseThread() {
        if (this.viewer == null) {
            return;
        }
        if (this.pauseThread == null) {
            if (this.cineThread != null) {
                this.cineThread.stop();
            }
            if (this.cineRateUpdateThread != null) {
                this.cineRateUpdateThread.stop();
            }
            this.pauseThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (CvSingleCineMotor.this.pauseCine && CvSingleCineMotor.this.cineOn) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            this.pauseThread.start();
        }
    }

    public void restartCineRateUpdate() {
        if (this.cineRateUpdateThread != null) {
            this.cineRateUpdateThread.restart();
        } else {
            this.cineRateUpdateThread = new Timer(this.rateUpdateFreq * 1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int fps = CvSingleCineMotor.this.getActualFps();
                    int n = fps = fps > 0 && fps < CvSingleCineMotor.this.origfps - 3 ? fps : -1;
                    if (CvSingleCineMotor.this.screen != null) {
                        CvSingleCineMotor.this.screen.firePropertyChange("NO_SKIP_RATE", CvSingleCineMotor.this.origfps, fps);
                    } else {
                        CvSingleCineMotor.this.viewer.firePropertyChange("NO_SKIP_RATE", CvSingleCineMotor.this.origfps, fps);
                    }
                }
            });
            this.cineRateUpdateThread.start();
        }
    }
}

