/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.comparators.CVDefaultExamComparator;
import com.ge.med.cse.cvf.comparators.DefaultImComparator;
import com.ge.med.cse.cvf.comparators.DoubleComparator;
import com.ge.med.cse.cvf.comparators.NumberComparator;
import com.ge.med.cse.cvf.comparators.SeriesNumberComparator;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.print.PrintProgress;
import com.ge.med.cse.cvf.roi.DefaultROIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.attribute.PrintJobAttributeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;

public class CvUtils {
    private static DMSystem dmsystem = null;
    private static PrintService printService_ = null;
    public static final Logger logger = Logger.getLogger(CvUtils.class.getName());
    public static final String[] SORT_STRINGS = new String[]{"Image Number, ^", "Image Number, v", "Location", "Echo", "Trigger"};
    public static final String SORT_BY_IMAGE_NUMBER = "image_number";
    public static final int sort_by_image_number = 1;
    public static final String SORT_BY_SERIES_NUMBER = "series_number";
    public static final int sort_by_series_number = 2;
    public static final String SORT_BY_BASE_SERIES_NUMBER = "base_series_number";
    public static final int sort_by_base_series_number = 22;
    public static final String SORT_BY_EXAM_NUMBER = "exam_number";
    public static final int sort_by_exam_number = 3;
    public static final String SORT_BY_IMAGE_LOCATION = "image_location";
    public static final int sort_by_image_location = 4;
    public static final String SORT_BY_ECHO = "echo";
    public static final int sort_by_echo = 5;
    public static final String SORT_BY_TRIGGER = "trigger";
    public static final int sort_by_trigger = 6;
    public static HashMap sortMap = new HashMap();
    private static final int largeSeries;
    private static XpDicomElement pixSpaceEl;
    private static DMTag pixSpaceTag;
    private static XpDicomElement seuid;
    private static DMTag seuidtag;
    private static XpDicomElement imguid;
    private static DMTag imguidtag;
    private static Map<String, Map<String, Double>> calibrationMap;
    private static ROIUtils roiutils;
    public static final int ALL_IMAGES = 0;
    public static final int NO_IMAGES = -1;
    public static final int PARTIAL_IMAGES = 1;
    private static final XpDicomElement mod;

    public static Comparator getNumberComparator(int group, int element) {
        return new NumberComparator(group, element);
    }

    public static Comparator getDoubleComparator(int group, int element) {
        return new DoubleComparator(group, element);
    }

    public static DMObject[] sortSeries(DMObject[] dmo) {
        Arrays.sort(dmo, CvUtils.getNumberComparator(32, 17));
        return dmo;
    }

    public static void sortSeriesByBase(Object[] series) {
        Arrays.sort(series, new SeriesNumberComparator());
    }

    public static void sortImages(Object[] imgs) {
        Arrays.sort(imgs, new DefaultImComparator());
    }

    public static void sortImages(Object[] imgs, Comparator comp) {
        Arrays.sort(imgs, comp);
    }

    public static void sortExam(Object[] exam) {
        Arrays.sort(exam, new CVDefaultExamComparator());
    }

    public static int searchImage(Object[] objs, Object key) {
        return Arrays.binarySearch(objs, key, CvUtils.getNumberComparator(32, 19));
    }

    public static int getLargeSeriesSize() {
        return largeSeries;
    }

    public static double getMaxWW(XpMedicalImage img) {
        String val;
        String modality = DicomUtils.getModality(img);
        if (modality != null && (val = CvPropertiesManager.getProperty("cvf.WWMax." + modality.toUpperCase(Locale.ENGLISH))) != null) {
            if ("mr".equalsIgnoreCase(modality)) {
                double rescaleSlope = img.getRescaleSlope();
                return Double.parseDouble(val) * rescaleSlope;
            }
            return Double.parseDouble(val);
        }
        return 65535.0;
    }

    public static double getMinWW(XpMedicalImage img) {
        String val;
        String modality = DicomUtils.getModality(img);
        if (modality != null && (val = CvPropertiesManager.getProperty("cvf.WWMin." + modality.toUpperCase(Locale.ENGLISH))) != null) {
            if ("mr".equalsIgnoreCase(modality)) {
                double rescaleSlope = img.getRescaleSlope();
                return Double.parseDouble(val) * rescaleSlope;
            }
            return Double.parseDouble(val);
        }
        return 0.0;
    }

    public static double getMaxWL(XpMedicalImage img) {
        String val;
        String modality = DicomUtils.getModality(img);
        if (modality != null && (val = CvPropertiesManager.getProperty("cvf.WLMax." + modality.toUpperCase(Locale.ENGLISH))) != null) {
            if ("mr".equalsIgnoreCase(modality)) {
                double rescaleSlope = img.getRescaleSlope();
                double rescaleIntercept = img.getRescaleIntercept();
                return Double.parseDouble(val) * rescaleSlope + rescaleIntercept;
            }
            return Double.parseDouble(val);
        }
        return 32767.0;
    }

    public static double getMinWL(XpMedicalImage img) {
        String val;
        String modality = DicomUtils.getModality(img);
        if (modality != null && (val = CvPropertiesManager.getProperty("cvf.WLMin." + modality.toUpperCase(Locale.ENGLISH))) != null) {
            if ("mr".equalsIgnoreCase(modality)) {
                double rescaleSlope = img.getRescaleSlope();
                double rescaleIntercept = img.getRescaleIntercept();
                return Double.parseDouble(val) * rescaleSlope + rescaleIntercept;
            }
            return Double.parseDouble(val);
        }
        return -32767.0;
    }

    public static double getMaxZoom() {
        return Double.parseDouble(CvPropertiesManager.getProperty("cvf.zoom.max", Double.toString(8.0)));
    }

    public static double getMinZoom() {
        return Double.parseDouble(CvPropertiesManager.getProperty("cvf.zoom.min", Double.toString(0.1)));
    }

    public static void setEnabled(JComponent component, boolean enable) {
        Component[] children = component.getComponents();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (children[i] instanceof JComponent) {
                CvUtils.setEnabled((JComponent)children[i], enable);
                continue;
            }
            children[i].setEnabled(enable);
        }
        component.setEnabled(enable);
    }

    public static boolean measurementsValid(XpImage img) {
        if (img instanceof XpDicomObject) {
            return CvUtils.measurementsValid((XpDicomObject)((Object)img));
        }
        return false;
    }

    public static boolean measurementsValid(XpDicomObject img) {
        XpDicomElement imgType = new XpDicomElement(8, 8);
        XpDicomElement modality = new XpDicomElement(8, 96);
        img.getValue(imgType);
        String imgTypeVal = "" + imgType.value;
        img.getValue(modality);
        String modalityVal = "" + modality.value;
        if (imgTypeVal == null || imgTypeVal.indexOf("SCREEN SAVE") >= 0 || imgTypeVal.indexOf("VXTL STATE") >= 0 || imgTypeVal.indexOf("3D") >= 0 || imgTypeVal.indexOf("SSAVE") > 0 || modalityVal.indexOf("US") >= 0 || modalityVal.indexOf("SC") >= 0) {
            return false;
        }
        return !DicomUtils.isMRProbeQImage(img);
    }

    public static boolean isGSEFilterValid(XpImage img) {
        if (img instanceof XpDicomObject) {
            return CvUtils.isGSEFilterValid((XpDicomObject)((Object)img));
        }
        return false;
    }

    public static boolean isGSEFilterValid(XpDicomObject img) {
        String modality = DicomUtils.getModality(img);
        String imgType = null;
        if (modality != null) {
            imgType = DicomUtils.getImageType(img, false);
        }
        return imgType != null && imgType.indexOf("SCOUT") < 0;
    }

    public static void putCalibrationFactor(String seriesUID, String imageUID, double calibrationFaactor) {
        Map<String, Double> m = null;
        if (seriesUID != null) {
            m = calibrationMap.get(seriesUID);
        }
        if (m == null) {
            m = new Hashtable<String, Double>();
        }
        m.put(imageUID, calibrationFaactor);
        calibrationMap.put(seriesUID, m);
    }

    public static double getCalibrationFactor(String seriesUID, String imageUID) {
        Map<String, Double> m;
        if (seriesUID != null && (m = calibrationMap.get(seriesUID)) != null && imageUID != null && m.containsKey(imageUID)) {
            return m.get(imageUID);
        }
        return -1.0;
    }

    public static boolean calibrationExists(String seriesUID) {
        Map<String, Double> m = null;
        if (seriesUID != null) {
            m = calibrationMap.get(seriesUID);
        }
        return m != null;
    }

    public static boolean isPixelSpacingPresent(XpDicomObject dmobject) {
        dmobject.getValue(pixSpaceEl);
        String pixelSpacing = pixSpaceEl.getStringValue();
        return pixelSpacing != null;
    }

    public static boolean isPixelSpacingPresent(DMTagValueInterface dmobject) {
        String pixelSpacing = (String)dmobject.getValue(pixSpaceTag);
        return pixelSpacing != null;
    }

    public static boolean needCalibration(XpDicomObject dmobject) {
        boolean pixSpacing = CvUtils.isPixelSpacingPresent(dmobject);
        if (!pixSpacing) {
            XpDicomElement elem1 = new XpDicomElement(8, 8465);
            dmobject.getValue(elem1);
            dmobject.getValue(imguid);
            dmobject.getValue(seuid);
            if (CvUtils.getCalibrationFactor(seuid.getStringValue(), imguid.getStringValue()) != -1.0) {
                return false;
            }
            return elem1.value == null;
        }
        return false;
    }

    public static boolean needCalibration(DMTagValueInterface dmobject) {
        boolean pixSpacing = CvUtils.isPixelSpacingPresent(dmobject);
        if (!pixSpacing) {
            String s;
            String i = (String)dmobject.getValue(imguidtag);
            return CvUtils.getCalibrationFactor(i, s = (String)dmobject.getValue(seuidtag)) == -1.0;
        }
        return false;
    }

    public static int[] parseIntList(String value, String delims) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delims);
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            l.add(val);
        }
        int[] ivals = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            String val = (String)l.get(i);
            ivals[i] = Integer.parseInt(val);
        }
        return ivals;
    }

    public static double[] parseDoubleList(String value, String delims) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delims);
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            l.add(val);
        }
        double[] dvals = new double[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            String val = (String)l.get(i);
            dvals[i] = Double.parseDouble(val);
        }
        return dvals;
    }

    public static String[] parseStringList(String value, String delims) {
        StringTokenizer st = new StringTokenizer(value, delims);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String val = st.nextToken().trim();
            l.add(val);
        }
        String[] s = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            s[i] = (String)l.get(i);
        }
        return s;
    }

    public static Color getColor(String c) {
        String col = c.trim();
        if (col.equalsIgnoreCase("Green")) {
            return Color.GREEN;
        }
        if (col.equalsIgnoreCase("Red")) {
            return Color.RED;
        }
        if (col.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        if (col.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (col.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (col.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (col.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (col.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (col.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (col.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (col.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        return Color.GREEN;
    }

    public static Direction getDirection(int i) {
        switch (i) {
            case 0: {
                return Direction.EAST;
            }
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.WEST;
            }
            case 3: {
                return Direction.NORTH;
            }
            case 4: {
                return Direction.SOUTHEAST;
            }
            case 5: {
                return Direction.SOUTHWEST;
            }
            case 6: {
                return Direction.NORTHWEST;
            }
            case 7: {
                return Direction.NORTHEAST;
            }
            case 8: {
                return Direction.CENTRE;
            }
        }
        return Direction.EAST;
    }

    public static int getIndexForDirection(Direction d) {
        switch (d) {
            case EAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 3;
            }
            case SOUTHEAST: {
                return 4;
            }
            case SOUTHWEST: {
                return 5;
            }
            case NORTHWEST: {
                return 6;
            }
            case NORTHEAST: {
                return 7;
            }
            case CENTRE: {
                return 8;
            }
        }
        return 0;
    }

    public static HandleFactory createHandleFactory(String className) {
        return (HandleFactory)XpPropertiesManager.create(className);
    }

    public static ROIUtils getROIUtils() {
        if (roiutils == null) {
            roiutils = (ROIUtils)XpPropertiesManager.create(CvPropertiesManager.getProperty("cvf.roiutils", DefaultROIUtils.class.getName()));
        }
        return roiutils;
    }

    public static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("com.ge.med.cse.cvf.util.CvResourceBundle");
    }

    public static ResourceBundle getResourceBundle(Locale loc) {
        return ResourceBundle.getBundle("com.ge.med.cse.cvf.util.CvResourceBundle", loc);
    }

    public static Icon getIcon(String strIconKey) {
        String iconpath = CvPropertiesManager.getProperty(strIconKey);
        if (iconpath == null) {
            return null;
        }
        String[] pathAndScale = iconpath.split("#");
        ImageIcon icon = null;
        if (pathAndScale != null && !pathAndScale[0].equalsIgnoreCase("")) {
            icon = new ImageIcon(CvUtils.class.getResource(pathAndScale[0]));
            if (pathAndScale.length == 3) {
                int width = Integer.parseInt(pathAndScale[1]);
                int height = Integer.parseInt(pathAndScale[2]);
                Image imgToScale = icon.getImage();
                icon = new ImageIcon(imgToScale.getScaledInstance(imgToScale.getWidth(null) - width, imgToScale.getHeight(null) - height, 4));
            }
        }
        return icon;
    }

    public static DMSystem getDMSystem() {
        if (dmsystem == null) {
            logger.log(Level.INFO, "{0} begin , creation of DMSystem", new TransactionLogName("CreateDMSystem"));
            String[] strDMSinit = CvPropertiesManager.getProperty("DMSystem", "Nuevo#com.ge.hc.nuevo.sessions.autotasks.NuevoSystem").split("#");
            dmsystem = (DMSystem)CvUtils.createInstance(strDMSinit[1]);
            logger.log(Level.INFO, "{0} end , creation of DMSystem", new TransactionLogName("CreateDMSystem"));
        }
        return dmsystem;
    }

    public static PrintService getDefaultPrintService() {
        if (printService_ == null) {
            boolean useDMSystem = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.printservice.usedmsystem", "false"));
            if (useDMSystem) {
                printService_ = CvUtils.getDMSystem().getPrintService();
            } else {
                String classname = CvPropertiesManager.getProperty("cvf.printservice.class", "com.ge.med.cse.cvf.print.IOSPrintService");
                logger.log(Level.INFO, "Create print service for " + classname);
                printService_ = (PrintService)CvUtils.createInstance(classname);
            }
        }
        return printService_;
    }

    public static Object createInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Point2D getValidImagePoint(Point2D p, Capable c) {
        int x = (int)p.getX();
        int y = (int)p.getY();
        Object vc = null;
        FrameOwner fc = (FrameOwner)((Object)c.getCapable(FrameOwner.class.getName()));
        if (fc != null && fc.getFrame() != null) {
            int height = fc.getFrame().getSlice().getSliceColumns();
            int width = fc.getFrame().getSlice().getSliceRows();
            if (x < 0) {
                x = 0;
            }
            if (x >= width) {
                x = width - 1;
            }
            if (y < 0) {
                y = 0;
            }
            if (y >= height) {
                y = height - 1;
            }
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D getCenterPointOfViewPort(Capable c) {
        FrameOwner fc;
        if (c != null && (fc = (FrameOwner)((Object)c.getCapable(FrameOwner.class.getName()))) != null && fc.getFrame() != null) {
            double y = 0.0;
            int height = fc.getFrame().getSlice().getSliceColumns();
            int width = fc.getFrame().getSlice().getSliceRows();
            double x = (double)width / 2.0;
            y = (double)height / 2.0;
            return new Point2D.Double(x, y);
        }
        return null;
    }

    public static XpMedicalImage[] getXpImages(DMObject[] dmo) {
        if (dmo == null || dmo.length == 0) {
            return null;
        }
        DMImage[] imgs = CvUtils.getImages(dmo, null);
        if (imgs == null || imgs.length == 0) {
            return null;
        }
        XpMedicalImage[] xpimgs = new XpMedicalImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            xpimgs[i] = new XpMedicalDmImage(imgs[i]);
        }
        return xpimgs;
    }

    public static XpMedicalImage[] getXpImages(DMImage[] images) {
        if (images == null || images.length == 0) {
            return null;
        }
        int numImages = images.length;
        XpMedicalImage[] img = new XpMedicalImage[numImages];
        for (int j = 0; j < numImages; ++j) {
            img[j] = new XpMedicalDmImage(images[j]);
        }
        return img;
    }

    public static DMImage[] getImages(DMObject[] dmos, DMTag[] tags) {
        ArrayList imgs = new ArrayList();
        CvUtils.getImages(dmos, tags, imgs);
        if (imgs.size() == 0) {
            return null;
        }
        return imgs.toArray(new DMImage[imgs.size()]);
    }

    public static int getImages(DMObject[] dmos, DMTag[] tags, List dmimgs) {
        if (dmos == null || dmos.length == 0 || dmimgs == null) {
            return -1;
        }
        boolean allImages = true;
        dmimgs.clear();
        for (int i = 0; i < dmos.length; ++i) {
            DMObject[] imgs = dmos[i].getRelated("image");
            if (imgs == null || imgs.length <= 0) continue;
            for (int j = 0; j < imgs.length; ++j) {
                try {
                    DMImage[] dmis = imgs[j].getImages(tags);
                    if (dmis != null && dmis.length > 0) {
                        for (int k = 0; k < dmis.length; ++k) {
                            dmimgs.add(dmis[k]);
                        }
                        continue;
                    }
                    allImages = false;
                    continue;
                }
                catch (Exception ex) {
                    allImages = false;
                }
            }
        }
        if (dmimgs.size() > 0) {
            if (allImages) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public static void updateBackground(JPanel pan, Color c) {
        pan.setBackground(c);
        Component[] children = pan.getComponents();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (children[i] instanceof JPanel) {
                CvUtils.updateBackground((JPanel)children[i], c);
                continue;
            }
            if (!(children[i] instanceof JSlider)) continue;
            children[i].setBackground(c);
        }
    }

    public static void dispose(XpViewport port) {
        if (port instanceof SelectionCapable) {
            int len = ((SelectionCapable)((Object)port)).getNumComponents();
            for (int i = 0; i < len; ++i) {
                JComponent vp = ((SelectionCapable)((Object)port)).getViewportComponent(i);
                if (!(vp instanceof XpViewport)) continue;
                CvUtils.dispose((XpViewport)vp);
            }
        } else {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            if (port instanceof XpSingularPort) {
                XpSingularPort svp = (XpSingularPort)port;
                Container container = (Container)svp.getMedicalImageVc().getComponent(0);
                Component[] children = container.getComponents();
                if (children != null) {
                    for (int j = 0; j < children.length; ++j) {
                        if (!(children[j] instanceof XpViewport)) continue;
                        CvUtils.dispose((XpViewport)children[j]);
                    }
                }
                svp.getAnnotationGenerator().reset();
                ttm.unregisterComponent(svp.getMedicalImageVc().getAnnotationVc());
                svp.getMouseController().setTarget(null);
                svp.setMouseController(null);
                svp.clearActiveAnnotationListeners();
                svp.dispose();
            } else {
                port.dispose();
            }
        }
    }

    public static DMTag[] getNeededTags(String modality, String strImageType) {
        int i;
        DMTag[] toReturn = null;
        String[] tagsToParseforAnnot = XpAnnotationManager.getNeededTags(modality, strImageType);
        String[] modalityTagsString = CvUtils.getModalitySpeciforcTags(modality);
        String[] tagsToParse = null;
        Vector<String> tagVect = new Vector<String>();
        if (modalityTagsString != null && tagsToParseforAnnot != null) {
            for (i = 0; i < tagsToParseforAnnot.length; ++i) {
                if (tagVect.contains(tagsToParseforAnnot[i])) continue;
                tagVect.add(tagsToParseforAnnot[i]);
            }
            for (i = 0; i < modalityTagsString.length; ++i) {
                if (tagVect.contains(modalityTagsString[i])) continue;
                tagVect.add(modalityTagsString[i]);
            }
            tagsToParse = new String[tagVect.size()];
            for (i = 0; i < tagVect.size(); ++i) {
                tagsToParse[i] = (String)tagVect.get(i);
            }
        } else if (tagsToParseforAnnot != null) {
            tagsToParse = new String[tagsToParseforAnnot.length];
            for (i = 0; i < tagsToParseforAnnot.length; ++i) {
                tagsToParse[i] = tagsToParseforAnnot[i];
            }
        }
        if (tagsToParse != null && tagsToParse.length > 0) {
            toReturn = new DMTag[tagsToParse.length];
            for (i = 0; i < tagsToParse.length; ++i) {
                StringTokenizer st = new StringTokenizer(tagsToParse[i], ",");
                String groupStr = st.nextToken();
                String elemStr = st.nextToken();
                toReturn[i] = new DMTag(Integer.parseInt(groupStr.trim()), Integer.parseInt(elemStr.trim()));
            }
        }
        return toReturn;
    }

    private static String[] getModalitySpeciforcTags(String modaliity) {
        String modalityTags = CvPropertiesManager.getProperty("TAGS_TO_LOAD_" + modaliity.toUpperCase());
        if (modalityTags == null) {
            return null;
        }
        Vector<String> tokenVect = new Vector<String>();
        StringTokenizer token = new StringTokenizer(modalityTags, ")(");
        while (token.hasMoreElements()) {
            tokenVect.add(token.nextToken());
        }
        String[] ans = new String[tokenVect.size()];
        for (int i = 0; i < tokenVect.size(); ++i) {
            ans[i] = (String)tokenVect.get(i);
        }
        return ans;
    }

    public static Window getManagedParent(Component bounds) {
        if (CvPropertiesManager.getBoolean("USE_PEF", true)) {
            try {
                Constructor<?>[] dialogCons = Class.forName("com.ge.med.pef.wm.DialogOwner").getConstructors();
                final Method refresh = Class.forName("com.ge.med.pef.wm.DialogOwner").getMethod("refresh", null);
                refresh.setAccessible(true);
                for (Constructor<?> toInvoke : dialogCons) {
                    if (toInvoke.getParameterTypes().length != 1 || !toInvoke.getParameterTypes()[0].isAssignableFrom(JComponent.class)) continue;
                    final Window parent = (Window)toInvoke.newInstance(bounds);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                refresh.invoke((Object)parent, null);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return parent;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PEF Jar not present in the class path");
                e.printStackTrace();
            }
        }
        return SwingUtilities.windowForComponent(bounds);
    }

    public static String getPathToSave(Component parent) {
        if (System.getProperty("IMAGE_SAVE_PATH") != null) {
            return System.getProperty("IMAGE_SAVE_PATH");
        }
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new JPEGFileFilter());
        jfc.setAcceptAllFileFilterUsed(false);
        int selectedOpetion = jfc.showSaveDialog(parent);
        if (selectedOpetion == 0) {
            File saveFile = jfc.getSelectedFile();
            return saveFile.getAbsolutePath();
        }
        return null;
    }

    public static String getModality(XjDicomObject dicomObj) {
        String[] modalities;
        String modality = null;
        String supportedModalities = CvPropertiesManager.getProperty("cvf.modalities", "mr,ct,pr");
        if (supportedModalities != null && (modalities = supportedModalities.split(",")) != null && modalities.length > 0) {
            for (int i = 0; i < modalities.length; ++i) {
                modality = modalities[i].trim().toLowerCase();
                String modalityFromComposite = dicomObj.getValue(DicomUtils.Modality[0], DicomUtils.Modality[1]).toString();
                if (modalityFromComposite.trim().equalsIgnoreCase(modality)) break;
            }
        }
        return modality;
    }

    public static String getCurrentModality(Capable cap_) {
        if (cap_ == null) {
            return null;
        }
        XjVolumeCapable volCap = (XjVolumeCapable)cap_.getCapable(XjVolumeCapable.class.getName());
        if (volCap != null && volCap.getVolume() != null) {
            return (String)volCap.getVolume().getValue(CvUtils.mod.group, CvUtils.mod.element);
        }
        FrameOwner focap = (FrameOwner)((Object)cap_.getCapable(FrameOwner.class.getName()));
        if (focap != null && focap.getFrame() instanceof XpDicomObject) {
            ((XpDicomObject)((Object)focap.getFrame())).getValue(mod);
            if (mod != null) {
                return mod.getStringValue();
            }
        }
        return null;
    }

    public static boolean isPluginLoad() {
        return CvPropertiesManager.getBoolean("cvf.loadplugins", false);
    }

    public static boolean isCinePlaying(Capable capable) {
        if (capable != null) {
            CineCapable ccap = (CineCapable)capable.getCapable(CineCapable.class.getName());
            XpCineCapable xpccap = (XpCineCapable)capable.getCapable(XpCineCapable.class.getName());
            if (ccap != null && ccap.getCine()) {
                return xpccap == null || !xpccap.isPaused();
            }
        }
        return false;
    }

    public static String getModality(DicomComposite refComposite) {
        String[] modalities;
        String modality = null;
        String supportedModalities = CvPropertiesManager.getProperty("cvf.modalities", "mr,ct,pr");
        if (supportedModalities != null && (modalities = supportedModalities.split(",")) != null && modalities.length > 0) {
            for (int i = 0; i < modalities.length; ++i) {
                modality = modalities[i].trim().toLowerCase();
                DMTag tag2 = new DMTag(DicomUtils.Modality[0], DicomUtils.Modality[1]);
                String modalityFromComposite = (String)refComposite.getValue(tag2);
                if (modalityFromComposite != null && modalityFromComposite.trim().equalsIgnoreCase(modality)) break;
            }
        }
        return modality;
    }

    public static void delete(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                CvUtils.delete(file);
            }
        }
        dir.delete();
    }

    public static Object create(String typeName, Class[] paramtype, Object[] args) {
        Object obj = null;
        Class cl = CvUtils.getClass(typeName);
        if (cl != null) {
            try {
                Constructor c = cl.getConstructor(paramtype);
                if (c != null) {
                    obj = c.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            logger.log(Level.INFO, "CvUtils.create() :: Error looking implementation " + typeName);
        }
        return obj;
    }

    public static Class getClass(String className) {
        try {
            Class<?> c = Class.forName(className);
            if (c != null) {
                return c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static DicomPrintable getDicomPrintable(JComponent comp) {
        DicomPrintable dicomPrintable_ = null;
        String dicomPrintableClass = CvPropertiesManager.getProperty("cvf.dicomPrintable.class", "com.ge.med.cse.cvf.util.DicomPrintablePort");
        if (dicomPrintableClass != null) {
            dicomPrintable_ = (DicomPrintable)CvUtils.create(dicomPrintableClass, new Class[]{JComponent.class}, new Object[]{comp});
            logger.log(Level.FINE, "Created DicomPrintable for class {0}", dicomPrintableClass);
        } else {
            logger.log(Level.INFO, "No DicomPrintable class found");
        }
        return dicomPrintable_;
    }

    public static boolean isFilmPrintingInProgress(DocPrintJob job) {
        PrintJobAttributeSet attributes = job.getAttributes();
        return attributes != null && attributes.get(PrintProgress.class) != null;
    }

    public static double getTimeInSeconds(long ms) {
        double timeInSec = 0.0;
        try {
            timeInSec = (double)ms / 1000.0;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, " Error while converting elapsed Time in to Seconds for :" + ms + "; error message:" + e.getMessage());
        }
        return timeInSec;
    }

    public static final void setT3DRenderStyle(T3DRenderStyleCapable t3dRndrCap, String rStyle) {
        if (t3dRndrCap == null) {
            return;
        }
        if (rStyle == null || rStyle.length() == 0) {
            return;
        }
        int rStyleInterpolation = Integer.parseInt(CvPropertiesManager.getProperty("cvf.3d.defaultRenderingQuality", "2"));
        if (rStyleInterpolation == 1) {
            if (rStyle.equalsIgnoreCase("MAJOR_AXIS_AVERAGE")) {
                rStyle = "AVERAGE";
            } else if (rStyle.equalsIgnoreCase("MAJOR_AXIS_MIP")) {
                rStyle = "MIP";
            } else if (rStyle.equalsIgnoreCase("MAJOR_AXIS_MINIP")) {
                rStyle = "MINIP";
            } else if (rStyle.equalsIgnoreCase("REFORMAT.TC")) {
                rStyle = "REFORMAT";
            }
        }
        t3dRndrCap.setRenderStyle(rStyle);
    }

    public static final String getT3DRenderStyle(String rStyle) {
        if (rStyle == null || rStyle.length() == 0) {
            return "";
        }
        int rStyleInterpolation = Integer.parseInt(CvPropertiesManager.getProperty("cvf.3d.defaultRenderingQuality", "2"));
        if (rStyleInterpolation == 1) {
            if (rStyle.equalsIgnoreCase("MAJOR_AXIS_AVERAGE")) {
                rStyle = "AVERAGE";
            } else if (rStyle.equalsIgnoreCase("MAJOR_AXIS_MIP")) {
                rStyle = "MIP";
            } else if (rStyle.equalsIgnoreCase("MAJOR_AXIS_MINIP")) {
                rStyle = "MINIP";
            } else if (rStyle.equalsIgnoreCase("REFORMAT.TC")) {
                rStyle = "REFORMAT";
            }
        }
        return rStyle;
    }

    static {
        sortMap.put("Image Number, ^", new Integer(1));
        sortMap.put("Image Number, v", new Integer(-1));
        sortMap.put("Location", new Integer(4));
        sortMap.put("Echo", new Integer(5));
        sortMap.put("Trigger", new Integer(6));
        sortMap.put(new Integer(1), "Image Number, ^");
        sortMap.put(new Integer(-1), "Image Number, v");
        sortMap.put(new Integer(4), "Location");
        sortMap.put(new Integer(5), "Echo");
        sortMap.put(new Integer(6), "Trigger");
        sortMap.put(SORT_BY_IMAGE_NUMBER, "Image Number, ^");
        sortMap.put("image_number, v", "Image Number, v");
        sortMap.put(SORT_BY_IMAGE_LOCATION, "Location");
        sortMap.put(SORT_BY_ECHO, "Echo");
        sortMap.put(SORT_BY_TRIGGER, "Trigger");
        largeSeries = Integer.parseInt(CvPropertiesManager.getProperty("cvf.largeSeries", "6000"));
        pixSpaceEl = new XpDicomElement(40, 48);
        pixSpaceTag = new DMTag(40, 48);
        seuid = new XpDicomElement(32, 14);
        seuidtag = new DMTag(32, 14);
        imguid = new XpDicomElement(8, 24);
        imguidtag = new DMTag(8, 24);
        calibrationMap = new Hashtable<String, Map<String, Double>>();
        mod = new XpDicomElement(8, 96);
    }

    private static class JPEGFileFilter
    extends FileFilter {
        private JPEGFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".jpeg") | filename.endsWith(".jpg") || file.isDirectory() || filename.endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "*.jpeg , *.png";
        }
    }

    public static enum RoiHandleStyle {
        EMPTYBOX,
        FILLEDBOX,
        CROSSHAIR;

    }

    public static enum Direction {
        EAST,
        SOUTH,
        WEST,
        NORTH,
        SOUTHEAST,
        SOUTHWEST,
        NORTHWEST,
        NORTHEAST,
        CENTRE;

    }
}

