/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.idc;

import com.ge.med.idc.XJTMailer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class XjLoader {
    private static boolean init = true;

    public static void initialize() {
        if (init) {
            boolean headless = true;
            try {
                Method method = Class.forName("java.awt.GraphicsEnvironment").getMethod("isHeadless", null);
                headless = (Boolean)method.invoke(null, (Object[])null);
            }
            catch (Exception ex) {
                System.err.println("Unable to determine graphics environment: " + ex);
            }
        }
        init = false;
    }

    private static String tab(String s) {
        int l = s.length() / 8;
        String tabs = "\t\t\t";
        if ("\t\t\t".length() > l) {
            return s + "\t\t\t".substring(l);
        }
        return s + "\t";
    }

    public static String getLineSeparator() {
        String sep;
        try {
            sep = System.getProperty("line.separator");
        }
        catch (Exception ex) {
            sep = "\n";
        }
        return sep;
    }

    public static String dumpSystemInfo() {
        String LINE_SEPARATOR = XjLoader.getLineSeparator();
        StringBuffer buffer = new StringBuffer(1024);
        try {
            Properties p = System.getProperties();
            Object[] keys = new String[p.size()];
            Enumeration<Object> e = p.keys();
            String[] remove = new String[]{"java.class.path", "file.separator", "java.library.path", "java.specification.name", "java.specification.vendor", "line.separator", "sun.boot.class.path"};
            HashSet<String> rset = new HashSet<String>(Arrays.asList(remove));
            int i = 0;
            while (e.hasMoreElements()) {
                keys[i++] = (String)e.nextElement();
            }
            Arrays.sort(keys);
            for (int j = 0; j < keys.length; ++j) {
                if (rset.contains(keys[j])) continue;
                String value = (String)p.get(keys[j]);
                buffer.append(XjLoader.tab((String)keys[j]) + " = \"" + value + "\"" + LINE_SEPARATOR);
            }
            Runtime r = Runtime.getRuntime();
            int ncpu = r.availableProcessors();
            buffer.append(XjLoader.tab("Number Of cores") + " = " + ncpu + LINE_SEPARATOR);
            long free = r.freeMemory();
            buffer.append(XjLoader.tab("freeMemory") + " = " + (float)(free / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            long max = r.maxMemory();
            buffer.append(XjLoader.tab("maxMemory") + " = " + (float)(max / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            InetAddress ip = InetAddress.getLocalHost();
            buffer.append(XjLoader.tab("HostName") + " = " + ip.getCanonicalHostName() + LINE_SEPARATOR);
            buffer.append(XjLoader.tab("HostAddress") + " = " + ip.getHostAddress() + LINE_SEPARATOR);
            buffer.append(XjLoader.tab("Creation Time") + " = " + new Date(XjLoader.getCreationTime()) + LINE_SEPARATOR);
        }
        catch (Exception ex) {
            System.err.println("Error while dumping system information: ");
            ex.printStackTrace();
        }
        return buffer.toString();
    }

    public static long getCreationTime() {
        String subFile = XjLoader.class.getName().replace('.', File.separatorChar) + ".class";
        String s = System.getProperty("java.class.path");
        String[] sp = s.split(File.pathSeparator);
        for (int i = 0; i < sp.length; ++i) {
            File f = new File(sp[i]);
            if (f.isDirectory()) {
                File path = new File(f, subFile);
                if (!path.exists()) continue;
                return path.lastModified();
            }
            try {
                JarFile zf = new JarFile(f);
                ZipEntry ze = zf.getEntry(XjLoader.class.getName().replace('.', '/') + ".class");
                zf.close();
                if (null == ze) continue;
                long time = ze.getTime();
                return time;
            }
            catch (IOException ioex) {
                System.err.println("Unable to load JAR file " + f.getAbsolutePath() + ": ");
                ioex.printStackTrace();
            }
        }
        return -1L;
    }

    private static class RegisterPanel
    extends JPanel {
        private static final int TWIDTH = 128;
        private RenderedImage bimg = null;
        private JLabel msglabel = new JLabel();
        private JTextField nametf = new JTextField();
        private JTextField emailtf = new JTextField();
        private JTextField prjtf = new JTextField();
        private JTextField orgtf = new JTextField();

        public RegisterPanel(final File regfile, final JDialog dialog, RenderedImage bimg, final String emails) {
            this.bimg = bimg;
            this.setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            JPanel regPanel = new JPanel();
            JButton submitButton = new JButton("Submit");
            buttonPanel.add(submitButton);
            buttonPanel.setOpaque(false);
            regPanel.setOpaque(false);
            this.add((Component)buttonPanel, "South");
            this.add((Component)regPanel, "West");
            JPanel toppanel = new JPanel();
            JPanel pad1 = new JPanel();
            pad1.setOpaque(false);
            toppanel.setOpaque(false);
            pad1.setPreferredSize(new Dimension(266, 64));
            toppanel.setLayout(new BorderLayout());
            toppanel.add((Component)pad1, "Center");
            toppanel.add((Component)new JLabel("      XJT Registration Form"), "South");
            JPanel pad2 = new JPanel();
            pad2.setOpaque(false);
            pad2.setPreferredSize(new Dimension(266, 64));
            regPanel.setPreferredSize(new Dimension(266, 256));
            regPanel.setLayout(new BorderLayout());
            regPanel.add((Component)toppanel, "North");
            JPanel textpanel = new JPanel();
            textpanel.setOpaque(false);
            JPanel textfieldpanel = new JPanel();
            textfieldpanel.setOpaque(false);
            regPanel.add((Component)textpanel, "West");
            regPanel.add((Component)textfieldpanel, "East");
            regPanel.add((Component)pad2, "South");
            pad2.add(this.msglabel);
            textpanel.setPreferredSize(new Dimension(128, 128));
            textfieldpanel.setPreferredSize(new Dimension(128, 128));
            JLabel namelabel = new JLabel("Name:");
            JLabel emaillabel = new JLabel("Email:");
            JLabel projectlabel = new JLabel("Project:");
            JLabel orglabel = new JLabel("Organization:");
            namelabel.setPreferredSize(new Dimension(83, 24));
            orglabel.setPreferredSize(new Dimension(83, 24));
            projectlabel.setPreferredSize(new Dimension(83, 24));
            emaillabel.setPreferredSize(new Dimension(83, 24));
            this.nametf.setPreferredSize(new Dimension(128, 24));
            this.orgtf.setPreferredSize(new Dimension(128, 24));
            this.prjtf.setPreferredSize(new Dimension(128, 24));
            this.emailtf.setPreferredSize(new Dimension(128, 24));
            textpanel.add(namelabel);
            textpanel.add(emaillabel);
            textpanel.add(projectlabel);
            textpanel.add(orglabel);
            textfieldpanel.add(this.nametf);
            textfieldpanel.add(this.emailtf);
            textfieldpanel.add(this.prjtf);
            textfieldpanel.add(this.orgtf);
            this.nametf.setToolTipText("Your name (Mandatory)");
            this.emailtf.setToolTipText("Your email address");
            this.prjtf.setToolTipText("The project for which you are using XJT");
            this.orgtf.setToolTipText("Your organization/company name");
            submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            String name = nametf.getText();
                            String org = orgtf.getText();
                            String email = emailtf.getText();
                            String project = prjtf.getText();
                            if (name.length() > 0) {
                                try {
                                    FileOutputStream fos = new FileOutputStream(regfile);
                                    PrintStream ps = new PrintStream(fos);
                                    ps.println("# XJT Registration information");
                                    ps.println("xjtuser.name=" + name);
                                    ps.println("xjtuser.organization=" + org);
                                    ps.println("xjtuser.email=" + email);
                                    ps.println("xjtuser.project=" + project);
                                    ps.close();
                                    fos.close();
                                }
                                catch (FileNotFoundException e1) {
                                    e1.printStackTrace();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                if (dialog != null) {
                                    dialog.setVisible(false);
                                    dialog.dispose();
                                }
                                XJTMailer mailer = new XJTMailer("amermsx.med.ge.com", 25, "notifier@xjt.ge.com");
                                String text = " User: " + name + "\n email: " + email + "\n Organization: " + org + "\n Project: " + project;
                                text = text + "\n---------------------------\n" + XjLoader.dumpSystemInfo();
                                try {
                                    StringTokenizer st = new StringTokenizer(emails, ",");
                                    while (st.hasMoreTokens()) {
                                        String toemail = st.nextToken().trim();
                                        mailer.send(toemail, "New XJT User: " + name, text);
                                    }
                                }
                                catch (UnknownHostException unknownHostException) {
                                }
                                catch (IOException iOException) {}
                            } else {
                                msglabel.setText("Please enter your name...");
                            }
                        }
                    };
                    t.setName("XJT_MailHome");
                    t.setDaemon(true);
                    t.start();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.bimg != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawRenderedImage(this.bimg, null);
            }
        }
    }

    private static class RegisterDialog {
        public RegisterDialog(String splash, File regfile, String emails) throws IOException {
            try {
                InputStream imgis = XjLoader.class.getResourceAsStream(splash);
                BufferedImage img = ImageIO.read(imgis);
                JDialog dialog = new JDialog();
                dialog.setAlwaysOnTop(true);
                RegisterPanel regp = new RegisterPanel(regfile, dialog, img, emails);
                dialog.setUndecorated(true);
                dialog.setContentPane(regp);
                regp.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
                dialog.pack();
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation((d.width >> 1) - (img.getWidth() >> 1), (d.height >> 1) - (img.getHeight() >> 1));
                dialog.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

