/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.Jama.EigenvalueDecomposition;
import com.ge.med.jnu.Jama.LUDecomposition;
import com.ge.med.jnu.Jama.Matrix;
import com.ge.med.jnu.JnEigenvalueDecomposition;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector;
import java.io.PrintStream;
import java.util.Arrays;

public class JnMatrix {
    public double[] data = null;
    public int rows = 0;
    public int cols = 0;

    public JnMatrix(int r, int c) {
        this.initData(r, c);
    }

    public JnMatrix(int r, int c, double val) {
        this(r, c);
        Arrays.fill(this.data, val);
    }

    public JnMatrix(double[] data, int nrows) {
        int cols = data.length / nrows;
        this.initData(nrows, cols);
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public JnMatrix(JnMatrix m) {
        this.initData(m.rows, m.cols);
        System.arraycopy(m.data, 0, this.data, 0, this.data.length);
    }

    private final void initData(int r, int c) {
        this.data = new double[r * c];
        this.rows = r;
        this.cols = c;
    }

    public final boolean set(double[] data) {
        if (this.data.length != data.length) {
            return false;
        }
        System.arraycopy(data, 0, this.data, 0, data.length);
        return true;
    }

    public final int getNumRow() {
        return this.rows;
    }

    public final int getNumCol() {
        return this.cols;
    }

    public final int getNumElements() {
        return this.data.length;
    }

    public final boolean getData(double[] data) {
        int len = this.getNumElements();
        if (len > data.length) {
            return false;
        }
        System.arraycopy(this.data, 0, data, 0, data.length);
        return true;
    }

    public final void setIdentity() {
        this.setScale(1.0);
    }

    public final void setScale(double scale) {
        this.setZero();
        for (int i = 0; i < this.rows; ++i) {
            this.data[i * this.cols + i] = scale;
        }
    }

    public final void setZero() {
        Arrays.fill(this.data, 0.0);
    }

    public final void mul(double scalar) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = scalar * this.data[i];
        }
    }

    public final void mul(double scalar, JnMatrix m) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = scalar * m.data[i];
        }
    }

    public final void mul(JnMatrix m1) {
        Matrix M1 = JnMatrix.getJamaMatrix(this);
        Matrix M2 = JnMatrix.getJamaMatrix(m1);
        Matrix p = M1.times(M2);
        JnMatrix.setJamaMatrix(this, p);
    }

    public final void mul(JnMatrix m1, JnMatrix m2) {
        Matrix M1 = JnMatrix.getJamaMatrix(m1);
        Matrix M2 = JnMatrix.getJamaMatrix(m2);
        Matrix p = M1.times(M2);
        JnMatrix.setJamaMatrix(this, p);
    }

    public final boolean isIdentity() {
        for (int i = 0; i < this.rows; ++i) {
            int offset = i * this.cols;
            for (int j = 0; j < this.cols; ++j) {
                double d = this.data[offset + j];
                if (!(i == j ? !JnUtils.one(d) : !JnUtils.zero(d))) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        JnMatrix m = (JnMatrix)o;
        for (int i = 0; i < this.data.length; ++i) {
            double val = Math.abs(this.data[i] - m.data[i]);
            if (JnUtils.zero(val)) continue;
            return false;
        }
        return true;
    }

    public final void negate() {
        this.mul(-1.0);
    }

    public final double determinant() {
        Matrix m = JnMatrix.getJamaMatrix(this);
        double ans = m.det();
        return ans;
    }

    public final void invert() {
        Matrix m = JnMatrix.getJamaMatrix(this);
        Matrix inv = m.inverse();
        JnMatrix.setJamaMatrix(this, inv);
    }

    public final void invert(JnMatrix m1) {
        Matrix m = JnMatrix.getJamaMatrix(m1);
        Matrix inv = m.inverse();
        JnMatrix.setJamaMatrix(this, inv);
    }

    public final JnMatrix transpose() {
        JnMatrix t = new JnMatrix(this.cols, this.rows);
        int index = 0;
        for (int j = 0; j < this.rows; ++j) {
            int i = 0;
            while (i < this.cols) {
                t.data[i * this.rows + j] = this.data[index];
                ++i;
                ++index;
            }
        }
        return t;
    }

    public final boolean LUDSolve(JnVector b, JnVector x) {
        Matrix M = JnMatrix.getJamaMatrix(this);
        Matrix B = JnMatrix.getJamaMatrix(b);
        LUDecomposition lud = M.lu();
        Matrix X = M.solve(B);
        JnMatrix.setJamaMatrix(x, X);
        return true;
    }

    private static final Matrix getJamaMatrix(JnMatrix M) {
        Matrix m = new Matrix(M.rows, M.cols);
        for (int i = 0; i < M.rows; ++i) {
            int offset = i * M.cols;
            for (int j = 0; j < M.cols; ++j) {
                m.set(i, j, M.data[offset + j]);
            }
        }
        return m;
    }

    public final boolean transform(JnVector t, JnVector res) {
        if (t.data.length != res.data.length) {
            return false;
        }
        if (t.data.length != this.rows) {
            return false;
        }
        for (int i = 0; i < this.rows; ++i) {
            int offset = i * this.cols;
            res.data[i] = 0.0;
            for (int j = 0; j < this.cols; ++j) {
                int n = i;
                res.data[n] = res.data[n] + this.data[offset + j] * t.data[j];
            }
        }
        return true;
    }

    public final double trace() {
        Matrix m = JnMatrix.getJamaMatrix(this);
        return m.trace();
    }

    public final JnEigenvalueDecomposition getEigenValueDecomposition() {
        Matrix m = JnMatrix.getJamaMatrix(this);
        return new EValueDecomposition(m.eig());
    }

    private static final Matrix getJamaMatrix(JnVector v) {
        Matrix m = new Matrix(v.data, v.getSize());
        return m;
    }

    private static void setJamaMatrix(JnMatrix M, Matrix m) {
        double[][] d = m.getArray();
        for (int i = 0; i < M.rows; ++i) {
            int offset = i * M.cols;
            for (int j = 0; j < M.cols; ++j) {
                M.data[offset + j] = d[i][j];
            }
        }
    }

    private static void setJamaMatrix(JnVector v, Matrix m) {
        double[][] d = m.getArray();
        for (int i = 0; i < d.length; ++i) {
            v.data[i] = d[i][0];
        }
    }

    public final void print() {
        this.print(System.out);
    }

    public final void print(PrintStream ps) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                String val = JnUtils.format(this.data[i * this.cols + j]);
                ps.print(val + " ");
            }
            ps.println();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    private static class EValueDecomposition
    implements JnEigenvalueDecomposition {
        private EigenvalueDecomposition evd = null;
        private JnMatrix eigenMatrix = null;

        public EValueDecomposition(EigenvalueDecomposition evd) {
            this.evd = evd;
        }

        @Override
        public double[] getImagEigenValues() {
            return this.evd.getImagEigenvalues();
        }

        @Override
        public double[] getRealEigenValues() {
            return this.evd.getRealEigenvalues();
        }

        @Override
        public JnMatrix getEigenVectors() {
            if (this.eigenMatrix == null) {
                Matrix m = this.evd.getV();
                this.eigenMatrix = new JnMatrix(m.getRowDimension(), m.getColumnDimension());
                JnMatrix.setJamaMatrix(this.eigenMatrix, m);
            }
            return this.eigenMatrix;
        }
    }
}

