/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector3d;

public class JnQuaternion {
    public static final JnQuaternion identity = new JnQuaternion();
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 1.0;

    public JnQuaternion() {
    }

    public JnQuaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.normalize();
    }

    public final void set(JnQuaternion quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.w = quat.w;
    }

    public JnQuaternion(double[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
        this.normalize();
    }

    public JnQuaternion(double[] axis, double phi) {
        this.set(axis, phi);
    }

    public JnQuaternion(JnVector3d axis, double phi) {
        this.set(axis, phi);
    }

    public final void set(JnVector3d axis, double phi) {
        this.set(axis.x, axis.y, axis.z, phi);
    }

    public final void set(double[] axis, double phi) {
        this.set(axis[0], axis[1], axis[2], phi);
    }

    public final void set(double axisX, double axisY, double axisZ, double phi) {
        double length = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double s = Math.sin(phi / 2.0) / length;
        this.x = axisX * s;
        this.y = axisY * s;
        this.z = axisZ * s;
        this.w = Math.cos(phi / 2.0);
    }

    public final double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public final void normalize() {
        double length = this.magnitude();
        if (length == 0.0) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.w = 1.0;
        } else {
            this.x /= length;
            this.y /= length;
            this.z /= length;
            this.w /= length;
        }
    }

    public final void conjugate(JnQuaternion result) {
        result.x = -this.x;
        result.y = -this.y;
        result.z = -this.z;
        result.w = this.w;
    }

    public final JnQuaternion conjugate() {
        JnQuaternion res = new JnQuaternion();
        this.conjugate(res);
        return res;
    }

    public static JnQuaternion combine(JnQuaternion first, JnQuaternion second) {
        JnQuaternion result = new JnQuaternion();
        JnQuaternion.combine(first, second, result);
        return result;
    }

    public static void combine(JnQuaternion first, JnQuaternion second, JnQuaternion result) {
        JnQuaternion q1 = first;
        JnQuaternion q2 = second;
        double x = q1.x * q2.w + q1.y * q2.z - q1.z * q2.y + q1.w * q2.x;
        double y = -q1.x * q2.z + q1.y * q2.w + q1.z * q2.x + q1.w * q2.y;
        double z = q1.x * q2.y - q1.y * q2.x + q1.z * q2.w + q1.w * q2.z;
        double w = -q1.x * q2.x - q1.y * q2.y - q1.z * q2.z + q1.w * q2.w;
        result.x = x;
        result.y = y;
        result.z = z;
        result.w = w;
        result.normalize();
    }

    public static JnQuaternion generateFromLookat(double[] eye, double[] center, double[] up) {
        JnVector3d f = new JnVector3d(eye[0] - center[0], eye[1] - center[1], eye[2] - center[2]);
        f.normalize();
        JnVector3d upv = new JnVector3d(up);
        upv.normalize();
        JnVector3d s = JnVector3d.cross(upv, f);
        JnVector3d u = JnVector3d.cross(f, s);
        double w = Math.sqrt(1.0 + s.x + u.y + f.z) / 2.0;
        JnQuaternion result = w > 0.0 ? new JnQuaternion((f.y - u.z) / (4.0 * w), (s.z - f.x) / (4.0 * w), (u.x - s.y) / (4.0 * w), w) : new JnQuaternion(Math.sqrt((u.y + f.z) / -2.0), Math.sqrt((f.z + s.x) / -2.0), Math.sqrt((s.x + u.y) / -2.0), w);
        return result;
    }

    public static JnQuaternion generateFromLookat(JnVector3d eye, JnVector3d center, JnVector3d up) {
        JnVector3d f = new JnVector3d();
        JnVector3d up_n = new JnVector3d();
        up_n.set(up);
        up_n.normalize();
        f.sub(eye, center);
        f.normalize();
        JnVector3d s = JnVector3d.cross(up_n, f);
        JnVector3d u = JnVector3d.cross(f, s);
        double w = Math.sqrt(1.0 + s.x + u.y + f.z) / 2.0;
        JnQuaternion result = w > 0.0 ? new JnQuaternion((f.y - u.z) / (4.0 * w), (s.z - f.x) / (4.0 * w), (u.x - s.y) / (4.0 * w), w) : new JnQuaternion(Math.sqrt((u.y + f.z) / -2.0), Math.sqrt((f.z + s.x) / -2.0), Math.sqrt((s.x + u.y) / -2.0), w);
        return result;
    }

    public JnMatrix3d build3dRotationMatrix() {
        JnMatrix3d result = new JnMatrix3d();
        this.build3dRotationMatrix(result);
        return result;
    }

    public JnMatrix4d build4dRotationMatrix() {
        JnMatrix4d result = new JnMatrix4d();
        this.build4dRotationMatrix(result);
        return result;
    }

    public void build3dRotationMatrix(JnMatrix3d result) {
        result.m00 = 1.0 - 2.0 * (this.y * this.y + this.z * this.z);
        result.m01 = 2.0 * (this.x * this.y - this.z * this.w);
        result.m02 = 2.0 * (this.z * this.x + this.y * this.w);
        result.m10 = 2.0 * (this.x * this.y + this.z * this.w);
        result.m11 = 1.0 - 2.0 * (this.z * this.z + this.x * this.x);
        result.m12 = 2.0 * (this.y * this.z - this.x * this.w);
        result.m20 = 2.0 * (this.z * this.x - this.y * this.w);
        result.m21 = 2.0 * (this.y * this.z + this.x * this.w);
        result.m22 = 1.0 - 2.0 * (this.y * this.y + this.x * this.x);
    }

    public void build4dRotationMatrix(JnMatrix4d result) {
        result.m00 = 1.0 - 2.0 * (this.y * this.y + this.z * this.z);
        result.m01 = 2.0 * (this.x * this.y + this.z * this.w);
        result.m02 = 2.0 * (this.z * this.x - this.y * this.w);
        result.m10 = 2.0 * (this.x * this.y - this.z * this.w);
        result.m11 = 1.0 - 2.0 * (this.z * this.z + this.x * this.x);
        result.m12 = 2.0 * (this.y * this.z + this.x * this.w);
        result.m20 = 2.0 * (this.z * this.x + this.y * this.w);
        result.m21 = 2.0 * (this.y * this.z - this.x * this.w);
        result.m22 = 1.0 - 2.0 * (this.y * this.y + this.x * this.x);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "," + this.w + "]";
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.x);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.y);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.z);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.w);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

