/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

public class JnTupleArrayInt {
    protected int[] data = null;
    protected int capacity;
    protected int totalCapacity;
    protected int numTuples;
    protected int size;
    protected int numComponents;

    public JnTupleArrayInt() {
        this.capacity = 10;
        this.totalCapacity = 10;
        this.numComponents = 1;
        this.numTuples = 0;
        this.size = 0;
        this.data = new int[this.capacity];
    }

    public JnTupleArrayInt(int numComponents) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.capacity = 10;
        this.totalCapacity = this.capacity * this.numComponents;
        this.numTuples = 0;
        this.size = 0;
        this.data = new int[this.totalCapacity];
    }

    public JnTupleArrayInt(int numComponents, int initialCapacity) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.capacity = initialCapacity < 1 ? 1 : initialCapacity;
        this.totalCapacity = this.capacity * this.numComponents;
        this.numTuples = 0;
        this.size = 0;
        this.data = new int[this.totalCapacity];
    }

    public JnTupleArrayInt(int numComponents, int[] data, int numTuples) {
        this.numComponents = numComponents < 1 ? 1 : numComponents;
        this.totalCapacity = data.length;
        this.capacity = this.totalCapacity / this.numComponents;
        int n = this.numTuples = numTuples < 0 ? 0 : numTuples;
        if (this.numTuples > this.capacity) {
            this.numTuples = this.capacity;
        }
        this.size = this.numTuples * this.numComponents;
        this.data = data;
    }

    public Object clone() {
        JnTupleArrayInt clone = new JnTupleArrayInt(this.numComponents, this.capacity);
        clone.copy(this);
        return clone;
    }

    public void copy(JnTupleArrayInt src) {
        if (src != this && src != null) {
            if (this.data != null && this.capacity != src.getCapacity()) {
                this.data = null;
            }
            this.numComponents = src.getNumComponents();
            this.capacity = src.getCapacity();
            this.totalCapacity = this.capacity * this.numComponents;
            this.numTuples = src.getNumTuples();
            this.size = this.numTuples * this.numComponents;
            if (this.data == null) {
                this.data = new int[this.totalCapacity];
            }
            System.arraycopy(src.getData(), 0, this.data, 0, this.size);
        }
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public boolean isEmpty() {
        return this.numTuples == 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int[] get(int id, int[] tuple) {
        if (tuple == null || tuple.length < this.numComponents) {
            tuple = new int[this.numComponents];
        }
        int index = this.numComponents * id;
        int i = 0;
        while (i < this.numComponents) {
            tuple[i] = this.data[index];
            ++i;
            ++index;
        }
        return tuple;
    }

    public int getTupleIndex(int id) {
        return this.numComponents * id;
    }

    public void set(int id, int[] newData) {
        int index = this.numComponents * id;
        int i = 0;
        while (i < this.numComponents) {
            this.data[index] = newData[i];
            ++i;
            ++index;
        }
    }

    public int[] getData() {
        return this.data;
    }

    public int add(int[] tuple) {
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        int i = 0;
        while (i < this.numComponents) {
            this.data[index] = tuple[i];
            ++i;
            ++index;
        }
        return this.numTuples - 1;
    }

    public int addSingle(int x) {
        if (this.numComponents != 1) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index] = x;
        return this.numTuples - 1;
    }

    public int addDouble(int x, int y) {
        if (this.numComponents != 2) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index] = x;
        this.data[index + 1] = y;
        return this.numTuples - 1;
    }

    public int addTriple(int x, int y, int z) {
        if (this.numComponents != 3) {
            throw new UnsupportedOperationException();
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int index = this.size - this.numComponents;
        this.data[index++] = x;
        this.data[index++] = y;
        this.data[index] = z;
        return this.numTuples - 1;
    }

    public void insert(int index, int[] tuple) {
        if (index == this.numTuples) {
            this.add(tuple);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        int i = 0;
        while (i < this.numComponents) {
            this.data[dataIndex] = tuple[i];
            ++i;
            ++dataIndex;
        }
    }

    public void insertSingle(int index, int x) {
        if (this.numComponents != 1) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addSingle(x);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataShiftLength = this.numTuples - 1 - index;
        System.arraycopy(this.data, index, this.data, index + 1, dataShiftLength);
        this.data[index] = x;
    }

    public void insertDouble(int index, int x, int y) {
        if (this.numComponents != 2) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addDouble(x, y);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        this.data[dataIndex] = x;
        this.data[dataIndex + 1] = y;
    }

    public void insertTriple(int index, int x, int y, int z) {
        if (this.numComponents != 3) {
            throw new UnsupportedOperationException();
        }
        if (index == this.numTuples) {
            this.addTriple(x, y, z);
            return;
        }
        ++this.numTuples;
        this.size += this.numComponents;
        if (this.numTuples > this.capacity) {
            this.extend();
        }
        int dataIndex = index * this.numComponents;
        int dataShiftLength = (this.numTuples - 1 - index) * this.numComponents;
        System.arraycopy(this.data, dataIndex, this.data, dataIndex + this.numComponents, dataShiftLength);
        this.data[dataIndex++] = x;
        this.data[dataIndex++] = y;
        this.data[dataIndex] = z;
    }

    public void append(JnTupleArrayInt src) {
        if (src == null || src == this) {
            return;
        }
        if (this.getNumComponents() != src.getNumComponents()) {
            throw new IllegalArgumentException("Number of components did not match in append method.");
        }
        int newNumTuples = this.getNumTuples() + src.getNumTuples();
        if (newNumTuples > this.getCapacity()) {
            this.resize(newNumTuples);
        }
        System.arraycopy(src.getData(), 0, this.data, this.size, src.size);
        this.numTuples = newNumTuples;
        this.size = this.numTuples * this.numComponents;
    }

    public boolean removeLastTuple() {
        if (this.size == 0) {
            return false;
        }
        --this.numTuples;
        this.size -= this.numComponents;
        return true;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.getNumTuples()) {
            throw new IndexOutOfBoundsException();
        }
        if (index != this.getNumTuples() - 1) {
            int dataIndex = index * this.numComponents;
            System.arraycopy(this.data, dataIndex + this.numComponents, this.data, dataIndex, this.numComponents);
        }
        --this.numTuples;
        this.size -= this.numComponents;
    }

    public void squeeze() {
        this.resize(this.numTuples);
    }

    public void resize(int numTuples) {
        if (numTuples != this.capacity) {
            int newTotalCapacity = numTuples * this.numComponents;
            int[] newArray = null;
            newArray = new int[newTotalCapacity];
            if (numTuples > this.numTuples) {
                System.arraycopy(this.data, 0, newArray, 0, this.totalCapacity);
            } else {
                System.arraycopy(this.data, 0, newArray, 0, newTotalCapacity);
            }
            this.capacity = numTuples;
            this.totalCapacity = newTotalCapacity;
            this.data = newArray;
        }
    }

    public void clear() {
        this.size = 0;
        this.numTuples = 0;
    }

    protected void extend() {
        int newTotalCapacity = this.totalCapacity + this.size;
        int[] newArray = null;
        newArray = new int[newTotalCapacity];
        System.arraycopy(this.data, 0, newArray, 0, this.totalCapacity);
        this.capacity = this.numTuples + this.capacity;
        this.totalCapacity = newTotalCapacity;
        this.data = newArray;
    }
}

