/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.ParametricCurve3D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class CubicSpline
implements ParametricCurve3D {
    private static final Logger LOGGER = Logger.getLogger(CubicSpline.class.getName());
    protected List controlPoints = null;
    protected double[][][] splineCurve;
    protected double[] segLengths = null;
    protected double totalLen;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public List getControlPoints() {
        return this.controlPoints;
    }

    @Override
    public synchronized void setControlPoints(List points) {
        this.controlPoints = points;
        Iterator itr = this.controlPoints.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            LOGGER.warning("Null value in control point list. The null control point has been removed.");
            itr.remove();
        }
        this.update();
        this.pcs.firePropertyChange("CURVE_PROPERTY", null, this);
    }

    private void update() {
        this.splineCurve = null;
        this.segLengths = null;
        this.totalLen = 0.0;
        int numControlPoints = this.controlPoints.size();
        int numDimensions = ((double[])this.controlPoints.get(0)).length;
        if (numControlPoints == 1) {
            return;
        }
        double[][] ctrlPntsArray = new double[numDimensions][];
        for (int j = 0; j < numDimensions; ++j) {
            ctrlPntsArray[j] = new double[numControlPoints];
        }
        for (int i = 0; i < numControlPoints; ++i) {
            double[] controlPoint = (double[])this.controlPoints.get(i);
            for (int j = 0; j < numDimensions; ++j) {
                ctrlPntsArray[j][i] = controlPoint[j];
            }
        }
        this.splineCurve = CubicSpline.calcNaturalCubics(ctrlPntsArray);
        double delta = 0.1;
        double len1 = 0.0;
        double len2 = 10000.0;
        while (len1 - len2 < 0.01) {
            len2 = len1;
            this.segLengths = CubicSpline.curveSegmentLengths(this.splineCurve, delta /= 10.0, this.segLengths);
            len1 = CubicSpline.sum(this.segLengths);
        }
        this.totalLen = len1;
    }

    private static double sum(double[] v) {
        double ret = 0.0;
        for (int i = 0; i < v.length; ++i) {
            ret += v[i];
        }
        return ret;
    }

    @Override
    public synchronized Object clone() {
        CubicSpline copy;
        try {
            copy = (CubicSpline)super.clone();
        }
        catch (CloneNotSupportedException e) {
            copy = new CubicSpline();
        }
        copy.controlPoints = new ArrayList(this.controlPoints.size());
        Iterator itr = this.controlPoints.iterator();
        while (itr.hasNext()) {
            copy.controlPoints.add(((double[])itr.next()).clone());
        }
        copy.splineCurve = this.splineCurve;
        copy.segLengths = this.segLengths;
        copy.totalLen = this.totalLen;
        return copy;
    }

    @Override
    public void positionAt(double t, double[] ret) {
        int segIndex;
        double tWithinSeg;
        if (this.controlPoints == null || this.controlPoints.size() == 0) {
            return;
        }
        if (this.controlPoints.size() == 1) {
            double[] point = (double[])this.controlPoints.get(0);
            System.arraycopy(point, 0, ret, 0, ret.length);
            return;
        }
        if (t == 1.0) {
            tWithinSeg = 1.0;
            segIndex = this.segLengths.length - 1;
        } else {
            double tAtSegEnd;
            double dtCurrentSeg = 0.0;
            double tAtSegStart = 0.0;
            for (segIndex = 0; segIndex < this.segLengths.length && !(t < (tAtSegEnd = tAtSegStart + (dtCurrentSeg = this.segLengths[segIndex] / this.totalLen))); ++segIndex) {
                tAtSegStart = tAtSegEnd;
            }
            double dtFromSegStart = t - tAtSegStart;
            tWithinSeg = dtFromSegStart / dtCurrentSeg;
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = CubicSpline.f(this.splineCurve[i][segIndex], tWithinSeg);
        }
    }

    @Override
    public void velocityAt(double t, double[] ret) {
        int segIndex;
        double tWithinSeg;
        if (this.controlPoints.size() == 1) {
            Arrays.fill(ret, 0.0);
            return;
        }
        if (t == 1.0) {
            tWithinSeg = 1.0;
            segIndex = this.segLengths.length - 1;
        } else {
            double tAtSegEnd;
            double dtCurrentSeg = 0.0;
            double tAtSegStart = 0.0;
            for (segIndex = 0; segIndex < this.segLengths.length && !(t < (tAtSegEnd = tAtSegStart + (dtCurrentSeg = this.segLengths[segIndex] / this.totalLen))); ++segIndex) {
                tAtSegStart = tAtSegEnd;
            }
            double dtFromSegStart = t - tAtSegStart;
            tWithinSeg = dtFromSegStart / dtCurrentSeg;
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = CubicSpline.df(this.splineCurve[i][segIndex], tWithinSeg);
        }
    }

    @Override
    public double length() {
        return this.totalLen;
    }

    private static double[][][] calcNaturalCubics(double[][] v) {
        double[][][] cubics = new double[v.length][][];
        for (int i = 0; i < cubics.length; ++i) {
            cubics[i] = CubicSpline.calcNaturalCubic(v[i].length, v[i]);
        }
        return cubics;
    }

    private static double f(double[] a, double u) {
        return ((a[3] * u + a[2]) * u + a[1]) * u + a[0];
    }

    private static double df(double[] a, double u) {
        return 3.0 * a[3] * u * u + 2.0 * a[2] * u + a[1];
    }

    public static double[] curveSegmentLengths(double[][][] cubics, double delta, double[] len) {
        if (len == null) {
            len = new double[cubics[0].length];
        }
        double[] p1 = new double[cubics.length];
        double[] p2 = new double[cubics.length];
        for (int seg = 0; seg < len.length; ++seg) {
            double lenSum = 0.0;
            for (int i = 0; i < cubics.length; ++i) {
                p1[i] = CubicSpline.f(cubics[i][seg], 0.0);
            }
            for (double t = delta; t < 1.0; t += delta) {
                for (int i = 0; i < cubics.length; ++i) {
                    p2[i] = CubicSpline.f(cubics[i][seg], t);
                }
                double sum = 0.0;
                for (int i = 0; i < p2.length; ++i) {
                    double d = p2[i] - p1[i];
                    sum += d * d;
                }
                lenSum += Math.sqrt(sum);
                double[] tmpP = p2;
                p2 = p1;
                p1 = tmpP;
            }
            for (int i = 0; i < cubics.length; ++i) {
                p2[i] = CubicSpline.f(cubics[i][seg], 1.0);
            }
            double sum = 0.0;
            for (int i = 0; i < p2.length; ++i) {
                double d = p2[i] - p1[i];
                sum += d * d;
            }
            len[seg] = lenSum += Math.sqrt(sum);
        }
        return len;
    }

    private static double[][] calcNaturalCubic(int n, double[] x) {
        int i;
        int numCP = n;
        double[] gamma = new double[numCP];
        double[] delta = new double[numCP];
        double[] D = new double[numCP];
        int numSeg = n - 1;
        gamma[0] = 0.5;
        for (i = 1; i < numSeg; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[numSeg] = 1.0 / (2.0 - gamma[numSeg - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < numSeg; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[numSeg] = (3.0 * (x[numSeg] - x[numSeg - 1]) - delta[numSeg - 1]) * gamma[numSeg];
        D[numSeg] = delta[numSeg];
        for (i = numSeg - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        double[][] c = new double[numSeg][4];
        for (i = 0; i < numSeg; ++i) {
            c[i] = new double[]{x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]};
        }
        return c;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

