/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import javax.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso(value={Double.class, Float.class, Integer.class})
public abstract class JnPoint2D
implements Cloneable {
    protected JnPoint2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setLocation(double var1, double var3);

    public void setLocation(JnPoint2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        return (x1 -= x2) * x1 + (y1 -= y2) * y1;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public double distanceSq(double px, double py) {
        return (px -= this.getX()) * px + (py -= this.getY()) * py;
    }

    public double distanceSq(JnPoint2D pt) {
        double px = pt.getX() - this.getX();
        double py = pt.getY() - this.getY();
        return px * px + py * py;
    }

    public double distance(double px, double py) {
        return Math.sqrt((px -= this.getX()) * px + (py -= this.getY()) * py);
    }

    public double distance(JnPoint2D pt) {
        double px = pt.getX() - this.getX();
        double py = pt.getY() - this.getY();
        return Math.sqrt(px * px + py * py);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof JnPoint2D) {
            JnPoint2D p2d = (JnPoint2D)obj;
            return this.getX() == p2d.getX() && this.getY() == p2d.getY();
        }
        return super.equals(obj);
    }

    public static class Double
    extends JnPoint2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setLocation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "JnPoint2D.Double[" + this.x + ", " + this.y + "]";
        }

        @Override
        public void setX(double x) {
            this.x = x;
        }

        @Override
        public void setY(double y) {
            this.y = y;
        }
    }

    public static class Float
    extends JnPoint2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void setX(double x) {
            this.x = (float)x;
        }

        @Override
        public void setY(double y) {
            this.y = (float)y;
        }

        public String toString() {
            return "JnPoint2D.Float[" + this.x + ", " + this.y + "]";
        }
    }

    public static class Integer
    extends JnPoint2D {
        public int x;
        public int y;

        public Integer() {
            this(0, 0);
        }

        public Integer(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setX(double x) {
            this.x = (int)x;
        }

        @Override
        public void setY(double y) {
            this.y = (int)y;
        }

        @Override
        public void setLocation(double x, double y) {
            this.x = (int)Math.floor(x + 0.5);
            this.y = (int)Math.floor(y + 0.5);
        }

        public void setLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void translate(int dx, int dy) {
            this.x += dx;
            this.y += dy;
        }

        public String toString() {
            return "JnPoint2D.Integer[" + this.x + ", " + this.y + "]";
        }
    }
}

