/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangularShape;

public abstract class JnRectangle2D
extends JnRectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected JnRectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(JnRectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int out1;
        int out2 = this.outcode(x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = this.outcode(x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                double x = this.getX();
                if ((out1 & 4) != 0) {
                    x += this.getWidth();
                }
                y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                x1 = x;
                continue;
            }
            double y = this.getY();
            if ((out1 & 8) != 0) {
                y += this.getHeight();
            }
            x1 += (y - y1) * (x2 - x1) / (y2 - y1);
            y1 = y;
        }
        return true;
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(JnPoint2D p) {
        return this.outcode(p.getX(), p.getY());
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    @Override
    public JnRectangle2D getBounds2D() {
        return (JnRectangle2D)this.clone();
    }

    @Override
    public boolean contains(double x, double y) {
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x + w > x0 && y + h > y0 && x < x0 + this.getWidth() && y < y0 + this.getHeight();
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x >= x0 && y >= y0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight();
    }

    public void add(double newx, double newy) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(JnPoint2D pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(JnRectangle2D r) {
        double x1 = Math.min(this.getMinX(), r.getMinX());
        double x2 = Math.max(this.getMaxX(), r.getMaxX());
        double y1 = Math.min(this.getMinY(), r.getMinY());
        double y2 = Math.max(this.getMaxY(), r.getMaxY());
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        bits += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        bits += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(bits += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JnRectangle2D) {
            JnRectangle2D r2d = (JnRectangle2D)obj;
            return this.getX() == r2d.getX() && this.getY() == r2d.getY() && this.getWidth() == r2d.getWidth() && this.getHeight() == r2d.getHeight();
        }
        return false;
    }

    public static class Double
    extends JnRectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.setRect(x, y, w, h);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        @Override
        public void setRect(JnRectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        @Override
        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0.0) {
                out |= 5;
            } else if (x < this.x) {
                out |= 1;
            } else if (x > this.x + this.width) {
                out |= 4;
            }
            if (this.height <= 0.0) {
                out |= 0xA;
            } else if (y < this.y) {
                out |= 2;
            } else if (y > this.y + this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends JnRectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.setRect(x, y, w, h);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        @Override
        public void setRect(JnRectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        @Override
        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0.0f) {
                out |= 5;
            } else if (x < (double)this.x) {
                out |= 1;
            } else if (x > (double)this.x + (double)this.width) {
                out |= 4;
            }
            if (this.height <= 0.0f) {
                out |= 0xA;
            } else if (y < (double)this.y) {
                out |= 2;
            } else if (y > (double)this.y + (double)this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Integer
    extends JnRectangle2D {
        public int x;
        public int y;
        public int width;
        public int height;

        public Integer() {
        }

        public Integer(int x, int y, int w, int h) {
            this.setRect(x, y, w, h);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0 || this.height <= 0;
        }

        private static int clip(double v, boolean doceil) {
            if (v <= -2.147483648E9) {
                return java.lang.Integer.MIN_VALUE;
            }
            if (v >= 2.147483647E9) {
                return java.lang.Integer.MAX_VALUE;
            }
            return (int)(doceil ? Math.ceil(v) : Math.floor(v));
        }

        public void setRect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setBounds(int x, int y, int w, int h) {
            this.setRect(x, y, w, h);
        }

        public void setBounds(Integer jnr2di) {
            this.setRect(jnr2di);
        }

        @Override
        public void setRect(double x, double y, double w, double h) {
            this.x = (int)x;
            this.y = (int)y;
            this.width = (int)w;
            this.height = (int)h;
        }

        @Override
        public void setRect(JnRectangle2D r) {
            this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        @Override
        public int outcode(double x, double y) {
            int out = 0;
            if (this.width <= 0) {
                out |= 5;
            } else if (x < (double)this.x) {
                out |= 1;
            } else if (x > (double)this.x + (double)this.width) {
                out |= 4;
            }
            if (this.height <= 0) {
                out |= 0xA;
            } else if (y < (double)this.y) {
                out |= 2;
            } else if (y > (double)this.y + (double)this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Integer(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

