/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.jnu.geom.JnRectangle2D;
import com.ge.med.jnu.geom.JnShape;

public abstract class JnRectangularShape
implements JnShape,
Cloneable {
    protected JnRectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public JnRectangle2D getFrame() {
        return new JnRectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(double var1, double var3, double var5, double var7);

    public void setFrame(JnRectangle2D r) {
        this.setFrame(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(JnPoint2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public JnRectangle getBounds() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new JnRectangle();
        }
        double x = this.getX();
        double y = this.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new JnRectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

