/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;

public class JnSegment {
    JnVector3d m_p1 = new JnVector3d();
    JnVector3d m_p2 = new JnVector3d();
    JnVector3d m_delta = new JnVector3d();
    JnVector3d m_p1_pt = new JnVector3d();
    JnVector3d m_cross1 = new JnVector3d();
    float m_dx = 0.0f;
    float m_dy = 0.0f;
    float m_dz = 0.0f;
    float m_p1d = 0.0f;
    float m_p12p2 = 0.0f;
    float m_a2 = 0.0f;
    float m_b2 = 0.0f;
    float m_c2 = 0.0f;
    float m_sqrtabc = 0.0f;

    public void setEndPoints(JnVector3d p1, JnVector3d p2) {
        this.m_p1 = p1;
        this.m_p2 = p2;
        this.init();
    }

    public float distance(JnVector3d p) {
        float planeDistance = this.capDistance(p);
        float len = 0.0f;
        if (planeDistance >= 0.0f && planeDistance <= this.m_p12p2) {
            this.m_p1_pt.set(this.m_p1);
            this.m_p1_pt.sub(p);
            JnVector3d.cross(this.m_delta, this.m_p1_pt, this.m_cross1);
            float num = (float)this.m_cross1.length();
            len = num / this.m_p12p2;
        } else {
            len = planeDistance < 0.0f ? (float)p.distance(this.m_p1) : (float)p.distance(this.m_p2);
        }
        return len;
    }

    private void init() {
        this.m_delta.set(this.m_p2);
        this.m_delta.sub(this.m_p1);
        this.m_p1d = (float)(-this.m_delta.dot(this.m_p1));
        this.m_a2 = (float)(this.m_delta.x * this.m_delta.x);
        this.m_b2 = (float)(this.m_delta.y * this.m_delta.y);
        this.m_c2 = (float)(this.m_delta.z * this.m_delta.z);
        this.m_sqrtabc = (float)Math.sqrt(this.m_a2 + this.m_b2 + this.m_c2);
        this.m_p12p2 = this.capDistance(this.m_p2);
    }

    float capDistance(JnVector3d p) {
        float dist = (float)((this.m_delta.dot(p) + (double)this.m_p1d) / (double)this.m_sqrtabc);
        return dist;
    }

    public JnVector3d getEnd1() {
        return this.m_p1;
    }

    public JnVector3d getEnd2() {
        return this.m_p2;
    }

    public static void main(String[] argv) {
        JnSegment segy = new JnSegment();
        segy.setEndPoints(new JnVector3d(0.0, 15.0, 0.0), new JnVector3d(0.0, 20.0, 0.0));
        JnVector3d pt1 = new JnVector3d(1.0, 10.0, 0.0);
        float d = segy.distance(pt1);
        System.out.println("Distance1:" + d);
        JnVector3d pt2 = new JnVector3d(5.0, 17.0, 0.0);
        d = segy.distance(pt2);
        System.out.println("Distance2:" + d);
        JnVector3d pt3 = new JnVector3d(-2.0, 25.0, 0.0);
        d = segy.distance(pt3);
        System.out.println("Distance3:" + d);
        JnSegment segz = new JnSegment();
        segz.setEndPoints(new JnVector3d(0.0, 0.0, 15.0), new JnVector3d(0.0, 0.0, 20.0));
        pt1.set(0.0, 1.0, 10.0);
        pt2.set(0.0, 5.0, 17.0);
        pt3.set(0.0, -2.0, 25.0);
        d = segz.distance(pt1);
        System.out.println("Distancez1:" + d);
        d = segz.distance(pt2);
        System.out.println("Distancez2:" + d);
        d = segz.distance(pt3);
        System.out.println("Distancez3:" + d);
    }
}

