/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.wl;

import com.ge.med.jnu.wl.Legall53WaveletBase;
import java.awt.Rectangle;

public class Legall53Wavelet
extends Legall53WaveletBase {
    public static void inverse(short[] data, int w, int h, int nlevels) {
        Legall53Wavelet.inverse(data, w, h, 0, 0, w, h, nlevels);
    }

    public static void inverse(short[] data, int width, int height, int x, int y, int w, int h, int nlevels) {
        Rectangle r = new Rectangle();
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        Legall53Wavelet.waveletTreeReconstruction(data, width, height, r, x, y, 0, nlevels);
    }

    public static void inverse(int[] data, int w, int h, int nlevels) {
        Rectangle r = new Rectangle();
        r.x = 0;
        r.y = 0;
        r.width = w;
        r.height = h;
        Legall53Wavelet.waveletTreeReconstruction(data, w, h, r, 0, 0, 0, nlevels);
    }

    private static void waveletTreeReconstruction(int[] img, int width, int height, Rectangle sb, int d_ulcx, int d_ulcy, int level, int nlevels) {
        if (level != nlevels) {
            Rectangle ll = new Rectangle();
            Rectangle hl = new Rectangle();
            Rectangle lh = new Rectangle();
            Rectangle hh = new Rectangle();
            int ll_ulcx = d_ulcx + 1 >> 1;
            int ll_ulcy = d_ulcy + 1 >> 1;
            int hl_ulcx = d_ulcx >> 1;
            int hl_ulcy = ll_ulcy;
            int lh_ulcx = ll_ulcx;
            int lh_ulcy = d_ulcy >> 1;
            int hh_ulcx = hl_ulcx;
            int hh_ulcy = lh_ulcy;
            ll.x = sb.x;
            ll.y = sb.y;
            ll.width = (d_ulcx + sb.width + 1 >> 1) - (d_ulcx + 1 >> 1);
            ll.height = (d_ulcy + sb.height + 1 >> 1) - (d_ulcy + 1 >> 1);
            hl.x = sb.x + ll.width;
            hl.y = sb.y;
            hl.width = (d_ulcx + sb.width >> 1) - (d_ulcx >> 1);
            hl.height = ll.height;
            lh.x = sb.x;
            lh.y = sb.y + ll.height;
            lh.width = ll.width;
            lh.height = (d_ulcy + sb.height >> 1) - (d_ulcy >> 1);
            hh.x = hl.x;
            hh.y = lh.y;
            hh.width = hl.width;
            hh.height = lh.height;
            Legall53Wavelet.waveletTreeReconstruction(img, width, height, ll, ll_ulcx, ll_ulcy, level + 1, nlevels);
            if (level >= 0) {
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hl, hl_ulcx, hl_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, lh, lh_ulcx, lh_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hh, hh_ulcx, hh_ulcy, level + 1, nlevels);
                Legall53Wavelet.wavelet2DReconstruction(img, width, height, sb, d_ulcx, d_ulcy);
            }
        }
    }

    private static void waveletTreeReconstruction(short[] img, int width, int height, Rectangle sb, int d_ulcx, int d_ulcy, int level, int nlevels) {
        if (level != nlevels) {
            Rectangle ll = new Rectangle();
            Rectangle hl = new Rectangle();
            Rectangle lh = new Rectangle();
            Rectangle hh = new Rectangle();
            int ll_ulcx = d_ulcx + 1 >> 1;
            int ll_ulcy = d_ulcy + 1 >> 1;
            int hl_ulcx = d_ulcx >> 1;
            int hl_ulcy = ll_ulcy;
            int lh_ulcx = ll_ulcx;
            int lh_ulcy = d_ulcy >> 1;
            int hh_ulcx = hl_ulcx;
            int hh_ulcy = lh_ulcy;
            ll.x = sb.x;
            ll.y = sb.y;
            ll.width = (d_ulcx + sb.width + 1 >> 1) - (d_ulcx + 1 >> 1);
            ll.height = (d_ulcy + sb.height + 1 >> 1) - (d_ulcy + 1 >> 1);
            hl.x = sb.x + ll.width;
            hl.y = sb.y;
            hl.width = (d_ulcx + sb.width >> 1) - (d_ulcx >> 1);
            hl.height = ll.height;
            lh.x = sb.x;
            lh.y = sb.y + ll.height;
            lh.width = ll.width;
            lh.height = (d_ulcy + sb.height >> 1) - (d_ulcy >> 1);
            hh.x = hl.x;
            hh.y = lh.y;
            hh.width = hl.width;
            hh.height = lh.height;
            Legall53Wavelet.waveletTreeReconstruction(img, width, height, ll, ll_ulcx, ll_ulcy, level + 1, nlevels);
            if (level >= 0) {
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hl, hl_ulcx, hl_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, lh, lh_ulcx, lh_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hh, hh_ulcx, hh_ulcy, level + 1, nlevels);
                Legall53Wavelet.wavelet2DReconstruction(img, width, height, sb, d_ulcx, d_ulcy);
            }
        }
    }

    private static void wavelet2DReconstruction(int[] img, int width, int height, Rectangle sb, int sb_ulcx, int sb_ulcy) {
        int i;
        int[] data = img;
        if (sb.width == 0 || sb.height == 0) {
            return;
        }
        boolean img_ulx = false;
        boolean img_uly = false;
        int ulx = sb.x;
        int uly = sb.y;
        int w = sb.width;
        int h = sb.height;
        int[] buf = new int[w >= h ? w : h];
        int offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcx % 2 == 0) {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                Legall53Wavelet.synthetize_lpf(buf, 0, (w + 1) / 2, 1, buf, (w + 1) / 2, w / 2, 1, data, offset, 1);
                ++i;
                offset += width;
            }
        } else {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                Legall53Wavelet.synthetize_hpf(buf, 0, w / 2, 1, buf, w / 2, (w + 1) / 2, 1, data, offset, 1);
                ++i;
                offset += width;
            }
        }
        offset = (uly - 0) * width + ulx - 0;
        int[] data_int = data;
        int[] buf_int = buf;
        if (sb_ulcy % 2 == 0) {
            int j = 0;
            while (j < w) {
                i = h - 1;
                int k = offset + i * width;
                while (i >= 0) {
                    buf_int[i] = data_int[k];
                    --i;
                    k -= width;
                }
                Legall53Wavelet.synthetize_lpf(buf, 0, (h + 1) / 2, 1, buf, (h + 1) / 2, h / 2, 1, data, offset, width);
                ++j;
                ++offset;
            }
        } else {
            int j = 0;
            while (j < w) {
                i = h - 1;
                int k = offset + i * width;
                while (i >= 0) {
                    buf_int[i] = data_int[k];
                    --i;
                    k -= width;
                }
                Legall53Wavelet.synthetize_hpf(buf, 0, h / 2, 1, buf, h / 2, (h + 1) / 2, 1, data, offset, width);
                ++j;
                ++offset;
            }
        }
    }

    private static void wavelet2DReconstruction(short[] img, int width, int height, Rectangle sb, int sb_ulcx, int sb_ulcy) {
        int i;
        short[] data = img;
        if (sb.width == 0 || sb.height == 0) {
            return;
        }
        boolean img_ulx = false;
        boolean img_uly = false;
        int ulx = sb.x;
        int uly = sb.y;
        int w = sb.width;
        int h = sb.height;
        short[] buf = new short[w >= h ? w : h];
        int offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcx % 2 == 0) {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                Legall53Wavelet.synthetize_lpf(buf, 0, (w + 1) / 2, 1, buf, (w + 1) / 2, w / 2, 1, data, offset, 1);
                ++i;
                offset += width;
            }
        } else {
            i = 0;
            while (i < h) {
                System.arraycopy(data, offset, buf, 0, w);
                Legall53Wavelet.synthetize_hpf(buf, 0, w / 2, 1, buf, w / 2, (w + 1) / 2, 1, data, offset, 1);
                ++i;
                offset += width;
            }
        }
        offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcy % 2 == 0) {
            int j = 0;
            while (j < w) {
                i = h - 1;
                int k = offset + i * width;
                while (i >= 0) {
                    buf[i] = data[k];
                    --i;
                    k -= width;
                }
                Legall53Wavelet.synthetize_lpf(buf, 0, (h + 1) / 2, 1, buf, (h + 1) / 2, h / 2, 1, data, offset, width);
                ++j;
                ++offset;
            }
        } else {
            int j = 0;
            while (j < w) {
                i = h - 1;
                int k = offset + i * width;
                while (i >= 0) {
                    buf[i] = data[k];
                    --i;
                    k -= width;
                }
                Legall53Wavelet.synthetize_hpf(buf, 0, h / 2, 1, buf, h / 2, (h + 1) / 2, 1, data, offset, width);
                ++j;
                ++offset;
            }
        }
    }

    public static void main(String[] args) {
        int DIM = 512;
        int[] data = new int[DIM * DIM];
        int[] gt = new int[DIM * DIM];
        for (int y = 0; y < DIM; ++y) {
            int yoffset = y * DIM;
            for (int x = 0; x < DIM; ++x) {
                int n = 6 * y + x;
                data[yoffset + x] = n;
                gt[yoffset + x] = n;
            }
        }
        Legall53Wavelet legall53 = new Legall53Wavelet();
        long t0 = System.currentTimeMillis();
        Legall53Wavelet.forward(data, DIM, DIM, 5);
        long tforward = System.currentTimeMillis() - t0;
        System.err.println(">>>> -----------------------------------------------------");
        long t1 = System.currentTimeMillis();
        Legall53Wavelet.inverse(data, DIM, DIM, 5);
        long tinverse = System.currentTimeMillis() - t1;
        int nerrors = 0;
        for (int y = 0; y < DIM; ++y) {
            int yoffset = y * DIM;
            for (int x = 0; x < DIM; ++x) {
                if (gt[yoffset + x] == data[yoffset + x]) continue;
                ++nerrors;
            }
        }
        System.err.println("--- tforward=" + tforward + "   tinverse=" + tinverse + " errors=" + nerrors);
    }
}

