/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.wl;

import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.wl.WLFilter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WL {
    private static final DecimalFormat df = new DecimalFormat("####0.00");
    public static final int WL_OK = 1;
    public static final int WL_ERROR = 0;
    private double[] temp1 = null;
    private double[] upLow = null;
    private double[] upHi = null;
    private int[] sgnpart = null;
    private double[] tempSource = null;
    private double[] tempDest = null;
    private int[] rSplit = null;
    private int[] cSplit = null;
    private double[] temp2D = null;

    public final int FwtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.FwtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    public final int FwtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int len = length + left + right;
        if (this.temp1 == null || this.temp1.length != len) {
            this.temp1 = new double[len];
        }
        if (source != dest) {
            System.arraycopy(source, offset, dest, out_offset, length);
        }
        int level = 0;
        while (level < levels) {
            int i;
            int j = 0;
            for (i = length - left; i < length; ++i) {
                this.temp1[j++] = dest[i + out_offset];
            }
            for (i = 0; i < length; ++i) {
                this.temp1[j++] = dest[i + out_offset];
            }
            for (i = 0; i < right; ++i) {
                this.temp1[j++] = dest[i + out_offset];
            }
            int lowresult = out_offset;
            int hiresult = out_offset + length / 2;
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            i = 0;
            while (i < length) {
                double lowsum = 0.0;
                double hisum = 0.0;
                for (j = 0; j < lowsize; ++j) {
                    lowsum += this.temp1[lowdata + j] * lowcoefs[j];
                }
                for (j = 0; j < hisize; ++j) {
                    hisum += this.temp1[hidata + j] * hicoefs[j];
                }
                dest[lowresult++] = lowsum;
                dest[hiresult++] = hisum;
                i += 2;
                lowdata += 2;
                hidata += 2;
            }
            ++level;
            length /= 2;
        }
        return 1;
    }

    public final int IwtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.IwtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    public final int IwtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        if (this.sgnpart == null || this.sgnpart.length != levels + 1) {
            this.sgnpart = new int[levels + 1];
        }
        int len = length + left + right;
        if (this.upLow == null || this.upHi == null || this.upLow.length != len || this.upHi.length != len) {
            this.upLow = new double[len];
            this.upHi = new double[len];
        }
        System.arraycopy(source, offset, dest, out_offset, length /= JnUtils.pow2(levels - 1));
        int level = 0;
        while (level < levels) {
            int i;
            int j = left;
            for (i = 0; i < length / 2; ++i) {
                this.upLow[j] = dest[out_offset + i];
                this.upHi[j] = source[offset + length / 2 + i];
                this.upLow[++j] = 0.0;
                this.upHi[j] = 0.0;
                ++j;
            }
            j = 0;
            i = length - left;
            while (i < length) {
                this.upLow[j] = this.upLow[left + i];
                this.upHi[j] = this.upHi[left + i];
                ++i;
                ++j;
            }
            i = 0;
            while (i < length) {
                this.upLow[j] = this.upLow[left + i];
                this.upHi[j] = this.upHi[left + i];
                ++i;
                ++j;
            }
            i = 0;
            while (i < right) {
                this.upLow[j] = this.upLow[left + i];
                this.upHi[j] = this.upHi[left + i];
                ++i;
                ++j;
            }
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            int result = 0;
            i = 0;
            while (i < length) {
                double sum = 0.0;
                for (j = 0; j < lowsize; ++j) {
                    sum += this.upLow[lowdata + j] * lowcoefs[j];
                }
                for (j = 0; j < hisize; ++j) {
                    sum += this.upHi[hidata + j] * hicoefs[j];
                }
                dest[out_offset + result++] = sum;
                ++i;
                ++lowdata;
                ++hidata;
            }
            ++level;
            length *= 2;
        }
        return 1;
    }

    protected final int FswtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.FswtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    protected int FswtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int len = length + left + right;
        if (this.temp1 == null || this.temp1.length != len) {
            this.temp1 = new double[len];
        }
        if (source != dest) {
            System.arraycopy(source, offset, dest, out_offset, length);
        }
        for (int level = 0; level < levels; ++level) {
            double lowsum;
            int i;
            int j;
            if (lowsize % 2 != 0) {
                j = 0;
                for (i = out_offset + left; i > out_offset; --i) {
                    this.temp1[j++] = dest[i];
                }
                for (i = out_offset; i < length + out_offset; ++i) {
                    this.temp1[j++] = dest[i];
                }
                for (i = out_offset + length - 2; i > out_offset + length - 2 - right; --i) {
                    this.temp1[j++] = dest[i];
                }
            } else {
                j = 0;
                for (i = out_offset + left - 1; i >= out_offset; --i) {
                    this.temp1[j++] = dest[i];
                }
                for (i = out_offset; i < out_offset + length; ++i) {
                    this.temp1[j++] = dest[i];
                }
                for (i = out_offset + length - 1; i >= out_offset + length - right; --i) {
                    this.temp1[j++] = dest[i];
                }
            }
            int lowresult = out_offset;
            int hiresult = out_offset + (length + 1) / 2;
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            for (i = 0; i < length - 1; i += 2) {
                lowsum = 0.0;
                double hisum = 0.0;
                for (j = 0; j < lowsize; ++j) {
                    lowsum += this.temp1[lowdata + j] * lowcoefs[j];
                }
                for (j = 0; j < hisize; ++j) {
                    hisum += this.temp1[hidata + j] * hicoefs[j];
                }
                dest[lowresult++] = lowsum;
                dest[hiresult++] = hisum;
                lowdata += 2;
                hidata += 2;
            }
            if (length % 2 != 0) {
                lowsum = 0.0;
                for (j = 0; j < lowsize; ++j) {
                    lowsum += this.temp1[lowdata + j] * lowcoefs[j];
                }
                dest[lowresult] = lowsum;
            }
            length = (length + 1) / 2;
        }
        return 1;
    }

    public int IswtVector(double[] source, double[] dest, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        return this.IswtVector(source, dest, 0, 0, length, levels, lowpass, hipass);
    }

    protected int IswtVector(double[] source, double[] dest, int offset, int out_offset, int length, int levels, WLFilter lowpass, WLFilter hipass) {
        int level;
        int hisize = hipass.length;
        int lowsize = lowpass.length;
        double[] hicoefs = hipass.coefs;
        double[] lowcoefs = lowpass.coefs;
        int left = Math.max(lowpass.offset, hipass.offset);
        int right = Math.max(lowpass.length - lowpass.offset - 1, hipass.length - hipass.offset - 1);
        int result = 0;
        if (this.sgnpart == null || this.sgnpart.length != levels + 1) {
            this.sgnpart = new int[levels + 1];
        }
        int len = length + left + right;
        if (this.upLow == null || this.upHi == null || this.upLow.length != len || this.upHi.length != len) {
            this.upLow = new double[len];
            this.upHi = new double[len];
        }
        int tmp = length;
        for (level = levels; level > 0; --level) {
            this.sgnpart[level] = tmp / 2;
            tmp = (tmp + 1) / 2;
        }
        this.sgnpart[0] = tmp;
        System.arraycopy(source, offset, dest, out_offset, this.sgnpart[0] + this.sgnpart[1]);
        int wBound = this.sgnpart[0];
        for (level = 0; level < levels; ++level) {
            int i;
            int j = left;
            for (i = out_offset; i < wBound + out_offset; ++i) {
                this.upLow[j] = dest[i];
                this.upLow[++j] = 0.0;
                ++j;
            }
            j = left;
            for (i = 0; i < this.sgnpart[level + 1]; ++i) {
                this.upHi[j] = source[offset + wBound + i];
                this.upHi[++j] = 0.0;
                ++j;
            }
            length = wBound + this.sgnpart[level + 1];
            if (lowsize % 2 == 1) {
                if (length % 2 == 0) {
                    j = 0;
                    for (i = 2 * left; i > left; --i) {
                        this.upLow[j++] = this.upLow[i];
                    }
                    j = left + length;
                    for (i = left + length - 2; i > left + length - 2 - right; --i) {
                        this.upLow[j++] = this.upLow[i];
                    }
                    this.upHi[left - 1] = 0.0;
                    j = 0;
                    for (i = 2 * left - 2; i >= left; --i) {
                        this.upHi[j++] = this.upHi[i];
                    }
                    j = length + left;
                    for (i = left + length - 4; i > left + length - 4 - right; --i) {
                        this.upHi[j++] = this.upHi[i];
                    }
                } else {
                    j = left - 1;
                    for (i = left + 1; i <= 2 * left; ++i) {
                        this.upLow[j--] = this.upLow[i];
                    }
                    j = length + left;
                    for (i = length + left - 2; i > left + length - 2 - right; --i) {
                        this.upLow[j++] = this.upLow[i];
                    }
                    this.upHi[left - 1] = 0.0;
                    j = left - 2;
                    for (i = left; i < 2 * left - 1; ++i) {
                        this.upHi[j--] = this.upHi[i];
                    }
                    this.upHi[length + left - 1] = this.upHi[length + left - 3];
                    j = length + left;
                    for (i = length + left - 4; i > left + length - 4 - right; --i) {
                        this.upHi[j++] = this.upHi[i];
                    }
                }
            } else if (length % 2 == 0) {
                this.upLow[left - 1] = 0.0;
                j = 0;
                for (i = 2 * left - 2; i >= left; --i) {
                    this.upLow[j++] = this.upLow[i];
                }
                j = left + length;
                for (i = left + length - 2; i > left + length - 2 - right; --i) {
                    this.upLow[j++] = this.upLow[i];
                }
                this.upHi[left - 1] = 0.0;
                j = 0;
                for (i = 2 * left - 2; i >= left; --i) {
                    this.upHi[j++] = -this.upHi[i];
                }
                j = left + length;
                for (i = left + length - 2; i > left + length - 2 - right; --i) {
                    this.upHi[j++] = -this.upHi[i];
                }
            } else {
                this.upLow[left - 1] = 0.0;
                j = left - 2;
                for (i = left; i < 2 * left - 1; ++i) {
                    this.upLow[j--] = this.upLow[i];
                }
                j = length + left;
                for (i = length + left - 2; i > left + length - 2 - right; --i) {
                    this.upLow[j++] = this.upLow[i];
                }
                this.upHi[left - 1] = 0.0;
                j = left - 2;
                for (i = left; i < 2 * left - 1; ++i) {
                    this.upHi[j--] = -this.upHi[i];
                }
                this.upHi[length + left - 1] = -this.upHi[length + left - 5];
                j = length + left;
                for (i = length + left - 6; i > left + length - 6 - right; --i) {
                    this.upHi[j++] = -this.upHi[i];
                }
            }
            int lowdata = left - lowpass.offset;
            int hidata = left - hipass.offset;
            result = out_offset;
            i = 0;
            while (i < length) {
                double sum = 0.0;
                for (j = 0; j < lowsize; ++j) {
                    sum += this.upLow[lowdata + j] * lowcoefs[j];
                }
                for (j = 0; j < hisize; ++j) {
                    sum += this.upHi[hidata + j] * hicoefs[j];
                }
                dest[result++] = sum;
                ++i;
                ++lowdata;
                ++hidata;
            }
            wBound += this.sgnpart[level + 1];
        }
        return 1;
    }

    public final int FwtMatrix(short[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int len = rows * cols;
        if (this.temp2D == null || this.temp2D.length != len) {
            this.temp2D = new double[len];
        }
        for (int i = 0; i < len; ++i) {
            this.temp2D[i] = source[i];
        }
        return this.FwtMatrix(this.temp2D, dest, rows, cols, levels, lowpass, hipass);
    }

    public final int FwtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        int mat_len = rows * cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        if (source != dest) {
            System.arraycopy(source, 0, dest, 0, mat_len);
        }
        int level = 0;
        while (level < levels) {
            int r;
            for (r = 0; r < rows; ++r) {
                if (this.FwtVector(dest, dest, r * width, r * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            for (int c = 0; c < cols; ++c) {
                for (r = 0; r < rows; ++r) {
                    this.tempSource[r] = dest[r * width + c];
                }
                if (this.FwtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r = 0; r < rows; ++r) {
                    dest[r * width + c] = this.tempDest[r];
                }
            }
            ++level;
            rows /= 2;
            cols /= 2;
        }
        return 1;
    }

    public final int IwtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
        rows /= JnUtils.pow2(levels - 1);
        cols /= JnUtils.pow2(levels - 1);
        int level = 0;
        while (level < levels) {
            int r;
            for (int c = 0; c < cols; ++c) {
                for (r = 0; r < rows; ++r) {
                    this.tempSource[r] = dest[r * width + c];
                }
                if (this.IwtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r = 0; r < rows; ++r) {
                    dest[r * width + c] = this.tempDest[r];
                }
            }
            for (r = 0; r < rows; ++r) {
                if (this.IwtVector(dest, dest, r * width, r * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            ++level;
            rows *= 2;
            cols *= 2;
        }
        return 1;
    }

    protected final int FswtMatrix(short[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int len = rows * cols;
        if (this.temp2D == null || this.temp2D.length != len) {
            this.temp2D = new double[len];
        }
        for (int i = 0; i < len; ++i) {
            this.temp2D[i] = source[i];
        }
        return this.FswtMatrix(this.temp2D, dest, rows, cols, levels, lowpass, hipass);
    }

    protected final int FswtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int width = cols;
        int mat_len = rows * cols;
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, mat_len);
        for (int level = 0; level < levels; ++level) {
            int r;
            for (r = 0; r < rows; ++r) {
                if (this.FswtVector(dest, dest, r * width, r * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
            for (int c = 0; c < cols; ++c) {
                for (r = 0; r < rows; ++r) {
                    this.tempSource[r] = dest[r * width + c];
                }
                if (this.FswtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r = 0; r < rows; ++r) {
                    dest[r * width + c] = this.tempDest[r];
                }
            }
            rows = (rows + 1) / 2;
            cols = (cols + 1) / 2;
        }
        return 1;
    }

    protected final int IswtMatrix(double[] source, double[] dest, int rows, int cols, int levels, WLFilter lowpass, WLFilter hipass) {
        int level;
        int width = cols;
        if (this.rSplit == null || this.cSplit == null || this.rSplit.length != levels + 1 || this.cSplit.length != levels + 1) {
            this.rSplit = new int[levels + 1];
            this.cSplit = new int[levels + 1];
        }
        if (this.tempSource == null || this.tempDest == null || this.tempSource.length != rows || this.tempDest.length != rows) {
            this.tempSource = new double[rows];
            this.tempDest = new double[rows];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
        int c = cols;
        int r = rows;
        for (level = levels; level > 0; --level) {
            this.rSplit[level] = r / 2;
            r = (r + 1) / 2;
            this.cSplit[level] = c / 2;
            c = (c + 1) / 2;
        }
        this.rSplit[0] = r;
        this.cSplit[0] = c;
        rows = this.rSplit[0];
        cols = this.cSplit[0];
        for (level = 1; level < levels + 1; ++level) {
            rows += this.rSplit[level];
            cols += this.cSplit[level];
            for (c = 0; c < cols; ++c) {
                for (r = 0; r < rows; ++r) {
                    this.tempSource[r] = dest[r * width + c];
                }
                if (this.IswtVector(this.tempSource, this.tempDest, rows, 1, lowpass, hipass) != 1) {
                    return 0;
                }
                for (r = 0; r < rows; ++r) {
                    dest[r * width + c] = this.tempDest[r];
                }
            }
            for (r = 0; r < rows; ++r) {
                if (this.IswtVector(dest, dest, r * width, r * width, cols, 1, lowpass, hipass) == 1) continue;
                return 0;
            }
        }
        return 1;
    }

    public static BufferedImage toLuminanceImage(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 11);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.drawImage(img, 0, 0, null);
        return bi;
    }

    public static BufferedImage toLuminanceImage(double[] raster, int w, int h) {
        int MAX = 64000;
        BufferedImage bi = new BufferedImage(w, h, 11);
        int len = raster.length;
        short[] out = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
        double min = 9.99999999E8;
        double max = -9.99999999E8;
        for (int i = 0; i < raster.length; ++i) {
            double val = Math.abs(raster[i]);
            if (min > val) {
                min = val;
            }
            if (!(max < val)) continue;
            max = val;
        }
        double range = max - min;
        for (int i = 0; i < raster.length; ++i) {
            double val = Math.abs(raster[i]);
            out[i] = (short)((double)MAX * ((val - min) / range));
        }
        return bi;
    }

    public static BufferedImage toShortImage(double[] raster, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 11);
        int len = raster.length;
        short[] out = ((DataBufferUShort)bi.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < raster.length; ++i) {
            out[i] = (short)raster[i];
        }
        return bi;
    }

    public static void showImage(Image img, String imgName) {
        WL.showImage(img, imgName, 0, 0);
    }

    public static void showImage(Image img, String imgName, int x, int y) {
        JFrame jf = new JFrame(imgName);
        ImgPanel ip = new ImgPanel(img);
        jf.setContentPane(ip);
        jf.setLocation(x, y);
        jf.pack();
        jf.setVisible(true);
    }

    private static void printSignal(double[] signal, int nelem) {
        int ELEM = 16;
        System.out.println("");
        for (int i = 0; i < nelem; ++i) {
            System.out.print(" " + df.format(signal[i]));
            if ((i + 1) % ELEM != 0) continue;
            System.out.println("");
        }
    }

    private static class ImgPanel
    extends JPanel {
        private Image img = null;

        public ImgPanel(Image img) {
            this.img = img;
            int w = img.getWidth(this);
            int h = img.getHeight(this);
            this.setPreferredSize(new Dimension(w, h));
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.img, 0, 0, null);
        }
    }
}

