/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundRectangleShapeGenerator;
import com.ge.med.ptk.shape.ShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class CuiToolPaletteBorder
implements Border {
    protected Insets insets_;
    protected ShapeGenerator shape_;
    protected EdgeProfile profile_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiToolPaletteBorder(Insets insets) {
        this(insets, new RoundRectangleShapeGenerator(new EdgeProfileRounded(CuiLookAndFeel.getInteriorEdge(), 0.0), 0.0), new EdgeProfileRounded(CuiLookAndFeel.getInteriorEdge(), 0.0));
    }

    public CuiToolPaletteBorder(Insets insets, ShapeGenerator shape, EdgeProfile profile) {
        this.insets_ = insets;
        this.shape_ = shape;
        this.profile_ = profile;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets_;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Insets insets = this.getBorderInsets(c);
        if (insets.top > 0) {
            h = insets.top;
        } else if (insets.left > 0) {
            w = insets.left;
        } else if (insets.bottom > 0) {
            y = y + h - insets.bottom;
            h = insets.bottom;
        } else if (insets.right > 0) {
            x = x + w - insets.right;
            w = insets.right;
        }
        Dimension size = new Dimension(w, h);
        Rectangle cutout = null;
        Shape shape = this.shape_.getShape(size);
        EdgeProfile profile = this.profile_;
        Color interiorColor = c.getBackground();
        Color exteriorColor = c.getParent() == null || !c.getParent().isOpaque() ? new Color(0, true) : c.getParent().getBackground();
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
        g.drawImage(renderedShape, x, y, null);
    }
}

