/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundRectangleShapeGenerator;
import com.ge.med.ptk.shape.ShapeGenerator;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class RenderedShapeBorder
implements Border {
    protected Insets insets_;
    protected ShapeGenerator shape_;
    protected EdgeProfile profile_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static void main1(String[] argv) {
        UIManager.put("ptk.lightingCoefficients", new double[]{0.0, 0.0, 1.0, 1.0, 4.0, 1.0, 1.0});
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().setLayout(new GridLayout(4, 4, 10, 10));
        if (f.getContentPane() instanceof JComponent) {
            ((JComponent)f.getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
        }
        f.getContentPane().setBackground(Color.pink);
        EdgeProfileRounded profile = new EdgeProfileRounded(20.0, 10.0);
        RoundRectangleShapeGenerator shape = new RoundRectangleShapeGenerator(profile, 15.0);
        for (int i = 0; i < 16; ++i) {
            JPanel p = new JPanel();
            p.setBorder(new RenderedShapeBorder(shape.getInsets(), shape, profile));
            p.setBackground(Color.gray);
            p.setPreferredSize(new Dimension(200, 200));
            f.getContentPane().add(p);
        }
        f.pack();
        f.setVisible(true);
    }

    public RenderedShapeBorder(Insets insets, ShapeGenerator shape, EdgeProfile profile) {
        this.insets_ = insets;
        this.shape_ = shape;
        this.profile_ = profile;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets_;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color interior = c.getBackground();
        Color exterior = c.getParent() == null || !c.getParent().isOpaque() ? new Color(0, true) : c.getParent().getBackground();
        Insets insets = this.getBorderInsets(c);
        int maxInset = Math.max(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
        Dimension size = new Dimension(Math.min(w, 3 * maxInset + 1), Math.min(h, 3 * maxInset + 1));
        Rectangle cutout = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        Shape shape = this.shape_.getShape(size);
        EdgeProfile profile = this.profile_;
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interior, exterior, cutout);
        new StretchedImageIcon(renderedShape, w, h).paintIcon(c, g, x, y);
    }
}

