/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.graphics.MathFunctions;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class HlsCuiColorSpace
extends ColorSpace {
    protected static String[] colors_ = new String[]{"P1", "P3", "P4", "P11", "P2", "P5", "P2.2", "P7", "P8", "P9", "P10", "P10.4"};
    protected static ColorSpace cuiColorSpace_ = new HlsCuiColorSpace();
    protected static ColorSpace grayColorSpace_ = ColorSpace.getInstance(1003);
    protected static ColorSpace rgbColorSpace_ = ColorSpace.getInstance(1000);
    protected static float[][] rgb_ = new float[colors_.length][];
    protected static float[][] hls_ = new float[colors_.length][];
    protected static float[] weight_ = new float[]{51.0f, 100.0f, 19.0f};

    public HlsCuiColorSpace() {
        super(8, 3);
    }

    protected static float[] fromRGBtoHSB(float[] rgbValue) {
        float hue;
        float saturation;
        float r = rgbValue[0];
        float g = rgbValue[1];
        float b = rgbValue[2];
        float maxComponent = Math.max(Math.max(r, g), b);
        float minComponent = Math.min(Math.min(r, g), b);
        float brightness = maxComponent;
        float f = saturation = maxComponent > 0.0f ? (maxComponent - minComponent) / maxComponent : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float red = (maxComponent - r) / (maxComponent - minComponent);
            float green = (maxComponent - g) / (maxComponent - minComponent);
            float blue = (maxComponent - b) / (maxComponent - minComponent);
            hue = r == maxComponent ? blue - green : (g == maxComponent ? 2.0f + red - blue : 4.0f + green - red);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue, saturation, brightness};
    }

    protected static float[] toRGBfromHSB(float[] hsbValue) {
        float hue = hsbValue[0];
        float saturation = hsbValue[1];
        float brightness = hsbValue[2];
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (saturation == 0.0f) {
            g = b = brightness;
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        return new float[]{r, g, b};
    }

    protected static float[] fromHSBtoHLS(float[] hsbValue) {
        float[] hlsValue = new float[3];
        hlsValue[0] = hsbValue[0];
        if (hsbValue[1] + hsbValue[2] <= 1.0f) {
            hlsValue[1] = hsbValue[2];
            hlsValue[2] = hsbValue[2] > 0.99f ? 0.0f : hsbValue[1] / (1.0f - hsbValue[2]) / 2.0f;
        } else {
            float x = hsbValue[2] + hsbValue[1] - 1.0f;
            float y = hsbValue[2] - hsbValue[1];
            hlsValue[1] = (y + 1.0f) / 2.0f;
            hlsValue[2] = Math.abs(y) > 0.99f ? 1.0f : Math.min(1.0f, 0.5f + x / (1.0f - Math.abs(y)) / 2.0f);
        }
        return hlsValue;
    }

    protected static float[] toHSBfromHLS(float[] hlsValue) {
        float[] hsbValue = new float[3];
        hsbValue[0] = hlsValue[0];
        if (hlsValue[2] <= 0.5f) {
            hsbValue[1] = 2.0f * hlsValue[2] * (1.0f - hlsValue[1]);
            hsbValue[2] = hlsValue[1];
        } else {
            float x = 2.0f * (hlsValue[2] - 0.5f);
            float y = 2.0f * (hlsValue[1] - 0.5f);
            hsbValue[1] = (1.0f + (x *= 1.0f - Math.abs(y)) - y) / 2.0f;
            hsbValue[2] = hsbValue[1] + y;
        }
        return hsbValue;
    }

    @Override
    public float[] fromRGB(float[] rgbValue) {
        float weightedL;
        float[] hsbValue = HlsCuiColorSpace.fromRGBtoHSB(rgbValue);
        float[] hlsValue = HlsCuiColorSpace.fromHSBtoHLS(hsbValue);
        float[] hlsHalf = new float[]{hlsValue[0], 0.5f, hlsValue[2]};
        float[] hsbHalf = HlsCuiColorSpace.toHSBfromHLS(hlsHalf);
        float[] rgbHalf = HlsCuiColorSpace.toRGBfromHSB(hsbHalf);
        float gsHalf = (51.0f * rgbHalf[0] + 100.0f * rgbHalf[1] + 19.0f * rgbHalf[1]) / 170.0f;
        hlsValue[1] = weightedL = (float)MathFunctions.smooth(0.0, 1.0, 0.5, 0.0, 1.0, gsHalf, hlsValue[1]);
        return hlsValue;
    }

    @Override
    public float[] toRGB(float[] hlsValue) {
        float[] hlsHalf = new float[]{hlsValue[0], 0.5f, hlsValue[2]};
        float[] hsbHalf = HlsCuiColorSpace.toHSBfromHLS(hlsHalf);
        float[] rgbHalf = HlsCuiColorSpace.toRGBfromHSB(hsbHalf);
        float gsHalf = (51.0f * rgbHalf[0] + 100.0f * rgbHalf[1] + 19.0f * rgbHalf[1]) / 170.0f;
        float weightedL = (float)MathFunctions.smooth(0.0, 1.0, gsHalf, 0.0, 1.0, 0.5, hlsValue[1]);
        hlsValue = new float[]{hlsValue[0], weightedL, hlsValue[2]};
        float[] hsbValue = HlsCuiColorSpace.toHSBfromHLS(hlsValue);
        float[] rgbValue = HlsCuiColorSpace.toRGBfromHSB(hsbValue);
        return rgbValue;
    }

    @Override
    public float[] fromCIEXYZ(float[] xyxValue) {
        return this.fromRGB(HlsCuiColorSpace.getInstance(1000).fromCIEXYZ(xyxValue));
    }

    @Override
    public float[] toCIEXYZ(float[] hlsValue) {
        return HlsCuiColorSpace.getInstance(1000).toCIEXYZ(this.toRGB(hlsValue));
    }

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < colors_.length; ++i) {
            Color c = UIManager.getColor(colors_[i]);
            HlsCuiColorSpace.rgb_[i] = new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f};
            HlsCuiColorSpace.hls_[i] = cuiColorSpace_.fromRGB(rgb_[i]);
            System.out.println(colors_[i] + "\t" + rgb_[i][0] + " " + rgb_[i][1] + " " + rgb_[i][2] + "\t" + (int)Math.round(100.0 * (double)hls_[i][0]) + " " + (int)Math.round(100.0 * (double)hls_[i][1]) + " " + (int)Math.round(100.0 * (double)hls_[i][2]));
        }
        int FACTOR = 2;
        float HUE = 0.63f;
        final float[] SATURATION = new float[]{0.23f, 0.5f};
        JFrame frame = new JFrame("CUI HLS");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JComponent(){

            @Override
            public void paint(Graphics g) {
                Dimension size = this.getSize();
                for (int ll = 0; ll < size.width; ++ll) {
                    for (int ss = 0; ss < size.height; ++ss) {
                        float[] xyz = new float[]{0.63f, (float)ll / (float)(size.width - 1), (float)ss / (float)(size.height - 1)};
                        Color color = new Color(cuiColorSpace_, xyz, 1.0f);
                        g.setColor(color);
                        g.fillRect(ll, ss, 1, 1);
                    }
                }
                g.setColor(Color.gray);
                g.drawLine(0, Math.round(SATURATION[0] * (float)(size.height - 2)), size.width, Math.round(SATURATION[0] * (float)(size.height - 2)));
                g.drawLine(0, Math.round(SATURATION[1] * (float)(size.height - 2)), size.width, Math.round(SATURATION[1] * (float)(size.height - 2)));
                for (int i = 0; i < hls_.length; ++i) {
                    float[] hls = hls_[i];
                    g.setColor((double)hls_[i][1] > 0.5 ? Color.black : Color.white);
                    g.fillRect(Math.round(hls_[i][1] * (float)(size.width - 2)), Math.round(hls_[i][2] * (float)(size.height - 2)), 2, 2);
                    g.drawString(colors_[i], Math.round(hls_[i][1] * (float)(size.width - 2)) + 2, Math.round(hls_[i][2] * (float)(size.height - 2)) + 10);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(512, 512);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

