/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.utilities.VersionStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MathFunctions {
    protected static Logger logger_ = Logger.getLogger(MathFunctions.class.getName());
    protected static int traceLimit_ = 10;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    static double smooth(double xMin, double xMax, double xControl, double yMin, double yMax, double yControl, double x) {
        double xMinP = xMin;
        double xMaxP = xMax;
        double xControlP = xControl;
        double yMinP = yMin;
        double yMaxP = yMax;
        double yControlP = yControl;
        double xP = x;
        try {
            double y;
            if (xMax >= xMin && (xControl > xMax || xControl < xMin) || xMax <= xMin && (xControl < xMax || xControl > xMin) || yMax >= yMin && (yControl > yMax || yControl < yMin) || yMax <= yMin && (yControl < yMax || yControl > yMin)) {
                throw new IllegalArgumentException("xControl,yControl must be in the xMin-xMax,yMin-yMax range.");
            }
            x -= xControl;
            xMin -= xControl;
            xMax -= xControl;
            yMin -= yControl;
            yMax -= yControl;
            if (xMin > xMax) {
                double tmp = xMin;
                xMin = xMax;
                xMax = tmp;
                x = -x;
            }
            if (x >= xMax) {
                return yMax + yControl;
            }
            if (x <= xMin) {
                return yMin + yControl;
            }
            if (yMin == yMax) {
                return yControl;
            }
            double xLimit = x < 0.0 ? xMin : xMax;
            double yLimit = x < 0.0 ? yMin : yMax;
            double xSlope = (yMax - yMin) / (xMax - xMin);
            double ySlope = (xMax - xMin) / (yMax - yMin);
            if (x == 0.0) {
                y = 0.0;
            } else if (xMin / xMax == yMin / yMax) {
                y = x * xSlope;
            } else if (x < 0.0 ^ xMin / xMax < yMin / yMax) {
                double yZero = yLimit - xLimit * xSlope;
                y = yZero * (x / xLimit) * (x / xLimit) + (yLimit - yZero) * x / xLimit;
            } else {
                double xZero = xLimit - yLimit * ySlope;
                double yIntercept = xSlope * x;
                if (xZero == 0.0) {
                    y = yIntercept;
                } else {
                    double a = xSlope * xSlope;
                    double b = -2.0 * xSlope * yIntercept - yLimit * yLimit / xZero;
                    double c = yIntercept * yIntercept;
                    double sign = x > 0.0 ? -1.0 : 1.0;
                    y = yIntercept - xSlope * (-b + sign * Math.sqrt(Math.abs(b * b - 4.0 * a * c))) / (2.0 * a);
                }
            }
            if (Double.isNaN(y)) {
                throw new RuntimeException("Double.isNaN(y).");
            }
            return y += yControl;
        }
        catch (Exception ex) {
            xMin = xMinP;
            xMax = xMaxP;
            xControl = xControlP;
            yMin = yMinP;
            yMax = yMaxP;
            yControl = yControlP;
            x = xP;
            if (traceLimit_ > 0) {
                --traceLimit_;
                logger_.log(Level.WARNING, "xMin:{0} xMax:{1} xControl:[2} yMin:{3} yMax:{4} yControl:{5} x:{6}", new String[]{"" + xMin, "" + xMax, "" + xControl, "" + yMin, "" + yMax, "" + yControl, "" + x});
                logger_.log(Level.WARNING, "" + ex, ex);
            }
            try {
                if (xMin > xMax) {
                    double tmp = xMin;
                    xMin = xMax;
                    xMax = tmp;
                    x = -x;
                }
                x = Math.max(x, xMin);
                double y = (x = Math.min(x, xMax)) < xControl ? yMin + (x - xMin) / (xControl - xMin) * (yControl - yMin) : yMax - (xMax - x) / (xMax - xControl) * (yMax - yControl);
                if (Double.isNaN(y)) {
                    throw new RuntimeException("Double.isNaN(y).");
                }
                return y;
            }
            catch (Exception exx) {
                return yControl;
            }
        }
    }
}

