/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.metal.MetalLabelUI;
import javax.swing.text.View;

public class CuiLabelUI
extends MetalLabelUI {
    protected static CuiLabelUI labelUI_ = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return labelUI_ != null ? labelUI_ : (labelUI_ = new CuiLabelUI());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension pref = super.getPreferredSize(c);
        if (pref.height % 2 != 0) {
            ++pref.height;
        }
        Dimension min = (Dimension)UIManager.get("Label.minimumSize");
        Dimension max = (Dimension)UIManager.get("Label.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    protected String layoutCL(JLabel l, FontMetrics fm, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        boolean rotate = l.getClientProperty("vertical") == Boolean.TRUE;
        rotate = rotate || !l.getComponentOrientation().isHorizontal();
        return Utilities.layoutCompoundLabel(l, fm, text, icon, l.getVerticalAlignment(), l.getHorizontalAlignment(), l.getVerticalTextPosition(), l.getHorizontalTextPosition(), viewR, iconR, textR, l.getIconTextGap(), rotate ? 1 : 0);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        Utilities.antiAlias((Graphics2D)g);
        JLabel l = (JLabel)c;
        String text = l.getText();
        Icon icon2 = icon = l.isEnabled() ? l.getIcon() : l.getDisabledIcon();
        if ((text == null || text.equals("")) && icon == null) {
            return;
        }
        Insets i = c.getInsets();
        int textIconGap = l.getIconTextGap();
        CuiLabelUI.viewRect.x = i.left;
        CuiLabelUI.viewRect.y = i.top;
        CuiLabelUI.viewRect.width = c.getWidth() - (i.left + i.right);
        CuiLabelUI.viewRect.height = c.getHeight() - (i.top + i.bottom);
        CuiLabelUI.textRect.height = 0;
        CuiLabelUI.textRect.width = 0;
        CuiLabelUI.textRect.y = 0;
        CuiLabelUI.textRect.x = 0;
        CuiLabelUI.iconRect.height = 0;
        CuiLabelUI.iconRect.width = 0;
        CuiLabelUI.iconRect.y = 0;
        CuiLabelUI.iconRect.x = 0;
        boolean rotate = c.getClientProperty("vertical") == Boolean.TRUE;
        rotate = rotate || !c.getComponentOrientation().isHorizontal();
        Font font = l.getFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        text = this.layoutCL(l, fm, text, icon, viewRect, iconRect, textRect);
        if (icon != null) {
            icon.paintIcon(c, g, CuiLabelUI.iconRect.x, CuiLabelUI.iconRect.y);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Utilities.paintView(v, g, textRect, rotate ? 1 : 0);
            } else {
                int textX = CuiLabelUI.textRect.x;
                int textY = CuiLabelUI.textRect.y + fm.getAscent();
                if (l.isEnabled()) {
                    this.paintEnabledText(l, g, text, textX, textY);
                } else {
                    this.paintDisabledText(l, g, text, textX, textY);
                }
            }
        }
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        boolean rotate = l.getClientProperty("vertical") == Boolean.TRUE;
        int mnemIndex = -1;
        rotate = rotate || !l.getComponentOrientation().isHorizontal();
        mnemIndex = l.getDisplayedMnemonicIndex();
        g.setColor(l.getForeground());
        Utilities.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY, rotate ? 1 : 0, l);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        boolean rotate = l.getClientProperty("vertical") == Boolean.TRUE;
        int mnemIndex = -1;
        rotate = rotate || !l.getComponentOrientation().isHorizontal();
        mnemIndex = l.getDisplayedMnemonicIndex();
        Utilities.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY, Utilities.getUIPropertyColor(l, "Label.disabledForeground"), l instanceof BasicComboBoxRenderer ? UIManager.getColor("ComboBox.text.disabledDropShadow") : Utilities.getUIPropertyColor(l, "Label.disabledDropShadow"), rotate ? 1 : 0, l);
    }
}

