/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class CuiPanelUI
extends BasicPanelUI {
    protected static CuiPanelUI panelUI_ = null;
    protected PropertyChangeListener propertyListener_ = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            JComponent component = (JComponent)pce.getSource();
            if ("background".equals(pce.getPropertyName()) && component.getBackground() != null && component.getBackground().getAlpha() < 255) {
                component.setOpaque(false);
            }
            if ("texture".equals(pce.getPropertyName())) {
                component.revalidate();
            }
        }
    };

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return panelUI_ != null ? panelUI_ : (panelUI_ = new CuiPanelUI());
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        if (component.getBackground() != null && component.getBackground().getAlpha() < 255) {
            component.setOpaque(false);
        }
        component.addPropertyChangeListener(this.propertyListener_);
    }

    @Override
    public void uninstallUI(JComponent component) {
        component.removePropertyChangeListener(this.propertyListener_);
        super.uninstallUI(component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Object picture = component.getClientProperty("picture");
        if (picture instanceof BufferedImage) {
            return new Dimension(((BufferedImage)picture).getWidth(), ((BufferedImage)picture).getHeight());
        }
        return super.getPreferredSize(component);
    }

    @Override
    public void update(Graphics graphics, JComponent component) {
        Color background = component.getBackground();
        Object texture = component.getClientProperty("texture");
        Object picture = component.getClientProperty("picture");
        if (component.isOpaque() || background.getAlpha() < 255) {
            Insets i = component.getBorder() instanceof CuiBorder ? component.getInsets() : new Insets(0, 0, 0, 0);
            graphics.setColor(background);
            graphics.fillRect(i.left, i.top, component.getWidth() - (i.left + i.right), component.getHeight() - (i.top + i.bottom));
        }
        if (texture instanceof BufferedImage) {
            Point ploc = component.getLocationOnScreen();
            Point floc = component.getRootPane().getLocationOnScreen();
            Rectangle2D.Double rect = new Rectangle2D.Double(floc.x - ploc.x, floc.y - ploc.y, ((BufferedImage)texture).getWidth(), ((BufferedImage)texture).getHeight());
            ((Graphics2D)graphics).setPaint(new TexturePaint((BufferedImage)texture, rect));
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
        }
        if (picture instanceof BufferedImage) {
            AffineTransform scale = AffineTransform.getScaleInstance((double)component.getWidth() / (double)((BufferedImage)picture).getWidth(), (double)component.getHeight() / (double)((BufferedImage)picture).getHeight());
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).drawImage((Image)picture, scale, null);
        }
        this.paint(graphics, component);
    }
}

