/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileOgee;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiSliderThumbIcon
implements Icon,
UIResource,
Serializable {
    protected int orientation_;
    private Dimension size_;
    protected double interiorEdge_;
    protected int textureStep_;
    protected int _5;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiSliderThumbIcon(int orientation) {
        double scale = CuiLookAndFeel.getScale();
        this.orientation_ = orientation;
        int x17 = (int)Math.round(17.0 * scale);
        int x18 = (int)Math.round(18.0 * scale);
        this.size_ = this.orientation_ == 0 ? new Dimension(x17, x18) : new Dimension(x18, x17);
        this.interiorEdge_ = CuiLookAndFeel.getInteriorEdge();
        this.textureStep_ = Math.max(4, (int)Math.round(4.0 * scale));
        this._5 = (int)Math.round(5.0 * scale);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage renderedShape;
        Color thumbColor;
        Rectangle cutout;
        JSlider slider = (JSlider)c;
        int pointer = slider.getPaintTicks() || slider.getPaintLabels() ? this._5 : 0;
        Dimension size = new Dimension(this.size_.width, this.size_.height);
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        String shapeID = "SliderThumb[" + this.size_ + "," + pointer + "]";
        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
        if (shape == null) {
            shape = new NamedShape(shapeID, this.orientation_ == 1 ? new Rectangle(0, 0, this.size_.width - pointer, this.size_.height) : new Rectangle(0, 0, this.size_.width, this.size_.height - pointer));
            Utilities.shapeCache_.put(shapeID, shape);
        }
        int edge = (int)Math.ceil(this.interiorEdge_);
        int textureCount = ((this.orientation_ == 1 ? this.size_.height : this.size_.width) - 2 * edge) / this.textureStep_;
        int cutoutTotal = Math.max(0, textureCount * this.textureStep_);
        Rectangle rectangle = !slider.isEnabled() ? null : (cutout = this.orientation_ == 1 ? new Rectangle(edge, (this.size_.height - cutoutTotal) / 2, this.size_.width - 2 * edge - pointer, cutoutTotal) : new Rectangle((this.size_.width - cutoutTotal) / 2, edge, cutoutTotal, this.size_.height - 2 * edge - pointer));
        Color color = !slider.isEnabled() && slider.getParent() != null && slider.getParent().getBackground() != null ? slider.getParent().getBackground() : (thumbColor = slider.getValueIsAdjusting() ? UIManager.getColor("Slider.select") : UIManager.getColor("Slider.thumb"));
        if (pointer > 0) {
            String pshapeID = "SliderPointer[" + this.size_ + "," + pointer + "]";
            Shape pshape = (Shape)Utilities.shapeCache_.get(pshapeID);
            if (pshape == null) {
                float[][] p = new float[][]{{(float)this.size_.width / 2.0f - (float)(pointer / 2), this.size_.height - pointer, (float)this.size_.width / 2.0f, this.size_.height, (float)this.size_.width / 2.0f + (float)(pointer / 2), this.size_.height - pointer}, {this.size_.width - pointer, (float)this.size_.height / 2.0f - (float)(pointer / 2), this.size_.width, (float)this.size_.height / 2.0f, this.size_.width - pointer, (float)this.size_.height / 2.0f + (float)(pointer / 2)}};
                int i = this.orientation_ == 1 ? 1 : 0;
                GeneralPath path = new GeneralPath();
                path.moveTo(p[i][0], p[i][1]);
                path.lineTo(p[i][2], p[i][3]);
                path.lineTo(p[i][4], p[i][5]);
                path.closePath();
                pshape = new NamedShape(pshapeID, path);
                Utilities.shapeCache_.put(pshapeID, pshape);
            }
            BufferedImage renderedShape2 = RenderedShapeFactory.getRenderedShape(this.size_, pshape, null, slider.isEnabled() ? slider.getForeground() : UIManager.getColor("P4"), slider.isOpaque() ? slider.getBackground() : new Color(0, true), null);
            g.drawImage(renderedShape2, x, y, null);
        }
        if (slider.isEnabled()) {
            if (this.orientation_ == 1) {
                renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(cutout.width, this.textureStep_), new Rectangle2D.Double((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, (double)cutout.width - (double)this.textureStep_ / 2.0, (double)this.textureStep_ - (double)this.textureStep_ / 2.0), new EdgeProfileOgee((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, -0.01), thumbColor, thumbColor, null);
                for (int i = 0; i < textureCount; ++i) {
                    g.drawImage(renderedShape, x + cutout.x, y + cutout.y + i * this.textureStep_, null);
                }
            } else {
                renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(this.textureStep_, cutout.height), new Rectangle2D.Double((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, (double)this.textureStep_ - (double)this.textureStep_ / 2.0, (double)cutout.height - (double)this.textureStep_ / 2.0), new EdgeProfileOgee((double)this.textureStep_ / 4.0, (double)this.textureStep_ / 4.0, -0.01), thumbColor, thumbColor, null);
                for (int i = 0; i < textureCount; ++i) {
                    g.drawImage(renderedShape, x + cutout.x + i * this.textureStep_, y + cutout.y, null);
                }
            }
        }
        renderedShape = RenderedShapeFactory.getRenderedShape(this.size_, shape, new EdgeProfileRounded(this.interiorEdge_, 0.0), thumbColor, new Color(0, true), cutout);
        g.drawImage(renderedShape, x, y, null);
    }

    @Override
    public int getIconWidth() {
        return this.size_.width;
    }

    @Override
    public int getIconHeight() {
        return this.size_.height;
    }
}

