/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class CuiSliderUI
extends MetalSliderUI {
    protected Icon thumbIcon_;
    protected double scale_;
    protected PropertyChangeListener propertyChangeListener_ = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (!"orientation".equals(name)) {
                return;
            }
            JSlider slider = (JSlider)e.getSource();
            CuiSliderUI.this.uninstallUI(slider);
            CuiSliderUI.this.installUI(slider);
        }
    };

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return new CuiSliderUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.thumbIcon_ = UIManager.getIcon(((JSlider)c).getOrientation() == 0 ? "Slider.horizontalThumbIcon" : "Slider.verticalThumbIcon");
        this.scale_ = CuiLookAndFeel.getScale();
        super.installUI(c);
        this.slider.addPropertyChangeListener(this.propertyChangeListener_);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.slider.removePropertyChangeListener(this.propertyChangeListener_);
        super.uninstallUI(c);
    }

    @Override
    public int getTickLength() {
        return (int)Math.round((double)(this.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3) * this.scale_);
    }

    @Override
    protected int getTrackWidth() {
        double kIdealTrackWidth = 7.0 * this.scale_;
        double kIdealThumbHeight = 16.0 * this.scale_;
        double kWidthScalar = kIdealTrackWidth / kIdealThumbHeight;
        if (this.slider.getOrientation() == 0) {
            return (int)(kWidthScalar * (double)this.thumbRect.height);
        }
        return (int)(kWidthScalar * (double)this.thumbRect.width);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(this.thumbIcon_.getIconWidth(), this.thumbIcon_.getIconHeight());
    }

    @Override
    protected int getThumbOverhang() {
        int pointer = this.slider.getPaintTicks() || this.slider.getPaintLabels() ? 5 : 0;
        return (int)(this.getThumbSize().getHeight() - (double)pointer - (double)this.getTrackWidth()) / 2 + pointer;
    }

    @Override
    public void paintThumb(Graphics g) {
        this.thumbIcon_.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
    }

    @Override
    public void paintTrack(Graphics g) {
        Color trackColor = this.slider.getParent() != null && this.slider.getParent().getBackground() != null ? this.slider.getParent().getBackground() : Utilities.getUIPropertyColor(this.slider, "Slider.track", Color.gray);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - this.getThumbOverhang();
            trackTop = trackBottom - this.getTrackWidth();
            trackLeft = 0;
            trackRight = this.trackRect.width;
        } else {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang();
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth();
            }
            trackTop = 0;
            trackBottom = this.trackRect.height;
        }
        if (this.slider.isEnabled()) {
            // empty if block
        }
        int edge = (int)Math.ceil(CuiLookAndFeel.getExteriorEdge());
        Dimension size = new Dimension(trackRight - trackLeft, trackBottom - trackTop);
        Point location = new Point(this.trackRect.x + trackLeft, this.trackRect.y + trackTop);
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(2 * edge + 1, 2 * edge + 1), new Rectangle(edge, edge, 1, 1), new EdgeProfileRounded(0.0, CuiLookAndFeel.getExteriorEdge()), trackColor, this.slider.isOpaque() ? this.slider.getBackground() : new Color(0, true), null);
        new StretchedImageIcon(renderedShape, size.width, size.height).paintIcon(this.slider, g, location.x, location.y);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("P4"));
        g.drawLine(x, 4, x, 4 + tickLength / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("P4"));
        g.drawLine(x, 4, x, 4 + (tickLength - 1));
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("P4"));
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            g.drawLine(4, y, 4 + tickLength / 2, y);
        } else {
            g.drawLine(0, y, tickLength / 2, y);
        }
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("P4"));
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            g.drawLine(4, y, 4 + tickLength, y);
        } else {
            g.drawLine(0, y, tickLength, y);
        }
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        if (label instanceof JComponent) {
            ((JComponent)label).setEnabled(this.slider.isEnabled());
        }
        super.paintHorizontalLabel(g, value, label);
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        if (label instanceof JComponent) {
            ((JComponent)label).setEnabled(this.slider.isEnabled());
        }
        super.paintVerticalLabel(g, value, label);
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        Dimension pref = super.getPreferredHorizontalSize();
        pref.setSize((int)Math.round((double)pref.width * this.scale_), (int)Math.round((double)pref.height * this.scale_));
        Dimension min = (Dimension)UIManager.get("Slider.horizontalMinimumSize");
        Dimension max = (Dimension)UIManager.get("Slider.horizontalMaximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        Dimension pref = super.getPreferredVerticalSize();
        pref.setSize((int)Math.round((double)pref.width * this.scale_), (int)Math.round((double)pref.height * this.scale_));
        Dimension min = (Dimension)UIManager.get("Slider.verticalMinimumSize");
        Dimension max = (Dimension)UIManager.get("Slider.verticalMaximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        Dimension d = super.getMinimumHorizontalSize();
        return new Dimension((int)Math.round((double)d.width * this.scale_), (int)Math.round((double)d.height * this.scale_));
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        Dimension d = super.getMinimumVerticalSize();
        return new Dimension((int)Math.round((double)d.width * this.scale_), (int)Math.round((double)d.height * this.scale_));
    }
}

