/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class CuiToggleButtonUI
extends MetalToggleButtonUI {
    protected static CuiToggleButtonUI ToggleButtonUI_ = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return ToggleButtonUI_ != null ? ToggleButtonUI_ : (ToggleButtonUI_ = new CuiToggleButtonUI());
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        boolean rotate = b.getClientProperty("vertical") == Boolean.TRUE;
        int gap = 0;
        rotate = rotate || !b.getComponentOrientation().isHorizontal();
        gap = b.getIconTextGap();
        Dimension pref = Utilities.getPreferredButtonSize(b, gap, rotate ? 1 : 0);
        if (pref.height % 2 != 0) {
            ++pref.height;
        }
        Dimension min = (Dimension)UIManager.get("ToggleButton.minimumSize");
        Dimension max = (Dimension)UIManager.get("ToggleButton.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Utilities.antiAlias((Graphics2D)g);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Insets i = c.getInsets();
        CuiToggleButtonUI.viewRect.x = i.left;
        CuiToggleButtonUI.viewRect.y = i.top;
        CuiToggleButtonUI.viewRect.width = c.getWidth() - (i.left + i.right);
        CuiToggleButtonUI.viewRect.height = c.getHeight() - (i.top + i.bottom);
        CuiToggleButtonUI.textRect.height = 0;
        CuiToggleButtonUI.textRect.width = 0;
        CuiToggleButtonUI.textRect.y = 0;
        CuiToggleButtonUI.textRect.x = 0;
        CuiToggleButtonUI.iconRect.height = 0;
        CuiToggleButtonUI.iconRect.width = 0;
        CuiToggleButtonUI.iconRect.y = 0;
        CuiToggleButtonUI.iconRect.x = 0;
        boolean rotate = c.getClientProperty("vertical") == Boolean.TRUE || !c.getComponentOrientation().isHorizontal();
        int textIconGap = b.getIconTextGap();
        Icon icon = b.getIcon();
        Font font = b.getFont();
        g.setFont(font);
        String text = Utilities.layoutCompoundLabel(c, g.getFontMetrics(), b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, textIconGap, rotate ? 1 : 0);
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (icon != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Utilities.paintView(v, g, textRect, rotate ? 1 : 0);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!Utilities.paintButtonBackground(g, b, "ToggleButton")) {
            super.paintButtonPressed(g, b);
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        Utilities.paintText(g, b, "ToggleButton", textRect, text);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Utilities.paintText(g, (AbstractButton)c, "ToggleButton", textRect, text);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isBorderPainted() && b.getBorder() instanceof CuiBorder) {
            return;
        }
        super.paintFocus(g, b, viewRect, textRect, iconRect);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Utilities.paintButtonBackground(g, (AbstractButton)c, "ToggleButton");
        super.update(g, c);
    }
}

