/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiButtonBorder;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalToolBarUI;

public class CuiToolBarUI
extends MetalToolBarUI {
    protected Border rolloverBorder_;
    protected Border nonRolloverBorder_;
    protected boolean isRollover_ = false;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c) {
        return new CuiToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.rolloverBorder_ = new RolloverButtonBorder();
        this.nonRolloverBorder_ = new CuiButtonBorder.UIResource(CuiLookAndFeel.getInteriorEdge(), 0.0, 0.0);
        super.installUI(c);
    }

    @Override
    protected Border createRolloverBorder() {
        return this.rolloverBorder_;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return this.nonRolloverBorder_;
    }

    @Override
    protected void setBorderToRollover(Component c) {
        super.setBorderToRollover(c);
        this.isRollover_ = true;
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setFocusPainted(false);
            if (b.isSelected()) {
                b.setContentAreaFilled(true);
            } else {
                b.setContentAreaFilled(false);
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(this.createRolloverBorder());
            }
        }
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
        super.setBorderToNonRollover(c);
        this.isRollover_ = false;
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setFocusPainted(false);
            b.setContentAreaFilled(true);
            b.setOpaque(false);
            b.setBorder(this.createNonRolloverBorder());
        }
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new ContainerListener(){
            MouseListener rolloverListener_ = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (CuiToolBarUI.this.isRollover_ && e.getSource() instanceof AbstractButton) {
                        this.updateButtonProperties((AbstractButton)e.getSource());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (CuiToolBarUI.this.isRollover_ && e.getSource() instanceof AbstractButton) {
                        this.updateButtonProperties((AbstractButton)e.getSource());
                    }
                }
            };
            ChangeListener stateChangeListener_ = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (CuiToolBarUI.this.isRollover_ && e.getSource() instanceof AbstractButton) {
                        this.updateButtonProperties((AbstractButton)e.getSource());
                    }
                }
            };

            protected void updateButtonProperties(AbstractButton b) {
                b.setContentAreaFilled(b.isSelected() || b.getModel().isPressed() && b.getModel().isArmed());
                b.setOpaque(false);
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (CuiToolBarUI.this.toolBarFocusListener != null) {
                    c.addFocusListener(CuiToolBarUI.this.toolBarFocusListener);
                }
                if (CuiToolBarUI.this.isRolloverBorders()) {
                    CuiToolBarUI.this.setBorderToRollover(c);
                } else {
                    CuiToolBarUI.this.setBorderToNonRollover(c);
                }
                if (c instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)c;
                    this.updateButtonProperties(b);
                    b.addMouseListener(this.rolloverListener_);
                    b.addChangeListener(this.stateChangeListener_);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (CuiToolBarUI.this.toolBarFocusListener != null) {
                    c.removeFocusListener(CuiToolBarUI.this.toolBarFocusListener);
                }
                CuiToolBarUI.this.setBorderToNormal(c);
                if (c instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)c;
                    b.removeMouseListener(this.rolloverListener_);
                    b.removeChangeListener(this.stateChangeListener_);
                }
            }
        };
    }

    protected static class RolloverButtonBorder
    extends CuiButtonBorder {
        public RolloverButtonBorder() {
            super(CuiLookAndFeel.getInteriorEdge(), 0.0, 0.0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed()) || model.isSelected()) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }
}

