/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.CPointBase;
import java.awt.Point;
import java.awt.geom.Point2D;

public class CPoint
extends CPointBase {
    public CPoint() {
    }

    public CPoint(byte csystem) {
        super(csystem);
    }

    public CPoint(double[] p, byte csystem) {
        super(p, csystem);
    }

    public CPoint(double x, double y, double z, byte csystem) {
        super(x, y, z, csystem);
    }

    public CPoint(Point2D p, byte csystem) {
        this(p.getX(), p.getY(), 0.0, csystem);
    }

    public CPoint(int x, int y, int z, byte csystem) {
        super(x, y, z, csystem);
    }

    public CPoint(CPoint other) {
        super(other.x, other.y, other.z, other.csystem);
    }

    public CPoint(CPoint p0, CPoint p) {
        this(p);
        this.subtract(p0);
    }

    public CPoint(Point p0, Point p) {
        super(p.getX() - p0.getX(), p.getY() - p0.getY(), 0.0, (byte)1);
    }

    public CPoint(Point p) {
        super(p.getX(), p.getY(), 0.0, (byte)1);
    }

    @Override
    public Object clone() {
        return new CPoint(this);
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CPoint) {
            if (((CPoint)other).csystem != this.csystem) {
                return false;
            }
            return super.equals(other);
        }
        return false;
    }

    public final CPoint cross(CPoint p, CPoint r) {
        r.csystem = this.csystem;
        r.x = this.y * p.z - p.y * this.z;
        r.y = -this.x * p.z + this.z * p.x;
        r.z = this.x * p.y - this.y * p.x;
        return r;
    }

    public final CPoint cross(CPoint p) {
        CPoint r = new CPoint(this.csystem);
        return this.cross(p, r);
    }

    public final void setPoint(Point p0, Point p) {
        this.x = p.getX() - p0.getX();
        this.y = p.getY() - p0.getY();
        this.z = 0.0;
        this.csystem = 1;
    }

    public CPoint(JnPoint2D p0, JnPoint2D p) {
        super(p.getX() - p0.getX(), p.getY() - p0.getY(), 0.0, (byte)1);
    }
}

