/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

public abstract class Draw2DUtilsBase {
    public static void lineFast(int x0, int y0, int x1, int y1, Raster1D raster) {
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        int rw = raster.getWidth();
        if (dy < 0) {
            dy = -dy;
            stepy = -rw;
        } else {
            stepy = rw;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        y1 *= rw;
        raster.setPixel(x0 + (y0 *= rw));
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                raster.setPixel((x0 += stepx) + y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                raster.setPixel(x0 + (y0 += stepy));
            }
        }
    }

    public static void lineBresenham(int x0, int y0, int x1, int y1, Raster2D raster) {
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        raster.setPixel(x0, y0);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                raster.setPixel(x0 += stepx, y0);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                raster.setPixel(x0, y0 += stepy);
            }
        }
    }

    public static interface Raster2D {
        public int getWidth();

        public int getHeight();

        public void clear();

        public void setPixel(int var1, int var2);
    }

    public static interface Raster1D {
        public int getWidth();

        public int getHeight();

        public void clear();

        public void setPixel(int var1);
    }
}

