/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ResourceMonitor {
    File procfs = null;
    File statusfs = null;
    File statfs = null;
    Properties props = new Properties();
    private static final String jiffies = " jiffies";

    private final void boot() throws IOException {
        if (this.procfs == null) {
            this.procfs = new File("/proc/self");
            if (!this.procfs.exists()) {
                throw new IOException("no procfs entry");
            }
            this.statusfs = new File(this.procfs, "status");
            this.statfs = new File(this.procfs, "stat");
        }
    }

    public Measurement getCurrentMeasurement() throws IOException {
        String line;
        this.boot();
        this.props.clear();
        BufferedReader r = new BufferedReader(new FileReader(this.statusfs));
        while ((line = r.readLine()) != null) {
            String[] kv = line.split("[:\\s+]", 2);
            if (kv.length != 2) continue;
            this.props.setProperty(kv[0].trim(), kv[1].trim());
        }
        r.close();
        r = new BufferedReader(new FileReader(this.statfs));
        while ((line = r.readLine()) != null) {
            int i;
            String[] z = line.split("[\\s+]");
            if (z.length <= 38 || !z[1].startsWith("(")) continue;
            for (i = 1; i < z.length && !z[i].endsWith(")"); ++i) {
            }
            if (i >= z.length) continue;
            this.props.setProperty("MinFLT", z[i + 8] + jiffies);
            this.props.setProperty("MajFLT", z[i + 10] + jiffies);
            this.props.setProperty("UTime", z[i + 12] + jiffies);
            this.props.setProperty("STime", z[i + 13] + jiffies);
        }
        r.close();
        return new Measurement(this.props);
    }

    public static void main(String[] args) {
        try {
            ResourceMonitor rm = new ResourceMonitor();
            for (int i = 0; i < 20; ++i) {
                Measurement m = rm.getCurrentMeasurement();
                System.out.println("#" + i + ": " + m);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class Measurement
    implements Map {
        private Properties props;
        public static final String VmRSS = "VmRSS";
        public static final String VmSize = "VmSize";
        public static final String Time = "Time";
        public static final String Pid = "Pid";
        public static final String MinFLT = "MinFLT";
        public static final String MajFLT = "MajFLT";
        public static final String UTime = "UTime";
        public static final String STime = "STime";

        public String getProperty(String key) {
            return this.props.getProperty(key);
        }

        public int getIntegerProperty(String key) {
            String value = this.getProperty(key);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                String[] c = value.split("[\\s+]");
                if (c.length == 1) {
                    return Integer.parseInt(c[0]);
                }
                if (c.length == 2) {
                    int units = 1;
                    if (c[1].equalsIgnoreCase("kb")) {
                        units = 1024;
                    } else if (c[1].equalsIgnoreCase("mb")) {
                        units = 0x100000;
                    } else if (c[1].equalsIgnoreCase("gb")) {
                        units = 0x40000000;
                    } else if (c[1].equalsIgnoreCase("jiffies")) {
                        units = 10;
                    } else {
                        throw new NumberFormatException("unknown units " + c[1]);
                    }
                    return Integer.parseInt(c[0]) * units;
                }
                throw ex;
            }
        }

        Measurement(Properties props) {
            this.props = (Properties)props.clone();
            this.props.setProperty(Time, Long.toString(System.currentTimeMillis()));
        }

        private void cat(String key, StringBuffer acc) {
            acc.append(key);
            acc.append('=');
            acc.append(this.getProperty(key));
            acc.append(';');
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName());
            buf.append('{');
            this.cat(Pid, buf);
            this.cat(Time, buf);
            this.cat(VmRSS, buf);
            this.cat(VmSize, buf);
            this.cat(UTime, buf);
            this.cat(STime, buf);
            buf.append('}');
            return buf.toString();
        }

        @Override
        public int hashCode() {
            return this.props.hashCode();
        }

        @Override
        public int size() {
            return this.props.size();
        }

        @Override
        public void clear() {
            this.props.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.props.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.props.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.props.containsValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Measurement) {
                return this.props.equals(((Measurement)o).props);
            }
            return false;
        }

        public Collection values() {
            return this.props.values();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return this.props.entrySet();
        }

        public Set keySet() {
            return this.props.keySet();
        }

        public Object get(Object key) {
            return this.props.get(key);
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

