/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.XpViewport;

public class SimpleAlphaCombiner
implements XjFusionPixelCombiner {
    private static final int SHIFT = 12;
    private static final int SCALE = 4096;
    private double alpha = 0.5;
    private boolean color = false;
    private XpViewport iv = null;

    public SimpleAlphaCombiner(XpViewport viewport) {
        this.iv = viewport;
    }

    public void setColor(boolean color) {
        this.color = color;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.iv.refreshContents();
        this.iv.repaint();
    }

    @Override
    public void blendRGB(int[][] pixels, int width, int height, int[] result) {
        int ialpha = (int)(this.alpha * 4096.0);
        int len = width * height;
        int D = 4096 - ialpha;
        if (this.color) {
            for (int i = 0; i < len; ++i) {
                int pixel1 = pixels[0][i];
                int bval1 = pixel1 & 0xFF;
                int gval1 = (pixel1 & 0xFF00) >> 8;
                int rval1 = (pixel1 & 0xFF0000) >> 16;
                int pixel2 = pixels[1][i];
                int bval2 = pixel2 & 0xFF;
                int gval2 = (pixel2 & 0xFF00) >> 8;
                int rval2 = (pixel2 & 0xFF0000) >> 16;
                int rval = rval1 * ialpha + rval2 * D >> 12;
                int gval = gval1 * ialpha + gval2 * D >> 12;
                int bval = bval1 * ialpha + bval2 * D >> 12;
                result[i] = 0xFF000000 | rval << 16 | gval << 8 | bval;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int pixel1 = pixels[0][i] & 0xFF;
                int pixel2 = pixels[1][i] & 0xFF;
                int val = pixel1 * ialpha + pixel2 * D >> 12;
                result[i] = 0xFF000000 | val << 16 | val << 8 | val;
            }
        }
    }
}

