/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.demo.keyimagenote;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.platform.dm.KeyImageNote;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KeyImageNoteDemo
extends JPanel {
    public static final int VERT_PADDING = 5;
    public static final int HORIZ_PADDING = 10;
    private XpSeriesDisplayer seriesDisplayer = new XpSeriesDisplayer(2, 2);
    private JPanel controlPanel = new JPanel();
    private JPanel kinPanel = new JPanel();
    private JPanel loadSavePanel = new JPanel();
    private JList kinJList = new JList();
    private JScrollPane kinScrollPane;
    private JScrollPane observationPane;
    private JTextArea observationArea;
    private DefaultListModel kinListModel = new DefaultListModel();
    private JButton createButton;
    private JButton saveButton;
    private JButton loadButton;
    private boolean ignoreListEvent = false;
    private boolean ignorePropChange = false;
    ArrayList<KeyImageNote> kinList = new ArrayList();

    public KeyImageNoteDemo(String path) {
        this.seriesDisplayer.addPropertyChangeListener("ComponentSelection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!KeyImageNoteDemo.this.ignorePropChange) {
                    KeyImageNoteDemo.this.ignoreListEvent = true;
                    KeyImageNoteDemo.this.selectKINs();
                    KeyImageNoteDemo.this.ignoreListEvent = false;
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.createControlPanel();
        this.add((Component)this.controlPanel, "West");
        this.add((Component)this.seriesDisplayer, "Center");
        DMImage[] imgs = null;
        if (path != null) {
            DMSession dms = new DMSession(new String[]{"file", path});
            DMObject[] series = dms.getRelated("Series");
            imgs = series[0].getImages(null);
        } else {
            JOptionPane.showMessageDialog(this, "Image Path chosen is null.", "Key Image Note Viewer", 0);
        }
        if (imgs != null) {
            this.seriesDisplayer.setImages(imgs);
        } else {
            JOptionPane.showMessageDialog(this, "Failure to obtain images from DMSession.", "Key Image Note Viewer", 0);
        }
        this.seriesDisplayer.setRowCol(3, 3);
    }

    private void createControlPanel() {
        this.createButton = new JButton("Create Key Image Note");
        this.createButton.setToolTipText("Create Key Image Note from selected images in display panel.");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyImageNoteDemo.this.openCreateKINFrame();
            }
        });
        this.saveButton = new JButton("Save Selected Key Image Notes");
        this.saveButton.setToolTipText("Select a directory and save the selected Key Image Notes to it.");
        this.saveButton.addActionListener(new SaveKIN());
        this.loadButton = new JButton("Load Key Image Notes");
        this.loadButton.setToolTipText("Select one or more Key Image Note files and load them to the panel.");
        this.loadButton.addActionListener(new LoadKIN());
        this.kinPanel.setLayout(new BorderLayout());
        this.kinScrollPane = new JScrollPane(this.kinJList);
        this.observationArea = new JTextArea("Key Image Note Display");
        this.observationArea.setFont(new Font("MyFont", 1, 12));
        this.observationArea.setPreferredSize(new Dimension(200, 200));
        this.observationArea.setBackground(Color.YELLOW);
        this.observationPane = new JScrollPane(this.observationArea);
        this.kinJList.setModel(this.kinListModel);
        this.kinJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!KeyImageNoteDemo.this.ignoreListEvent) {
                    if (KeyImageNoteDemo.this.kinJList.getSelectedIndex() != -1) {
                        KeyImageNote selectedKIN = (KeyImageNote)KeyImageNoteDemo.this.kinListModel.getElementAt(KeyImageNoteDemo.this.kinJList.getSelectedIndex());
                        String observationText = selectedKIN.toStringBulk();
                        KeyImageNoteDemo.this.observationArea.setText(observationText);
                    }
                    KeyImageNoteDemo.this.ignorePropChange = true;
                    KeyImageNoteDemo.this.selectLinkedImages();
                    KeyImageNoteDemo.this.ignorePropChange = false;
                }
            }
        });
        this.controlPanel.setLayout(new BorderLayout());
        this.loadSavePanel.setLayout(new BorderLayout());
        this.loadSavePanel.add((Component)this.saveButton, "North");
        this.loadSavePanel.add((Component)this.loadButton, "South");
        this.kinScrollPane.setVerticalScrollBarPolicy(20);
        this.kinScrollPane.setHorizontalScrollBarPolicy(30);
        this.kinPanel.add((Component)this.kinScrollPane, "Center");
        this.kinPanel.add((Component)this.observationPane, "South");
        this.kinPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.controlPanel.add((Component)this.createButton, "North");
        this.controlPanel.add((Component)this.kinPanel, "Center");
        this.controlPanel.add((Component)this.loadSavePanel, "South");
        this.controlPanel.setPreferredSize(new Dimension(250, 250));
    }

    private void openCreateKINFrame() {
        int[] selectedIndices = this.seriesDisplayer.getComponentSelections();
        if (null == selectedIndices) {
            JOptionPane.showMessageDialog(null, "Please select an image to link to Key Image Note", "Create Key Image Note", 0);
        } else {
            int size = selectedIndices.length;
            XpMedicalImage[] imagesSelected = new XpMedicalImage[size];
            for (int i = 0; i < imagesSelected.length; ++i) {
                imagesSelected[i] = (XpMedicalImage)this.seriesDisplayer.getFrame(this.seriesDisplayer.getFrameIndex() + selectedIndices[i]);
            }
            JFrame ancestor = (JFrame)this.getTopLevelAncestor();
            JFrame jf = new JFrame("Create Key Image Note");
            jf.setContentPane(new KeyImageNoteCreatePanel(imagesSelected));
            jf.setBounds(ancestor.getX(), ancestor.getY(), ancestor.getWidth() / 2, ancestor.getHeight() / 2);
            jf.setVisible(true);
            this.selectKINs();
        }
    }

    private void selectKINs() {
        ArrayList<XpMedicalImage> selImages = new ArrayList<XpMedicalImage>();
        for (int i = 0; i < this.seriesDisplayer.getNumScenes(); ++i) {
            XpImageScene scene2 = this.seriesDisplayer.getScene(i);
            if (scene2.getSelectedState() <= 0) continue;
            selImages.add((XpMedicalImage)scene2.getFrame());
        }
        XpMedicalImage[] imgs = selImages.toArray(new XpMedicalImage[0]);
        HashSet<Integer> selectedListMembers = new HashSet<Integer>();
        for (int i = 0; i < this.kinListModel.size(); ++i) {
            selectedListMembers.add(i);
        }
        for (int j = 0; j < imgs.length; ++j) {
            try {
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                KeyImageNote[] linkedKINs = this.getLinkedKIN(imgs[j]);
                if (0 < linkedKINs.length) {
                    this.observationArea.setText(linkedKINs[0].toStringBulk());
                } else {
                    this.observationArea.setText("");
                }
                for (int k = 0; k < linkedKINs.length; ++k) {
                    if (!selectedListMembers.contains(this.kinListModel.indexOf(linkedKINs[k]))) continue;
                    tempList.add(this.kinListModel.indexOf(linkedKINs[k]));
                }
                selectedListMembers.clear();
                selectedListMembers.addAll(tempList);
                continue;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Unable to select Key Image Notes", "Select Key Image Notes", 0);
            }
        }
        Integer[] arraySelectedListMembers = new Integer[selectedListMembers.size()];
        selectedListMembers.toArray(arraySelectedListMembers);
        int[] selections = new int[selectedListMembers.size()];
        for (int index = 0; index < selectedListMembers.size(); ++index) {
            selections[index] = arraySelectedListMembers[index];
        }
        this.kinJList.setSelectedIndices(selections);
    }

    private void selectLinkedImages() {
        if (this.kinJList.getSelectedIndex() != -1) {
            this.seriesDisplayer.setComponentSelection(-1);
            KeyImageNote selectedKIN = (KeyImageNote)this.kinListModel.getElementAt(this.kinJList.getSelectedIndex());
            XpMedicalImage[] linkedImages = this.getLinkedImages(selectedKIN);
            XpMedicalImage[] sdImages = this.seriesDisplayer.getImages();
            for (int i = 0; i < sdImages.length; ++i) {
                for (int j = 0; j < linkedImages.length; ++j) {
                    if (sdImages[i] != linkedImages[j]) continue;
                    this.seriesDisplayer.setComponentSelection(i - this.seriesDisplayer.getFrameIndex());
                }
            }
        }
        this.ignorePropChange = false;
    }

    private XpMedicalImage[] getLinkedImages(KeyImageNote kin) {
        String[] linkedImageUIDs = kin.getLinkedImageUIDs();
        XpMedicalImage[] sdImgs = this.seriesDisplayer.getImages();
        HashSet<XpMedicalImage> linkedImages = new HashSet<XpMedicalImage>();
        for (XpMedicalImage img : sdImgs) {
            XpDicomElement imageSOPElement = new XpDicomElement(8, 24);
            img.getValue(imageSOPElement);
            for (String linkedImageUID : linkedImageUIDs) {
                if (!linkedImageUID.equals("" + imageSOPElement.value)) continue;
                linkedImages.add(img);
            }
        }
        return linkedImages.toArray(new XpMedicalImage[0]);
    }

    private KeyImageNote[] getLinkedKIN(XpMedicalImage image) throws IOException {
        ArrayList<KeyImageNote> linkedKINs = new ArrayList<KeyImageNote>();
        XpDicomElement imageSOPElement = new XpDicomElement(8, 24);
        image.getValue(imageSOPElement);
        for (int i = 0; i < this.kinList.size(); ++i) {
            String[] kinImageUIDs = this.kinList.get(i).getLinkedImageUIDs();
            for (int j = 0; j < kinImageUIDs.length; ++j) {
                if (!kinImageUIDs[j].equals("" + imageSOPElement.value)) continue;
                linkedKINs.add(this.kinList.get(i));
            }
        }
        KeyImageNote[] arrayLinkedKINs = new KeyImageNote[linkedKINs.size()];
        linkedKINs.toArray(arrayLinkedKINs);
        return arrayLinkedKINs;
    }

    public void addKeyImageNote(KeyImageNote kin) {
        this.kinList.add(kin);
        this.kinListModel.addElement(kin);
        this.kinJList.repaint();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Key Image Note Viewer");
        String path = null;
        if (args.length > 0) {
            path = args[0];
        }
        KeyImageNoteDemo demo = new KeyImageNoteDemo(path);
        frame.setBounds(30, 30, 1200, 900);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(demo);
        frame.setVisible(true);
        frame.repaint();
    }

    private class KeyImageNoteCreatePanel
    extends JPanel {
        public static final int HORIZ_PADDING = 20;
        public static final int VERT_PADDING = 10;
        private String[] titleCodes;
        private String[] titles;
        private String[] subtitleCodesQualityReasons;
        private String[] subtitlesQualityReasons;
        private String[] subtitleCodesBestInSet;
        private String[] subtitlesBestInSet;
        private Map<String, String> titleMap = KeyImageNote.getTitleMap();
        private Map<String, String> subtitleQualityReasonsMap = KeyImageNote.getSubtitleQualityReasonsMap();
        private Map<String, String> subtitleBestInSetMap = KeyImageNote.getsubtitleBestInSetMap();
        private JPanel titlePanel;
        private JPanel observationPanel;
        private JPanel savePanel;
        private JLabel observationLabel;
        private JTextArea observationArea;
        private JLabel titleLabel;
        private JComboBox titleCombo;
        private JPanel subtitlePanel;
        private JLabel subtitleLabel;
        private JComboBox subtitleCombo;
        private JButton saveButton;
        private JButton cancelButton;
        private XpMedicalImage[] linkedImages;

        public XpMedicalImage[] getLinkedImages() {
            return this.linkedImages;
        }

        public void setLinkedImages(XpMedicalImage[] linkedImages) {
            this.linkedImages = linkedImages;
        }

        public KeyImageNoteCreatePanel(XpMedicalImage[] linkedImages) {
            this.setLinkedImages(linkedImages);
            this.initComponents();
            this.setLayout(new BorderLayout());
            this.add((Component)this.titlePanel, "North");
            this.add((Component)this.observationPanel, "Center");
            this.add((Component)this.savePanel, "South");
        }

        private void initComponents() {
            this.titleCodes = this.titleMap.keySet().toArray(new String[0]);
            this.titles = this.titleMap.values().toArray(new String[0]);
            this.subtitleCodesQualityReasons = this.subtitleQualityReasonsMap.keySet().toArray(new String[0]);
            this.subtitlesQualityReasons = this.subtitleQualityReasonsMap.values().toArray(new String[0]);
            this.subtitleCodesBestInSet = this.subtitleBestInSetMap.keySet().toArray(new String[0]);
            this.subtitlesBestInSet = this.subtitleBestInSetMap.values().toArray(new String[0]);
            this.observationLabel = new JLabel("Enter KIN text below:");
            this.observationArea = new JTextArea();
            this.subtitleLabel = new JLabel("Subtitle:");
            this.subtitleCombo = new JComboBox();
            this.titleLabel = new JLabel("Title");
            this.titleCombo = new JComboBox<String>(this.titles);
            this.titleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KeyImageNoteCreatePanel.this.titleCodes[KeyImageNoteCreatePanel.this.titleCombo.getSelectedIndex()] == "113001" || KeyImageNoteCreatePanel.this.titleCodes[KeyImageNoteCreatePanel.this.titleCombo.getSelectedIndex()] == "113010") {
                        this.addSubtitlePanel(KeyImageNoteCreatePanel.this.subtitlesQualityReasons);
                    } else if (KeyImageNoteCreatePanel.this.titleCodes[KeyImageNoteCreatePanel.this.titleCombo.getSelectedIndex()] == "113013") {
                        this.addSubtitlePanel(KeyImageNoteCreatePanel.this.subtitlesBestInSet);
                    }
                }

                private void addSubtitlePanel(String[] subtitles) {
                    KeyImageNoteCreatePanel.this.subtitleCombo.removeAllItems();
                    for (int i = 0; i < subtitles.length; ++i) {
                        KeyImageNoteCreatePanel.this.subtitleCombo.addItem(subtitles[i]);
                    }
                    KeyImageNoteCreatePanel.this.titlePanel.add((Component)KeyImageNoteCreatePanel.this.subtitlePanel, "South");
                    KeyImageNoteCreatePanel.this.invalidate();
                    KeyImageNoteCreatePanel.this.validate();
                    KeyImageNoteCreatePanel.this.repaint();
                }
            });
            this.saveButton = new JButton("Create");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyImageNoteCreatePanel.this.saveKIN();
                    JFrame parent = (JFrame)KeyImageNoteCreatePanel.this.getTopLevelAncestor();
                    if (null != parent) {
                        parent.dispose();
                    }
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrame parent = (JFrame)KeyImageNoteCreatePanel.this.getTopLevelAncestor();
                    if (null != parent) {
                        parent.dispose();
                    }
                }
            });
            this.subtitlePanel = new JPanel();
            this.subtitlePanel.setLayout(new BorderLayout());
            this.subtitlePanel.add((Component)this.subtitleLabel, "Center");
            this.subtitlePanel.add((Component)this.subtitleCombo, "South");
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new BorderLayout());
            this.titlePanel.add((Component)this.titleLabel, "North");
            this.titlePanel.add((Component)this.titleCombo, "Center");
            this.titlePanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.observationPanel = new JPanel();
            this.observationPanel.setLayout(new BorderLayout());
            this.observationPanel.add((Component)this.observationLabel, "North");
            this.observationPanel.add((Component)this.observationArea, "Center");
            this.observationPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.savePanel = new JPanel();
            this.savePanel.setLayout(new FlowLayout());
            this.savePanel.add(this.saveButton);
            this.savePanel.add(this.cancelButton);
            this.savePanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        }

        public void saveKIN() {
            String titleCode = this.titleCodes[this.titleCombo.getSelectedIndex()];
            String observation = this.observationArea.getText();
            String subtitleCode = null;
            if ("113001".equals(this.titleCodes[this.titleCombo.getSelectedIndex()]) || "113010".equals(this.titleCodes[this.titleCombo.getSelectedIndex()])) {
                subtitleCode = this.subtitleCodesQualityReasons[this.subtitleCombo.getSelectedIndex()];
            } else if ("113013".equals(this.titleCodes[this.titleCombo.getSelectedIndex()])) {
                subtitleCode = this.subtitleCodesBestInSet[this.subtitleCombo.getSelectedIndex()];
            }
            KeyImageNote kin = new KeyImageNote(titleCode, observation, this.linkedImages, subtitleCode, null, null);
            KeyImageNoteDemo.this.addKeyImageNote(kin);
        }
    }

    private class SaveKIN
    implements ActionListener {
        private SaveKIN() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser dirChooser = new JFileChooser();
            dirChooser.setFileSelectionMode(1);
            dirChooser.setApproveButtonText("Save Selected Key Notes");
            dirChooser.setDialogTitle("Select Directory to save Key Notes");
            int returnval = dirChooser.showDialog(KeyImageNoteDemo.this.controlPanel, null);
            if (returnval == 0) {
                for (int i = 0; i < KeyImageNoteDemo.this.kinList.size(); ++i) {
                    if (!KeyImageNoteDemo.this.kinJList.isSelectedIndex(i)) continue;
                    OutputStream fos = null;
                    try {
                        String fname = dirChooser.getSelectedFile().getAbsolutePath() + File.separator + i + "_" + KeyImageNoteDemo.this.kinList.get(i).getTitle();
                        System.out.println("** Saving to: " + fname);
                        InputStream is = KeyImageNoteDemo.this.kinList.get(i).getDicomKIN();
                        fos = new FileOutputStream(fname);
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = is.read(buffer)) > 0) {
                            ((FileOutputStream)fos).write(buffer, 0, len);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Problem saving Key Image Note " + i + ": " + ex, "Save Key Image Note", 0);
                        continue;
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.flush();
                                ((FileOutputStream)fos).close();
                            }
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(null, "Unable to close Key Image Note file output stream", "Save Key Image Note", 0);
                        }
                    }
                }
            }
        }
    }

    private class LoadKIN
    implements ActionListener {
        private LoadKIN() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(KeyImageNoteDemo.this.kinPanel);
            if (returnVal == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                System.out.println("Attempting to load " + filename);
                try {
                    FileInputStream fis = new FileInputStream(filename);
                    KeyImageNote kin = KeyImageNote.getKeyImageNote(fis);
                    if (kin != null) {
                        if (KeyImageNoteDemo.this.getLinkedImages(kin).length != 0) {
                            KeyImageNoteDemo.this.addKeyImageNote(kin);
                        } else {
                            JOptionPane.showMessageDialog(KeyImageNoteDemo.this.seriesDisplayer, filename + " has no images present in this series.");
                        }
                    } else {
                        JOptionPane.showMessageDialog(KeyImageNoteDemo.this.seriesDisplayer, filename + " is not a valid Key Image Note.");
                    }
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(KeyImageNoteDemo.this.seriesDisplayer, "Error Loading KIN Object from file " + filename + ": " + ex);
                }
            }
        }
    }
}

