/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import com.ge.med.terra.jami.XpLog;
import java.awt.Point;

public class ConeSlice {
    private int w;
    private int h;
    public static double ADJUSTED_DECAY = 0.0;
    private int maxpixel = 255;

    public void create(short[] d, int w, int h, int solidR, int decayR, double decayX, boolean invert, int pixelFormat) {
        this.w = w;
        this.h = h;
        switch (pixelFormat) {
            case 0: {
                this.maxpixel = 255;
                break;
            }
            case 1: {
                this.maxpixel = 511;
                break;
            }
            case 2: {
                this.maxpixel = 4095;
                break;
            }
            case 3: {
                this.maxpixel = 32766;
                break;
            }
            case 4: {
                this.maxpixel = 65534;
                break;
            }
            default: {
                XpLog.logger().severe("XpPatternImage: probably cannot handle format " + pixelFormat);
            }
        }
        int bgcolor = invert ? this.maxpixel : 0;
        d = this.fillBackGround(d, bgcolor);
        Point center = new Point(w / 2, h / 2);
        d = this.drawHazedCircle(d, solidR, decayR, decayX, invert);
    }

    private short[] drawSolidCircle(short[] d, int solidR, Point center, int color) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int ytop = y0 - solidR;
        int ybottom = y0 + solidR;
        if (ytop < 0) {
            ytop = 0;
        }
        if (ybottom > this.h) {
            ybottom = this.h;
        }
        for (int y = ytop; y < ybottom; ++y) {
            int w = (int)Math.sqrt(Math.pow(solidR, 2.0) - Math.pow(y - y0, 2.0));
            if (w > this.w / 2) {
                w = this.w / 2;
            }
            int startPixel = y * this.w + (x0 - w);
            int endPixel = startPixel + 2 * w;
            for (int i = startPixel; i < endPixel; ++i) {
                d[i] = (short)color;
            }
        }
        return d;
    }

    private short[] drawHazedCircle(short[] d, int solidR, int decayR, double decayX, boolean invert) {
        int x = decayR - solidR;
        Point center = new Point(this.w / 2, this.h / 2);
        boolean b = false;
        if (x < 0) {
            x = decayR;
        }
        for (int i = 0; i < x; ++i) {
            int color = invert ? (int)((double)this.maxpixel * (1.0 - Math.exp((double)(-(x - i)) / decayX))) : (int)((double)this.maxpixel * Math.exp((double)(-(x - i)) / decayX));
            d = this.drawSolidCircle(d, solidR + (x - i), center, color);
        }
        int centerColor = invert ? 0 : this.maxpixel;
        d = this.drawSolidCircle(d, solidR, center, centerColor);
        return d;
    }

    private short[] fillBackGround(short[] d, int color) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = (short)color;
        }
        return d;
    }
}

