/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import com.ge.med.terra.jami.XpLog;
import java.text.DecimalFormat;

public class GVTK {
    private static final DecimalFormat df = new DecimalFormat("00000000");
    private static short MAXPIXEL = (short)2047;
    private static String[] digits = new String[]{"@@@@@  @@  @@  @@@@@@", "   @   @   @   @   @", "@@@@   @@@@@@   @@@@", "@@@@   @@@@@   @@@@@", "@  @@  @@@@@   @   @", "@@@@@   @@@@   @@@@@", "@   @   @@@@@  @@@@@", "@@@@   @   @   @   @", "@@@@@  @@@@@@  @@@@@", "@@@@@  @@@@@   @   @"};

    public static void fillWithTestPattern(short[] p, int width, int height, int pixelFormat, int seq) {
        int x;
        int y;
        int maxpixel = MAXPIXEL;
        switch (pixelFormat) {
            case 1: {
                maxpixel = 511;
                break;
            }
            case 2: {
                maxpixel = 4095;
                break;
            }
            case 3: {
                maxpixel = Short.MAX_VALUE;
                break;
            }
            case 4: {
                maxpixel = 65535;
                break;
            }
            default: {
                XpLog.logger().warning("XpPatternImage: probably cannot handle format " + pixelFormat);
            }
        }
        int w2 = width / 2;
        int h2 = height / 2;
        int border = w2 / 7 + 2;
        short[] d = p;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        for (y = 0; y < height; ++y) {
            float frac = (float)y / (float)(height - 1);
            frac += fseq;
            while ((double)frac > 1.0) {
                frac = (float)((double)frac - 1.0);
            }
            while ((double)frac < 0.0) {
                frac = (float)((double)frac + 1.0);
            }
            int val = (int)(frac * (float)maxpixel);
            for (x = 0; x < width; ++x) {
                d[x + y * width] = (short)val;
            }
        }
        for (y = border; y < h2 - border; ++y) {
            for (x = border; x < w2 - border; ++x) {
                d[y * width + x] = (short)maxpixel;
            }
        }
        for (y = border; y < h2 - border; ++y) {
            for (x = width - w2 + border; x < width - border; ++x) {
                d[y * width + x] = 0;
            }
        }
        int lwidth = 1;
        x = border;
        while (x + lwidth < width) {
            for (y = h2 + border; y < height - border; ++y) {
                for (int l = 0; l < lwidth; ++l) {
                    d[y * width + x + l] = 0;
                }
            }
            x += 2 * (lwidth += 2);
        }
        int num_digits = (w2 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            String strBuff = df.format(seq);
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            strBuff.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                char charDig = sbuf[nd + max_digits - num_digits];
                int ix = charDig - 48;
                String digitStr = digits[ix];
                digitStr.getChars(0, digitStr.length() - 1, digit, 0);
                for (x = 0; x < 4; ++x) {
                    for (y = 0; y < 5; ++y) {
                        if (digit[x + y * 4] != '@') continue;
                        d[x0 + x + (y + y0) * width] = 0;
                    }
                }
            }
        }
    }

    public static void fillWithTestPattern(byte[] p, int width, int height, int seq) {
        int x;
        int y;
        int maxpixel = 255;
        int w2 = width / 2;
        int h2 = height / 2;
        int border = w2 / 7 + 2;
        byte[] d = p;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        for (y = 0; y < height; ++y) {
            float frac = (float)y / (float)(height - 1);
            frac += fseq;
            while ((double)frac > 1.0) {
                frac = (float)((double)frac - 1.0);
            }
            while ((double)frac < 0.0) {
                frac = (float)((double)frac + 1.0);
            }
            int val = (int)(frac * (float)maxpixel);
            for (x = 0; x < width; ++x) {
                d[x + y * width] = (byte)val;
            }
        }
        for (y = border; y < h2 - border; ++y) {
            for (x = border; x < w2 - border; ++x) {
                d[x + y * width] = (byte)maxpixel;
            }
        }
        for (y = border; y < h2 - border; ++y) {
            for (x = width - w2 + border; x < width - border; ++x) {
                d[x + y * width] = 0;
            }
        }
        int lwidth = 1;
        x = border;
        while (x + lwidth < width) {
            for (y = h2 + border; y < height - border; ++y) {
                for (int l = 0; l < lwidth; ++l) {
                    d[x + l + y * width] = 0;
                }
            }
            x += 2 * (lwidth += 2);
        }
        int num_digits = (w2 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            String strBuff = df.format(seq);
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            strBuff.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                char charDig = sbuf[nd + max_digits - num_digits];
                int ix = charDig - 48;
                String digitStr = digits[ix];
                digitStr.getChars(0, digitStr.length() - 1, digit, 0);
                for (x = 0; x < 4; ++x) {
                    for (y = 0; y < 5; ++y) {
                        if (digit[x + y * 4] != '@') continue;
                        d[x0 + x + (y + y0) * width] = 0;
                    }
                }
            }
        }
    }

    public static void fillWithColorTestPattern(byte[] p, int width, int height, int seq) {
        int x;
        int y;
        int maxpixel = 255;
        int w = width;
        int h = height;
        int w2 = w / 2;
        int h2 = h / 2;
        int border = w2 / 7 + 2;
        float const1 = (float)(h - 1) / (float)(w - 1);
        float const2 = -const1;
        float const3 = h - 1;
        byte[] d = p;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        if (w <= 1 || h <= 1) {
            XpLog.logger().warning("Image size is too small.");
            return;
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                byte val;
                double frac;
                if ((float)y >= const1 * (float)x) {
                    if ((float)y >= const2 * (float)x + const3) {
                        frac = (float)((double)h - 1.0 - (double)y) / (float)h2;
                        d[3 * (x + y * w) + 2] = val = (byte)(frac * (double)maxpixel);
                        d[3 * (x + y * w) + 1] = val;
                        frac = 1.0 - ((double)x - (double)((float)((double)h - 1.0 - (double)y)) * ((double)w - 1.0) / ((double)h - 1.0)) / ((double)w - 1.0);
                        d[3 * (x + y * w)] = val = (byte)(frac * (double)maxpixel);
                        continue;
                    }
                    frac = ((double)h - 1.0 - ((double)y - (double)x * ((double)h - 1.0) / ((double)w - 1.0))) / ((double)h - 1.0);
                    d[3 * (x + y * w) + 2] = val = (byte)(frac * (double)maxpixel);
                    frac = 2.0 * (double)x / ((double)w - 1.0);
                    d[3 * (x + y * w) + 1] = val = (byte)(frac * (double)maxpixel);
                    frac = ((double)y + (double)x * ((double)h - 1.0) / ((double)w - 1.0)) / ((double)w - 1.0);
                    d[3 * (x + y * w)] = val = (byte)(frac * (double)maxpixel);
                    continue;
                }
                if ((float)y >= const2 * (float)x + const3) {
                    frac = ((double)w - 1.0 - (double)x) * 2.0 / ((double)w - 1.0);
                    d[3 * (x + y * w)] = val = (byte)(frac * (double)maxpixel);
                    d[3 * (x + y * w) + 2] = val;
                    frac = ((double)((float)((double)h - 1.0) - (float)y) + (double)((float)((double)h - 1.0)) * ((double)w - 1.0 - (double)x) / ((double)h - 1.0)) / ((double)h - 1.0);
                    d[3 * (x + y * w) + 1] = val = (byte)(frac * (double)maxpixel);
                    continue;
                }
                frac = ((double)w - 1.0 - (double)x + ((double)w - 1.0) * (double)y / ((double)h - 1.0)) / ((double)w - 1.0);
                d[3 * (x + y * w) + 2] = val = (byte)(frac * (double)maxpixel);
                frac = ((double)x + ((double)w - 1.0) * (double)y / ((double)h - 1.0)) / ((double)w - 1.0);
                d[3 * (x + y * w) + 1] = val = (byte)(frac * (double)maxpixel);
                frac = (float)y / (float)h2;
                d[3 * (x + y * w)] = val = (byte)(frac * (double)maxpixel);
            }
        }
        double x_center = (double)border + 3.0 * ((double)w2 - 2.0 * (double)border) / 4.0;
        double y_center = (double)border + 3.0 * ((double)h2 - 2.0 * (double)border) / 4.0;
        double radius_square = 9.0 * ((double)w2 - 2.0 * (double)border) * ((double)w2 - 2.0 * (double)border) / 256.0;
        double inner_radius_square = (3.0 * ((double)w2 - 2.0 * (double)border) / 16.0 - 0.5) * (3.0 * ((double)w2 - 2.0 * (double)border) / 16.0 - 0.5);
        double outer_radius_square = (3.0 * ((double)w2 - 2.0 * (double)border) / 16.0 + 0.5) * (3.0 * ((double)w2 - 2.0 * (double)border) / 16.0 + 0.5);
        for (y = border; y < h2 - border; ++y) {
            for (x = border; x < w2 - border; ++x) {
                if ((float)y <= (float)h2 * (1.0f - (float)x / (float)w2) - 1.0f) {
                    d[3 * (x + y * w)] = (byte)maxpixel;
                    d[3 * (x + y * w) + 1] = (byte)maxpixel;
                    d[3 * (x + y * w) + 2] = (byte)maxpixel;
                    continue;
                }
                d[3 * (x + y * w)] = 0;
                d[3 * (x + y * w) + 1] = (byte)maxpixel;
                d[3 * (x + y * w) + 2] = 0;
                if (!(((double)x - x_center) * ((double)x - x_center) + ((double)y - y_center) * ((double)y - y_center) <= radius_square)) continue;
                d[3 * (x + y * w)] = (byte)maxpixel;
                d[3 * (x + y * w) + 1] = 0;
                d[3 * (x + y * w) + 2] = 0;
            }
        }
        x_center = (double)(w - w2 + border) + 1.0 * ((double)w2 - 2.0 * (double)border) / 4.0 - 1.0;
        for (y = border; y < h2 - border; ++y) {
            for (x = w - w2 + border; x < w - border; ++x) {
                double radius_square_cur;
                d[3 * (x + y * w)] = 0;
                d[3 * (x + y * w) + 1] = 0;
                d[3 * (x + y * w) + 2] = 0;
                if ((double)y >= (double)((float)(h - h2) * ((float)x / (float)(w - w2) - 1.0f)) - 0.5 && (double)y < (double)((float)(h - h2) * ((float)x / (float)(w - w2) - 1.0f)) + 0.5) {
                    d[3 * (x + y * w)] = 0;
                    d[3 * (x + y * w) + 1] = (byte)maxpixel;
                    d[3 * (x + y * w) + 2] = (byte)maxpixel;
                }
                if (!((radius_square_cur = ((double)x - x_center) * ((double)x - x_center) + ((double)y - y_center) * ((double)y - y_center)) >= inner_radius_square) || !(radius_square_cur < outer_radius_square)) continue;
                d[3 * (x + y * w)] = 0;
                d[3 * (x + y * w) + 1] = 0;
                d[3 * (x + y * w) + 2] = (byte)maxpixel;
            }
        }
        int lwidth = 1;
        x = border;
        while (x + lwidth < width) {
            byte value_red;
            int quotient = lwidth / 8;
            int reminder = lwidth - quotient * 8;
            byte value_green = value_red = (byte)((float)quotient / (float)(quotient + 1) * (float)maxpixel);
            byte value_blue = value_red;
            switch (reminder) {
                case 1: 
                case 3: {
                    value_red = (byte)maxpixel;
                    break;
                }
                case 5: {
                    value_green = (byte)maxpixel;
                    break;
                }
                case 7: {
                    value_blue = (byte)maxpixel;
                    break;
                }
                default: {
                    XpLog.logger().severe("XpPatternImage: internal error");
                }
            }
            for (y = h2 + border; y < height - border; ++y) {
                for (int l = 0; l < lwidth; ++l) {
                    d[3 * (x + l + y * w) + 2] = value_red;
                    d[3 * (x + l + y * w) + 1] = value_green;
                    d[3 * (x + l + y * w)] = value_blue;
                }
            }
            x += 2 * (lwidth += 2);
        }
        int num_digits = (w2 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            String strBuf = df.format(seq);
            strBuf.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                int ix = sbuf[nd + max_digits - num_digits] - 48;
                String strDigit = digits[ix];
                strDigit.getChars(0, strDigit.length() - 1, digit, 0);
                for (x = 0; x < 4; ++x) {
                    for (y = 0; y < 5; ++y) {
                        if (digit[x + y * 4] != '@') continue;
                        d[3 * (x0 + x + (y + y0) * w)] = 0;
                        d[3 * (x0 + x + (y + y0) * w) + 1] = 0;
                        d[3 * (x0 + x + (y + y0) * w) + 2] = 0;
                    }
                }
            }
        }
    }
}

