/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import java.awt.Point;

public class Sphere {
    private int w;
    private int h;

    public void create(byte[] d, int w, int h, int solidR, int decayR, double decayX, boolean invert) {
        this.w = w;
        this.h = h;
        int max = -1;
        boolean min = false;
        int bgcolor = 0xFFCCCC;
        d = this.fillBackGround(d, bgcolor);
        Point center = new Point(w / 2, h / 2);
        d = this.drawSphere(d, solidR, decayR, decayX, invert);
    }

    private byte[] drawSolidCircle(byte[] d, int solidR, Point center, int color) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int ytop = y0 - solidR;
        int ybottom = y0 + solidR;
        for (int y = ytop; y < ybottom; ++y) {
            int w = (int)Math.sqrt(Math.pow(solidR, 2.0) - Math.pow(y - y0, 2.0));
            int startPixel = y * this.w * 3 + (x0 - w) * 3;
            int endPixel = startPixel + 2 * w * 3;
            for (int i = startPixel; i < endPixel; i += 3) {
                d[i] = (byte)(color >> 16 & 0xFF);
                d[i + 1] = (byte)(color >> 8 & 0xFF);
                d[i + 2] = (byte)(color >> 0 & 0xFF);
            }
        }
        return d;
    }

    private byte[] drawSphere(byte[] d, int solidR, int decayR, double decayX, boolean invert) {
        int x = decayR - solidR;
        Point center = new Point(this.w / 2, this.h / 2);
        int b = 0;
        if (x < 0) {
            x = decayR;
        }
        for (int i = 0; i < x; ++i) {
            b = invert ? (int)(255.0 * (1.0 - Math.exp((double)(-i) / decayX))) & 0xFF : (int)(255.0 * Math.exp((double)(-i) / decayX)) & 0xFF;
            int color = (b << 16) + (b << 8) + b;
            d = this.drawSolidCircle(d, solidR + (x - i), center, color);
        }
        d = this.drawSolidCircle(d, solidR, center, 0);
        return d;
    }

    private byte[] fillBackGround(byte[] d, int color) {
        for (int i = 0; i < d.length; i += 3) {
            d[i] = (byte)(color >> 16 & 0xFF);
            d[i + 1] = (byte)(color >> 8 & 0xFF);
            d[i + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d;
    }
}

