/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DDepthBufferCapable;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.mpr.mpr;
import com.ge.med.terra.jami.seg.BinGrid;
import com.ge.med.terra.jami.seg.BinSeg;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JFrame;

public class BingridVc
extends XpVisualComponent {
    private static ParallelTaskManager ptm = new ParallelTaskManager();
    private Color ocolor = Color.green;
    private Color bgColor = new Color(0, true);
    private boolean smoothDisplay = true;
    private mpr mpr_ = new mpr(2);
    private byte[] bits_ = null;
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private int browsize = 0;
    private int bpgsize = 0;
    private boolean forceRefresh = true;
    private short[] outdata = null;
    private float[] depthbuffer = null;
    private BufferedImage bimg = null;
    private int[] cmap = new int[2049];
    private double[] _eyePoint = new double[3];
    private double[] _lookPoint = new double[3];
    private double[] _up = new double[3];
    private double _viewHeight = -1.0;
    private boolean bgVisible = true;
    private T3DComponent t3d = null;
    private boolean ignoreDepthRstyle = false;
    private Object lockBuff = new Object();

    public BingridVc(T3DComponent tc) {
        this.t3d = tc;
        this.setOverlayColor(Color.green);
        this.t3d.addPropertyChangeListener("ALL_LAYERS_COMPLETE_PROPERTY", new DepthBufferSync());
        this.t3d.addPropertyChangeListener("RENDER_FINISH", new IterativePaintSync());
    }

    public Color getBingridBackgroundColor() {
        return this.bgColor;
    }

    public void setBingridBackgroundColor(Color bgc) {
        this.bgColor = bgc;
        this.setOverlayColor(this.ocolor);
    }

    public void setIgnoreDepthRenderStyle(boolean ignoreDepthRenderStyle) {
        this.ignoreDepthRstyle = ignoreDepthRenderStyle;
    }

    public void setOverlayColor(Color c) {
        int ibgColor;
        this.ocolor = c;
        int alpha = 127;
        this.cmap[0] = ibgColor = this.bgColor.getAlpha() << 24 | this.bgColor.getRGB();
        for (int i = 1; i < this.cmap.length; ++i) {
            double scale = (double)i / (double)this.cmap.length;
            int red = (int)((double)c.getRed() * scale);
            int green = (int)((double)c.getGreen() * scale);
            int blue = (int)((double)c.getBlue() * scale);
            this.cmap[i] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        this.refreshContents();
    }

    public Color getOverlayColor() {
        return this.ocolor;
    }

    public void setBingridVisible(boolean bgVisible) {
        this.bgVisible = bgVisible;
        this.refreshContents();
    }

    public boolean isBingridVisible() {
        return this.bgVisible;
    }

    public void setBingrid(BinGrid bgrid) {
        this.bits_ = bgrid.bingrid;
        this.dx = bgrid.dx;
        this.dy = bgrid.dy;
        this.dz = bgrid.dz;
        this.browsize = this.dx + 7 >> 3;
        this.bpgsize = this.browsize * this.dy;
        this.refreshContents();
    }

    public void setBingrid(byte[] bgrid, int dx, int dy, int dz) {
        this.bits_ = bgrid;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.browsize = dx + 7 >> 3;
        this.bpgsize = this.browsize * dy;
        this.refreshContents();
    }

    public void setBingrid(BinSeg bseg) {
        this.dx = bseg.dx;
        this.dy = bseg.dy;
        this.dz = bseg.dz;
        this.browsize = this.dx + 7 >> 3;
        this.bpgsize = this.browsize * this.dy;
        this.refreshContents();
    }

    public void setSmoothDisplay(boolean smoothDisplay) {
        this.smoothDisplay = smoothDisplay;
    }

    public boolean isSmoothDisplay() {
        return this.smoothDisplay;
    }

    public void refreshContents() {
        this.forceRefresh = true;
        this.repaint();
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    private static double diffvec(double[] v1, double[] v2) {
        return Math.abs(v1[0] - v2[0]) + Math.abs(v1[1] - v2[1]) + Math.abs(v1[2] - v2[2]);
    }

    public static boolean isThin(String rstyle, double thickness) {
        int rcode = Commons3D.getRenderStyleCode(rstyle);
        switch (rcode) {
            case 5: 
            case 6: 
            case 8: {
                return false;
            }
        }
        return rcode == 0 || rcode == 1 || rcode == 9 || rcode == 10 || !(thickness > 1.0E-10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (!this.bgVisible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.bits_ != null) {
            double[] vclips = new double[2];
            this.t3d.getViewClip(vclips);
            double thickness = Math.abs(vclips[1] - vclips[0]);
            double[] ras_lookpt = this.t3d.getRenderedLookPoint(null);
            double[] ras_eyept = this.t3d.getRenderedEyePoint(null);
            double[] ras_up = this.t3d.getRenderedUp(null);
            double viewHeight = this.t3d.getRenderedViewHeight();
            double diffEye = BingridVc.diffvec(ras_eyept, this._eyePoint);
            double diffLook = BingridVc.diffvec(ras_lookpt, this._lookPoint);
            double diffUp = BingridVc.diffvec(ras_up, this._up);
            double diffVHeight = Math.abs(viewHeight - this._viewHeight);
            System.arraycopy(ras_eyept, 0, this._eyePoint, 0, 3);
            System.arraycopy(ras_lookpt, 0, this._lookPoint, 0, 3);
            System.arraycopy(ras_up, 0, this._up, 0, 3);
            if (diffEye > 1.0E-10 || diffLook > 1.0E-10 || diffUp > 1.0E-10 || diffVHeight > 1.0E-10 || this.forceRefresh) {
                XpSlice slice = this.t3d.getMedicalImage().getSlice();
                String rstyle = this.t3d.getRenderStyle();
                int w = this.getWidth();
                int h = this.getHeight();
                int len = w * h;
                if (this.bimg == null || this.bimg.getWidth() != w || this.bimg.getHeight() != h) {
                    this.outdata = new short[len];
                    this.bimg = new BufferedImage(w, h, 2);
                }
                int[] idata = ((DataBufferInt)this.bimg.getRaster().getDataBuffer()).getData();
                int ibgColor = this.bgColor.getAlpha() << 24 | this.bgColor.getRGB();
                Arrays.fill(idata, ibgColor);
                Arrays.fill(this.outdata, (short)-1);
                int nocontentPix = -2000;
                int interpolation = this.smoothDisplay ? 1 : 0;
                double[] vox_lookpt = new double[]{ras_lookpt[0], ras_lookpt[1], ras_lookpt[2]};
                CTransform ras2vox = this.t3d.getTransform((byte)2, (byte)5);
                double pX = slice.pixelSizeX;
                double pY = slice.pixelSizeY;
                slice.I.normalize();
                slice.J.normalize();
                double[] zero = new double[]{0.0, 0.0, 0.0};
                double[] I2 = new double[]{slice.I.x * pX, slice.I.y * pX, slice.I.z * pX};
                double[] J = new double[]{slice.J.x * pY, slice.J.y * pY, slice.J.z * pY};
                double[] N = new double[]{slice.N.x, slice.N.y, slice.N.z};
                ras2vox.transform(vox_lookpt);
                ras2vox.transform(zero);
                ras2vox.transform(I2);
                ras2vox.transform(J);
                ras2vox.transform(N);
                JnVector3d.sub(I2, zero, I2);
                JnVector3d.sub(J, zero, J);
                JnVector3d.sub(N, zero, N);
                if (!BingridVc.isThin(rstyle, thickness) && !this.ignoreDepthRstyle) {
                    T3DDepthBufferCapable tdbc = (T3DDepthBufferCapable)((Object)this.t3d.getCapable(T3DDepthBufferCapable.class.getCanonicalName()));
                    if (tdbc != null && this.depthbuffer != null) {
                        Object object = this.lockBuff;
                        synchronized (object) {
                            int dbidx = 0;
                            double[] pt = new double[3];
                            int i = 0;
                            while (i < this.outdata.length) {
                                float rx = this.depthbuffer[dbidx];
                                float ry = this.depthbuffer[dbidx + 1];
                                float rz = this.depthbuffer[dbidx + 2];
                                if (rx > -99999.0f || ry > -99999.0f || rz > -99999.0f) {
                                    int bmod;
                                    int bidx;
                                    pt[0] = rx;
                                    pt[1] = ry;
                                    pt[2] = rz;
                                    ras2vox.transform(pt);
                                    int ix = (int)pt[0];
                                    int iy = (int)pt[1];
                                    int iz = (int)pt[2];
                                    if (ix >= 0 && iy >= 0 && iz >= 0 && ix < this.dx && iy < this.dy && iz < this.dz && (this.bits_[bidx = iz * this.bpgsize + iy * this.browsize + (ix >> 3)] & 1 << (bmod = ix % 8)) != 0) {
                                        idata[i] = this.cmap[2038];
                                    }
                                }
                                ++i;
                                dbidx += 3;
                            }
                        }
                    }
                } else {
                    long t0 = System.currentTimeMillis();
                    this.mpr_.setView(vox_lookpt, I2, J, N, 0.0, w, h, this.dx, this.dy, this.dz, interpolation, -2000);
                    int x0 = 0;
                    int y0 = 0;
                    int x1 = w - 1;
                    int y1 = h - 1;
                    int xskip = 1;
                    int yskip = 1;
                    if (this.smoothDisplay) {
                        this.mpr_.mpr_tl(x0, y0, x1, y1, xskip, yskip, this.bits_, this.outdata, w, h);
                    } else {
                        this.mpr_.mpr_nn(x0, y0, x1, y1, xskip, yskip, this.bits_, this.outdata, w, h);
                    }
                    for (int i = 0; i < this.outdata.length; ++i) {
                        if (this.outdata[i] < 0) continue;
                        idata[i] = this.cmap[this.outdata[i]];
                    }
                    long l = System.currentTimeMillis();
                }
            }
            g2.drawRenderedImage(this.bimg, null);
            this.forceRefresh = true;
        }
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("BingridVc");
        T3DViewport vs3d = new T3DViewport();
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        vs3d.setVolume(vol);
        J3DVolumeModel jvm = (J3DVolumeModel)vs3d.getVolumeModel();
        jvm.init();
        BingridVc bvc = new BingridVc(vs3d.getT3DComponent());
        bvc.setBingrid(jvm.vr_context.getBaseBingrid(), jvm.j_vol.dx, jvm.j_vol.dy, jvm.j_vol.dz);
        vs3d.getT3DComponent().add(bvc);
        jf.setContentPane(vs3d);
        vs3d.setPreferredSize(new Dimension(600, 600));
        jf.pack();
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
    }

    static /* synthetic */ float[] access$202(BingridVc x0, float[] x1) {
        x0.depthbuffer = x1;
        return x1;
    }

    private class IterativePaintSync
    implements PropertyChangeListener {
        private IterativePaintSync() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            BingridVc.this.repaint();
        }
    }

    private class DepthBufferSync
    implements PropertyChangeListener {
        private DepthBufferSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            int width = BingridVc.this.getWidth();
            int height = BingridVc.this.getHeight();
            if (BingridVc.this.depthbuffer == null || BingridVc.this.depthbuffer.length != width * height * 3) {
                BingridVc.access$202(BingridVc.this, new float[width * height * 3]);
            }
            T3DComponent tc = (T3DComponent)BingridVc.this.getParent();
            T3DDepthBufferCapable tdbc = (T3DDepthBufferCapable)((Object)tc.getCapable(T3DDepthBufferCapable.class.getCanonicalName()));
            Object object = BingridVc.this.lockBuff;
            synchronized (object) {
                tdbc.getDepthBuffer(BingridVc.this.depthbuffer);
            }
            BingridVc.this.forceRefresh = true;
        }
    }
}

